# Сетевые доступы

**Сетевые доступы** ("дырки") - это правила в фаерволах Яндекса, разрешающие или запрещающие доступ по сети к определенным ресурсам.  На данной странице содержится информация обо всех сетевых доступах, которые могут вам понадобиться в процессе разработки. Если в процессе работы вы получаете таймауты или ошибки доступа по сети - убедитесь, что у вас заказаны все правила, приведенные ниже.

Проверить существующие правила фаервола или заказать новые можно через сервис [Puncher](https://puncher.yandex-team.ru/). У каждого правила есть **источник** (source) и **приёмник** (destination). **Источник** - пользователь (сотрудник, робот) или сервер, откуда отправляются данные. **Приёмник** - сетевой балансировщик ([SLB](https://en.wikipedia.org/wiki/Load_balancing_(computing))) или сервер, куда отправляются данные. Для того, чтобы не писать правила по-отдельности для каждого пользователя или сервера, в правилах используются сокращения. Например, вместо указания логина пользователя рекомендуется указывать название его группы на [Staff](https://staff.yandex-team.ru/) или сервиса в [ABC](https://abc.yandex-team.ru/). Вместо того, чтобы писать имя конкретного сервера, обычно указывается **сетевой макрос** - т.е. группа IP-адресов, где стоит сервер (например, `_CMSEARCHNETS_`). Единственный случай, когда в качестве приёмника пишется имя хоста - это при создании правила до сетевого балансировщика (SLB), например, `arcanum.yandex.net`.

## Доступы для пользователей

Базовые сервисы разработческой инфраструктуры – Arc, Arcanum и Sandbox, по умолчанию доступны для всех штатных сотрудников Яндекса при подключении с личных компьютеров из внутренней сети или по VPN.

Доступы к Arc и Arcanum для внешних сотрудников выдаются автоматически в рамках [согласования](../src/outstaff.md) их работы в Аркадии.

Доступы с разработческих серверов и виртуалок необходимо заказывать:

Описание | Источник | Приёмник
:--- | :--- | :---
Arc | Хост или сетевой макрос | `arc-vcs.yandex-team.ru` порты `443, 5624` <br/> `pulld.arc-vcs.yandex-team.ru` порт `7059` <br/> `get.arc-vcs.yandex.net` порт `443`
Arcanum | Хост или сетевой макрос | `arcanum.yandex.net` порт `443` <br/> `arcanum.yandex-team.ru` порт `443`
Sandbox | Хост или сетевой макрос | `sandbox.yandex-team.ru` порт `443` <br/> `proxy.sandbox.yandex-team.ru` порт 443

Пользователям также может потребоваться доступ до более специализированных сервисов разработческой инфраструктуры:

Описание | Источник | Приёмник
:--- | :--- | :---
Distbuild (`ya make --dist`) | Группа пользователей, хост или сетевой макрос | `_DISTBUILDNETS_` порты `50000-50020` <br/> `distbuild.yandex-team.ru` порт `443` 
Selenium | Группа пользователей, хост или сетевой макрос | `sg.http.yandex.net` порт `4444`
Arc (работа с шифрованными файлами) | Группа пользователей, хост или сетевой макрос | `_ARC_PROD_NETS_` порт `5629`
SVN | Группа пользователей, хост или сетевой макрос | `arcadia.yandex.ru` порт `22`

## Доступы для сервисов

Использование разработческой инфраструктуры возможно в рамках межсервисного взаимодействия:

Описание | Источник | Приёмник
:--- | :--- | :---
Arc VCS (монтирование рабочей копии или bare-репозиторий) | Хост или сетевой макрос | `arc-vcs.yandex-team.ru` порты `443, 5624` <br/> `pulld.arc-vcs.yandex-team.ru` порт `7059` <br/> Также нужен доступ до Sandbox API (см. ниже)
Arc API | Хост или сетевой макрос | `api.arc-vcs.yandex-team.ru` порт `6734`
Arcanum API | Хост или сетевой макрос | `arcanum.yandex.net` порт `443`
SVN | Хост или сетевой макрос | `arcadia.yandex.ru` порт `22`
SVN (read-only) | Хост или сетевой макрос | `arcadia-ro.yandex.ru` порт `22`
Sandbox API | Хост или сетевой макрос | `sandbox.yandex-team.ru` порт `443`
Доступ от агентов Sandbox | `_CMSEARCHNETS_` | Хост или сетевой макрос
Selenium API | Хост или сетевой макрос | `sg.http.yandex.net` порт `4444`
Доступ от браузеров Selenium | `_SELENIUMGRIDNETS_` | Хост или сетевой макрос

## Доступы из тасков с `network:full` во внешнюю сеть
Источник: `_DISTBUILDNETS_`
