# Разметка репозитория лицензиями

Каждая библиотека в директории contrib/ должна быть размечена лицензиями. Каждая лицензия должна иметь свой собственный уникальный идентификатор. Где возможно в качестве идентификатора используется [spdx id](https://spdx.org/licenses/), где нет - придумываем свой. Идентификаторы лицензий прописываются в макрос [LICENSE](https://docs.yandex-team.ru/ya-make/manual/common/macros#license) в ya.make файлах. Коммит контрибов без указания LICENSE запрещен. Все идентфикаторы, указанные в макросе, должны быть заранее "известны" (сохранены в конфигурации) системы сборки ya make.

## Тексты лицензий
Тексты лицензий выписываются в отдельный файл. Он, в свою очередь, записывается в макрос LICENSE_TEXTS.

Для с/c++ контрибов (contrib/libs/):

Если конкретная `LIBRARY` (например запчасть контриба, как-то dll-враппер) не содержит лицензионной информации - она должна быть явно размечена макросом `WITHOUT_LICENSE_TEXTS`. Наличие `LICENSE_TEXTS` либо `WITHOUT_LICENSE_TEXTS` в `contrib/libs` контролируется системой сборки ya make.

## Теги лицензий
Все описанные в системе сборки ya make лицензии имеют теги - базовый огрубленный набор свойств. На текущий момент это:

* `FORBIDDEN` - запрещенные. Контрибы, имеющие лиценизии с таким тегом должны быть в какой-то перспективе удалены из Аркадии. Например, `AGPL-3.0-only`.
* `NDA` - проприетарные лицензии.
* `REQUIRE_DISCLOSURE` - требуется раскрытие исходного кода. Например, `GPL-3.0-only`.
* `PERMISSIVE` - не накладывающие серьезных ограничений (могут требовать, например копирование текста лицензий в credits пользовательского артефакта). Например, `BSD-3-Clause` или `MIT`.
* `REQUIRE_CITATION` - требует явным образом прописывать библиотеку в список используемых приложением (Third-Party libraries).
* `SERVICE` - служебные лицензии, не накладывающие никаких ограничений. Отличаются от `PERMISSIVE` отсутствием копирайтов (так как написаны нами).
* `UNATTRIBUTED` - псевдотег, означающий что лицензия находится в процессе оценки (не размечена тегами). Технически к ней применяются правила FORBIDDEN за минусом требования удаления.

Каждый тег дополнительно может делится на _STATIC и _DYNAMIC (например NDA_STATIC или REQUIRE_DISCLOSURE_DYNAMIC). Это означает что тег применяется только при определенном типе линковки (статическом или динамическом). Java-контрибы мы всегда считаем линкуемыми динамически. Одна лицензия может иметь несколько тегов.

Система сборки позволяет описать лицензионные требования для своего модуля в разрезе тегов (лицензии всех моих контрибов обалдают/ни одна не обладет/комбинации этих условий). Проверку лицензионных требований осуществляет система сборки. Для этого можно использовать макрос [RESTRICT_LICENSES](https://docs.yandex-team.ru/ya-make/manual/common/macros#restrict_licenses).

## Добавление нового тега/изменение распределения лицензий по тегам
Добавление нового тега является трудоемким процессом, так как потенциально требует переоценки всех известных лицензий на предмет их соответствия этому тегу. Поэтому эта процедура делается только для критически важных свойств.
За данный процесс отвечает ArcadiaWG с привлечением юристов по мере необходимости. Если ошибку в текущем распределении нашел пользователь - он должен написать на рассылку [ArcadiaWG](https://ml.yandex-team.ru/lists/arcadia-wg/) где описать что он считает неправильным. Определение полезности предлагаемых изменений и работы по переоценке - ответственность ArcadiaWG. Консультироваться с юристами следует через тикеты в очереди [LEGAL](https://st.yandex-team.ru/createTicket?queue=LEGAL)

Процесс добавления тега/изменения распределения выглядит следующим образом:
1. Ответственный (ArcadiaWG/юрист) создает тикет в очередь [DTCC](https://st.yandex-team.ru/dtcc) в котором указано название тега, его описание (для документации) и список идентификаторов которые нужно в него поместить/переместить.
2. devtools@ добавляют поддержку тега в систему сборки
3. devtools@ прописывают новое распределение по тегам
4. Если новое распределение вызывает ошибки в пользовательских проверках (RESTRICT_LICENSES) - создаются подтикеты на овнеров соответсвующих проктов
    * тикеты имеют критичный приоритет и дедлайн
    * если дедлайн превышен - devtools могут руками прописать исключение в пользовательскую проверку/временно ее отключить и вкоммитить (со ссылкой на тикет).

Процесс может быть итеративным - в рамках одного тикета можно отсылать несколько изменений распределения.

## Credits
Система сборки позволяет генерировать файлы CREDITS. В них будут автоматически записываться тексты/ссылки/копирайты - т.е. любая лицензионная информация обо всех контрибных зависимостях пользовательского модуля. Credits, генерируемый системой сборки, представляет собой конкатенацию всех LICENSE_TEXTS зависимостей модуля.

Для получения CREDITS для любого финального (PROGRAM, DLL, ...) модуля в рамках системы сборки реализован флаг:

   ya make --with-credits

## Добавление новой лицензии
При обнаружении новой (неописанной в системе сборки ya make) лицензии пользователем (в процессе завоза/обновления контриба) следует:
1. Написать на рассылку [ArcadiaWG](https://ml.yandex-team.ru/lists/arcadia-wg/). В письме следует указать:
    * Идентификатор лицензии (где возможно - spdx id). Можно воспользоваться [ya tool license_analyzer](https://docs.yandex-team.ru/devtools/rules/contrib/licenses#ya-tool-license-analyzer).
    * Текст лицензии (можно ссылкой на файл/кусок файла в оригинальном внешнем репозитории)
    * (где это возможно)Референсный(каноничный) текст лицензии (на странице проекта/на сайте [spdx.org](https://spdx.org/licenses/)) - нужно для проверки того, что текст в файле соответствует заявленному идентификатору.
2. Руководствуясь описанием тегов из документации и текстом лицензии ArcadiaWG может:
    * Выбрать подходящие теги призвать в тикет devtools@ ("Разметьте {идентификтор} тегами {теги})
    * Понять что случай не простой и призвать юридический отдел (очередь [LEGAL](https://st.yandex-team.ru/createTicket?queue=LEGAL)) - тогда категоризация ложится на них. Параллельно призываются devtools@ для того, чтобы временно разметить лицензию как UNCATEGORIZED (чтобы не блочить процесс покладки/обновления контриба)
3. devtools@ проставляют идентификатору указанные теги

## Автоматика devtools
Для полуавтоматического поиска лицензий/заполнения макросов ya.make разарботана утилита [ya tool license_analyzer](https://docs.yandex-team.ru/devtools/rules/contrib/licenses#ya-tool-license-analyzer). Обязательность его использования, а также обязательность заполнения LICENSE_TEXTS для контрибов регулируется языковыми комитетами.

## Как придумать идентификатор лицензии
Тулиг devtools@ для завоза контрибов уже умеет проставлять лицензии. Если вы столкнулись с необходимостью положить что-то в обход автоматики и при этом не понимаете, какой идентификатор следует назначить лицензии (например он не указан на странице проекта в оириганльном репозитории) - можете воспользоваться ya tool license_analyzer (хэндлеры [scan](https://docs.yandex-team.ru/devtools/rules/contrib/licenses#scan) и [scan_single_file](https://docs.yandex-team.ru/devtools/rules/contrib/licenses#scan_single_file))

