# Достижимость проектов 

**Важно**: Автосборка собирает только те проекты, которые достижимы из корня аркадии.

## Достижимость
Проект **не считается** достижимым по `RECURSE`, если на него стоит только `DEPENDS` в тестах.

Рассмотрим на примере, как работает автосборка:  
Открываем [arcadia/autocheck/ya.make](https://a.yandex-team.ru/arc/trunk/arcadia/autocheck/ya.make), находим макрос `RECURSE`.  
Все что перечислено в этом макросе участвует в автосборке.  
Переходим в каждую из этих директорий и находим макросы `RECURSE/RECURSE_ROOT_RELATIVE/RECURSE_FOR_TESTS/PEERDIR`.

Например, переходим в [arcadia/util/ya.make](https://a.yandex-team.ru/arc/trunk/arcadia/util/ya.make).  
Все директории, указанные в макросах `RECURSE/RECURSE_ROOT_RELATIVE/RECURSE_FOR_TESTS/PEERDIR` участвуют в автосборке.  
Переходим в каждую из этих директорий и находим макросы `RECURSE/RECURSE_ROOT_RELATIVE/RECURSE_FOR_TESTS/PEERDIR`.
и т.д.

Грубо говоря, проект `arcadia/path/to/my/project` достижим, если существует хотя бы один путь по макросам `RECURSE/RECURSE_ROOT_RELATIVE/RECURSE_FOR_TESTS/PEERDIR`
из `arcadia/autocheck/ya.make` до `arcadia/path/to/my/project/ya.make`

### Более формально
Система сборки, будучи запущенной из корня аркадии, строит транзитивное замыкание по `RECURSE` (а также `RECURSE_ROOT_RELATIVE` и `RECURSE_FOR_TESTS`, далее - `RECURSE*`) - это основные цели.  
Далее для всех основных целей строится транзитивное замыкание по `PEERDIR`-ам – это и есть множество проектов достижимых автосборкой.  

Hint: Если в проект `some/path` не является основной целью, то по `RECURSE*`-ам система сборка не пойдет.  

## Мне пришло письмо, о том, что мой проект не подключен к автосборке. что я должен сделать? {#letter}
Если проект лежит в корне Аркадии — добавить его в [соответствующие платформы в автосборке](https://a.yandex-team.ru/arc/trunk/arcadia/autocheck/ya.make).
Если проект находится не в корне, нужно проследить цепочку зависимостей от [autocheck/ya.make](https://a.yandex-team.ru/arc/trunk/arcadia/autocheck/ya.make) до вашего проекта. Можно это сделать последовательно раскручивая зависимости.
- Запустить команду `ya project create recurse --with-update` в директории, где есть неподключенные проекты.
- Подключаем ваш ya.make через `PEERDIR` или `RECURSE*` в нужное место. `RECURSE*` обычно будет на уровень выше, `PEERDIR` — по месту использования.  
- Проверяем, что `ya.make` в котором есть зависимость на ваш проект, уже подключен. Для этого идём по цепочке зависимостей назад (ищем зависимость на текущий `ya.make`) и проверяем:
  - Если зависимость по `PEERDIR` — следующая может быть `RECURSE*`, или `PEERDIR`
  - Если зависимость по  `RECURSE*` — следующие должны быть только по `RECURSE*`
- В конце концов мы должны прийти в [autocheck/ya.make](https://a.yandex-team.ru/arc/trunk/arcadia/autocheck/ya.make)

## Почему проект должен быть достижим? {#why}
Если ваш код полноценно не интегрирован в автосборку, то вы не можете быть уверены, что ваш код не будет сломан очередным коммитом или при обновлении средств сборки и тестирования (компиляторы, фреймворки и т.д.)  
Подключённые проекты живут по общим правилам и позволяют вам и вашим коллегам легко:
* понять статус проекта - состояние сборки, под какие платформы он собирается. Что позволяет ответить на вопрос, можно ли использовать его прямо сейчас.
* оценить полноту покрытия тестами проекта.
* ориентироваться в проекте - он будет проиндексирован и в Аркануме будут доступны переходы к объявлениям переменных/методов/классов, что повышает его читаемость и упрощает восприятие.

Тесты могут быть отключены для ряда платформ и отключены пользователем, что приведёт к тому что цели указанные в `DEPENDS` перестанут собираться. Поэтому все проекты должны быть достижимы именно по `RECURSE*`, а не по `DEPENDS`

## Как перед коммитом проверить, что после внесенных изменений проект подключен к автосборке? {#how}

Для нового проекта на плашке прекоммитной проверки (PR) должен появиться бейджик added. Под ним должны найтись все добавленные сборки и тесты. Удаленные из автосборки сущности появляются в бейджике deleted.

Проверить достижимость существующего проекта можно в интерфейсе [тестов CI](https://ci.yandex-team.ru/tests), вписав путь проекта в поле Source path.

## Дополнительные сведения
[Исходный код](https://a.yandex-team.ru/arc/trunk/arcadia/devtools/unitybot/unreachability/unreachability.py)  
[Пост в этушке](https://clubs.at.yandex-team.ru/arcadia/6134)
[Старая страница на Wiki](https://wiki.yandex-team.ru/development/poisk/arcadia/ymake/manual/cmakelistsreachability/)
