# Изменение истории

Пока ваши изменения еще не влиты в единый репозиторий, вы можете свободно изменять историю коммитов в локальных и удаленных ветках.

## Изменить сообщение последнего коммита

```bash
$ arc commit --amend -m 'New commit message'
```

## Отменить действие `arc add`

Физически никакие файлы не удаляются. Файлы, добавление которых мы отменили, не попадут в коммит.

```bash
$ arc reset code.cpp project/myfile2.txt
```

## Удалить коммиты из истории, но сохранить изменения

Если вам нужно удалить сами коммиты из истории (`arc log`), но не потерять изменения, внесенные в этих коммитах.

```bash
$ arc reset --soft HEAD~1 # Откатить последний коммит
$ arc reset --soft a8fdc205a9f19cc1c7507a60c4f01b13d11d7fd0 # Удалить историю после указанного коммита
```

После выполнения одной из указанных команд вывод `arc status` будет содержать все изменения, которые были в удаленных коммитах.

## Удалить коммиты вместе с изменениями

{% note alert %}

С помощью этой команды легко потерять результаты своей работы, которые еще не были влиты в единый репозиторий.

{% endnote %}


Если требуется удалить коммиты из истории и изменения, которые в них содержались:

```bash
$ arc reset --hard HEAD~1 # Удалить последний коммит
$ arc reset --hard a8fdc205a9f19cc1c7507a60c4f01b13d11d7fd0 # Удалить всю историю и изменения после указанного коммита
```

## Интерактивное изменение истории

Arc позволяет произвольным образом менять порядок коммитов, переименовывать, объединять и удалять коммиты:

1. Запустите процедуру изменения истории:
    ```bash
    $ arc rebase -i HEAD~5 # Отредактировать последние 5 коммитов
    $ arc rebase -i a8fdc205a9f19cc1c7507a60c4f01b13d11d7fd0 # Отредактировать все, что между указанным коммитом и HEAD
    ```

2. После выполнения одной из указанных команд будет открыт текстовый редактор со списком коммитов по одному в каждой строчке. Для каждого из коммитов в начале строчки указано действие:

    * `pick` — использовать коммит
    * `reword` — изменить описание коммита
    * `edit` — остановиться на данном коммите для редактирования
    * `squash` — объединить коммит с предыдущим, описание коммита будет добавлено к описанию предыдущего
    * `fixup` — объединить коммит с предыдущим, описание коммита будет выброшено
    * `drop` — не использовать коммит (то же самое, что удалить строчку)

3. Внесите изменения в список коммитов, исправив действие на требуемое. Например, если хотите удалить коммит - напишите вместо `pick` слово `drop` или удалите строчку из списка. Если хотите поменять описание коммита - напишите `reword` и так далее.

4. Сохраните и закройте редактор. Arc применит внесенные изменения к истории.

## Перезаписать историю на сервере

{% note alert %}

С помощью этой команды легко потерять любые коммиты в удаленных ветках (в том числе и коммиты ваших коллег), которые еще не были добавлены в единый репозиторий.

{% endnote %}


```bash
$ arc push -f
```
