# Основные команды

{% note info %}

В данном руководстве приведены основные сценарии использования системы контроля версий. Более подробное описание Arc как инструмента и сервиса доступно в [сервисной документации](https://docs.yandex-team.ru/arc). Полная справка по командам клиента `arc` доступна в [справочном разделе](https://docs.yandex-team.ru/arc/ref/commands).

{% endnote %}

## Arc vs Git { #diff }

Arc довольно сильно похож на Git. Синтаксис большинства команд везде, где возможно, повторяет аналогичные команды Git. Тем не менее есть набор важных отличий:

1. Основная ветка в репозитории называется `trunk`, а не `master`. Все принятые изменения других разработчиков всегда хранятся в этой ветке.
2. Поскольку репозиторий единый, то команды работы с удаленным репозиторием не имеют понятия `remote` (не нужно писать `origin`):
    ```bash
    $ git push origin master # Git
    $ arc push -u users/username/my-feature # Arc
    ```
3. Есть встроенная команда создания пулл-реквестов `arc pr`.
4. Отсутствует команда `merge` и рекомендуется пользоваться командой `rebase`.

## Как работать с кодом { #workflow }

В разделе [Быстрый старт](../../intro/quick-start-guide.md) мы уже загрузили исходные коды. Все дальнейшие команды выполняются из каталога с исходными кодами.

1. Перед внесением любых изменений в код, необходимо отвести новую ветку:
    ```bash
    (trunk) $ arc checkout -b my-feature
    ```

2. Внести изменения в код.
3. Посмотреть список файлов, которые были модифицированы:
    ```bash
    (my-feature) $ arc status
    ```
    Посмотреть изменения в этих файлах:
    ```bash
    (my-feature) $ arc diff
    ```
    
    {% note tip %}
    
    Если вы забыли создать ветку, то на этом шаге можно сделать ее с помощью команды:
    ```bash
    (trunk) $ arc checkout -b my-feature
    ```
    
    {% endnote %}
    
    
4. Добавить файлы, изменения которых нужно добавить в коммит:
    ```bash
    (my-feature) $ arc add code.cpp project/myfile2.txt
    ```

5. Просмотреть изменения в добавленных файлах:
    ```bash
    (my-feature) $ arc diff --cached
    ```

6. Создать коммит:
    ```bash
    (my-feature) $ arc status
    (my-feature) $ arc commit -m "my commit message"
    ```

7. Загрузить свежие изменения из единого репозитория и добавить их в ветку:
    ```bash
    (my-feature) $ arc pull trunk
    (my-feature) $ arc rebase trunk
    ```

8. Создать пулл-реквест:
    ```bash
    (my-feature) $ arc pr create --push -m "my first pull request"
    ```

    {% note info %}
    
    Можно отдельно загрузить изменения в ветку в едином репозитории и сделать пулл-реквест:
    ```bash
    (my-feature) $ arc push -u users/username/my-feature # Теперь ветка my-feature смотрит на удаленную ветку users/username/my-feature
    (my-feature) $ arc pr create -m "my first pull request" # Автоматически определяет имя удаленной ветки, привязянной к локальной
    ```
    
    {% endnote %}

9. Если по какой-то причине требуется добавить новые изменения в пулл-реквест, просто создайте еще один коммит в ту же ветку и выполните `arc push`. Каждое выполнение `arc push` приводит к появлению новой версии в пулл-реквесте. 

10. После прохождения тестов и code review изменения из ветки будут автоматически добавлены в единый репозиторий.
