# Веб-интерфейс Arcanum

Для работы с исходными кодами единого репозитория из браузера создан веб-интерфейс [Arcanum](https://a.yandex-team.ru), который многими возможностями напоминает [Github](https://github.com/). На этой странице собраны все основные возможности сервиса.

## Просмотр и редактирование исходных кодов { #navigation }

Arcanum позволяет легко просматривать содержимое единого репозитория:

![Arcanum Navigation](img/arcanum-navigation.png "Просмотр содержимого единого репозитория")

Для быстрого поиска интересующего вас раздела предусмотрена фильтрация:

![Arcanum Filter](img/arcanum-filter.png "Фильтрация содержимого единого репозитория")

При нажатии на коммит в столбце **Revision**, можно просмотреть список измененных файлов и сами изменения в каждом из них:

![Arcanum Commit](img/arcanum-commit.png "Просмотр коммита")

Можно просматривать содержимое любых файлов:

![Arcanum View File](img/arcanum-view-file.png "Просмотр содержимого файла")

При просмотре файлов доступно отображение авторов изменений в каждой строчке (т.н. **blame** от англ. blame - винить):

![Arcanum Blame](img/arcanum-blame.png "Отображение авторов изменений файла")

Можно редактировать файлы и отправлять изменения в виде пулл-реквеста :

![Arcanum Edit File](img/arcanum-edit-file.png "Редактирование содержимого файла")

На вкладке **History** можно увидеть список всех изменений в выбранном разделе единого репозитория:

![Arcanum History](img/arcanum-history.png "Просмотр истории коммитов")

На вкладке **Branches** отображается список всех веток на сервере, относящихся к выбранному разделу единого репозитория.

![Arcanum Branches](img/arcanum-branches.png "Просмотр списка веток")

На вкладке **Review requests** находится список активных пулл-реквестов:

![Arcanum Pull Requests](img/arcanum-pull-requests.png "Просмотр списка пулл-реквестов")

## Пулл-реквесты { #pull-requests }

Каждый созданный пулл-реквест отображается в виде отдельной страницы:

![Arcanum PR Page](img/arcanum-pr-page.png "Страница пулл-реквеста")

Страница содержит:

1. Различную мета-информацию о пулл-реквесте:
    * Уникальный номер пулл-реквеста, его описание, время создания и последнего обновления;
    * Информацию о создателе и ветке, из которой он был создан;
    * Связанные тикеты в трекере [Startrek](https://st.yandex-team.ru/);
    * Наблюдатели и владельцы кода, в который внесены изменения.

2. Кнопки **Ship**, **Merge** и **More**, позволяющие управлять состоянием пулл-реквеста:

    ![Arcanum PR Merge](img/arcanum-pr-merge.png "Управление состояние пулл-реквеста")

    Кнопка **Merge** позволяет задать условия, при которых пулл-реквест будет влит в единый репозиторий. По-умолчанию все пулл-реквесты вливаются автоматически (**automatic merging**) после успешного прохождения тестов. Можно отключить автоматическое вливание изменений и потребовать ручного одобрения изменений от одного или нескольких разработчиков. Одобрение пулл-реквеста делается нажатием кнопки **Ship** (то же самое, что **Approve**). После того как все условия выполнены, нужно включить флажок **Enable automatic merging** обратно и пулл-реквест будет влит.
    
    Кнопка **More** содержит более редко используемые возможности, например, позволяя закрыть пулл-реквест без добавления в единый репозиторий.

3. Информацию о прохождении тестов на вкладке **Details**:

    ![Arcanum PR Checks](img/arcanum-pr-checks.png "Информация о прохождении тестов")

4. Список измененных файлов на вкладке **Files**:

    ![Arcanum PR Files](img/arcanum-pr-files.png "Список измененных файлов")
    
5. Список коммитов на вкладке **Commits**:

    ![Arcanum PR Commits](img/arcanum-pr-commits.png "Список коммитов")
    
6. Список итераций (на каждый `arc push -f` в ветку создается новая итерация):

    ![Arcanum PR Iterations](img/arcanum-pr-iterations.png "Список итераций")
    
## Поиск по репозиторию { #code-search }

Arcanum предоставляет возможность искать исходный код по произвольному запросу. Для того, чтобы начать поиск - введите запрос в поле **Find code...**:

![Arcanum Code Search](img/arcanum-code-search.png "Поиск по коду")

Будет показана страница с результатам поиска:

![Arcanum Search Results](img/arcanum-search-results.png "Результаты поиска")

## Кабинет разработчика { #developer-page }

В Arcanum реализована личная страница (кабинет) разработчика, по-умолчанию доступная при **нажатии на вашу аватарку > My dashboard**.

![Arcanum Developer Page](img/arcanum-developer-page.png "Кабинет разработчика")

На данной странице отображается информация о коммитах по дням, списки пулл-реквестов и тестов, связанных с данным разработчиком.

## Настройки { #settings }

При **нажатии на аватарку > Settings** вы увидите экран настроек пользователя:

![Arcanum Settings](img/arcanum-settings.png "Экран настроек")

## Клавиатурные сокращения { #shortcuts }

Arcanum поддерживает клавиатурные сокращения для более быстрой навигации по коду и работы с пулл-реквестами. Полный список поддерживаемых сокращений отображается при **нажатии на аватарку > Shortcuts**: 

![Arcanum Shortcuts](img/arcanum-shortcuts.png "Клавиатурные сокращения")
