# Внешние сотрудники

Иногда команды в Яндексе решают привлечь для выполнения той или иной работы [внешних сотрудников](https://wiki.yandex-team.ru/security/ext). Технически такие сотрудники отличаются от штатных работников в первую очередь тем, что у них сильно ограничены доступы до различных внутренних сервисов, и сервисы для разработки – не исключение. По умолчанию доступа к разработческой инфраструктуре у внешнего сотрудника нет совсем, но привлекающая такого сотрудника команда имеет возможность согласовать для него ограниченный доступ к сервисам, перечисленным ниже.

## Репозиторий Аркадии {#repo}

Внешние сотрудники могут получить частичный доступ к репозиторию Аркадии:
- Работа с репозиторием может вестись как локально с использованием системы контроля версий [Arc](arc/workflow.md), так и через веб-интерфейс [Arcanum](arcanum.md)
- Предоставляется возможность работать (просматривать и вносить правки) только с файлами, входящими в заранее определенный набор путей
- Сотрудник может создавать пулл-реквесты, а также просматривать чужие пулл-реквесты, если они затрагивают только доступные ему пути
- Сотрудник не может одобрить вливание пулл-реквеста или изменить требования его вливания в сторону ослабления
- Для вливания пулл-реквеста внешнего сотрудника потребуется одобрение штатного сотрудника Яндекса
- Использовать можно только Arc, доступ к SVN не выдается

Файлы за пределами согласованных путей внешний сотрудник просмотреть не сможет, хотя и сможет увидеть мета-данные коммитов (описания, даты и т.д.). Также важно понимать, что доступ к путям будет выдан без привязки к графу коммитов – при желании сотрудник сможет просматраивать соответствующие директории в любых коммитах и ветках.

В целях безопасности, запуск тестов и CI в пулл-реквестах выполняется только после прохождения код ревью.
Кроме этого доступ к артефактам запуска тестов (бинари, данные, полный лог выполнения теста), так же невозможен — старайтесь писать тесты таким образом, чтобы всю необходимую информацию о результатах его выполнения можно было бы получить из его сниппета
(в целом эта рекомендация относится к любым тестам, а не только к тем, которые запускаются в рамках проектов, к которым есть доступ для внештатных сотрудников).
В случае, когда для диагностики все-таки необходим полный лог теста, внештатный сотрудник может запросить его у того разработчика, который выполняет код ревью соответствующего пулл-реквеста.

{% note info "Только Arc" %}

Доступ к SVN не предоставляется, в том числе и через Arcanum: для просмотра исходников в веб-интерфейсе внешним сорудникам необходимо использовать ссылки, начинающиеся на [https://a.yandex-team.ru/arc_vcs](https://a.yandex-team.ru/arc_vcs) вместо ссылок, которые начинаются на [https://a.yandex-team.ru/arc/trunk/arcadia](https://a.yandex-team.ru/arc/trunk/arcadia).

{% endnote %}

### Как начать? {#repo-howto}

1. Определитесь с тем, к каким путям в Аркадии понадобится доступ внешним сотрудникам
2. Заполните [заявку](https://forms.yandex-team.ru/surveys/arcadia-outstaff) на создание outstaff-проекта
3. После обработки заявки закажите нужные доступы через IDM (`Arc → Arcadia → Partial access → Outstaff-проект → User`) и подождите их согласования

При обработке заявки мы создаем специальную сущность – outstaff-проект. Проект привязывается к указанному в заявке ABC-сервису и определяет набор путей в Аркадии, роль в котором затем можно заказать – как на отдельного внешнего сотрудника, так и на группу.

Для выдачи роли в проекте потребуется подтверждение руководителя ABC-сервиса и [службы информационной безопасности](https://wiki.yandex-team.ru/security). Чтобы вместо руководителя сервиса призывался для подтверждения кто-либо еще – можно выдать в ABC-сервисе специальную роль "Управляющий внешними сотрудниками".

После выдачи ролей прорастут также сетевые доступы, что позволит сотруднику перейти к работе с веб-интерфейсом или же к установке `arc`.

{% note tip "Инструкции для внешних сотрудников" %}

Данный кластер документации для внешних не доступен, поэтому мы создали специальную, входящую в каждый outstaff-проект, директорию в Аркадии, куда выложили специально написанные инструкции:

[https://a.yandex-team.ru/arc_vcs/outstaff](https://a.yandex-team.ru/arc_vcs/outstaff)

{% endnote %}
