# Зависимости

В едином репозитории поддерживается **герметичность**. Это значит, что процесс сборки и тестирования должен быть зависимым только от тех входных данных, которые были явно перечислены в файлах **ya.make**. Каждый запуск тестов проходит в чистом окружении, в которое автоматически добавляются **зависимости** из **ya.make**:

```yamake
OWNER(g:my-group)

PY2TEST()

TEST_SRCS(
    test.py
)

DEPENDS( # Зависимость от других проектов
    my-project/test-tools/log_parser
)

DATA( # Тестовые данные
    arcadia/my-project/some-file.log # Файл из репозитория
    sbr://1931234567=db # Sandbox ресурс
)

SIZE(MEDIUM)

END()
```

Зависимости бывают двух видов:

1. **Другие проекты из единого репозитория**. Например, вам может потребоваться исполняемый файл, исходные коды которого лежат где-то в другом проекте. Такие зависимости описываются при помощи макроса `DEPENDS`, содержащего список путей относительно корня единого репозитория, которые надо собрать перед запуском тестов.

2. **Тестовые данные**. Например, сюда относятся различные эталонные файлы: логи, списки слов, тестовые дампы баз данных и так далее. Такие данные могут храниться как в едином репозитории, так и в виде [ресурса Sandbox](https://docs.yandex-team.ru/sandbox/resources). Подробности обо всех способах, которыми можно добавлять тестовые данные, можно прочесть в [документации по системе сборки](https://docs.yandex-team.ru/ya-make/manual/common/data).
