# Ручной запуск тестов

Для того, чтобы вручную запускать тесты в процессе разработки, используется утилита **ya**. Команду **ya** мы установили в разделе [Быстрый старт](../intro/quick-start-guide.md). Выполнение тестов считается частью процесса сборки исходных кодов, поэтому для того, чтобы выполнить тесты в процессе сборки нужно добавить флаг `-t`. По-умолчанию при указании флага `-t` запускаются только **SMALL** тесты. Например:

```bash
$ ya make -t ~/arcadia/my-project/my-app # Запускает SMALL тесты из указанного каталога и вложенных в него
$ ya make -t # Запускает SMALL тесты из текущего каталога
```

Если требуется запустить тесты другого размера:

```bash
$ ya make -t # Только SMALL тесты
$ ya make -tt # SMALL + MEDIUM тесты
$ ya make -ttt # Все тесты
$ ya make -A # Синоним для запуска всех тестов
```

## Получение списка тестов { #list }

Для получения списка тестов используется флаг `-L` (`--list-tests`):

```bash
$ ya make -tL # Список SMALL тестов
$ ya make -ttL # Список SMALL и MEDIUM тестов
$ ya make -tttL # Список всех тестов
$ ya make -tAL # Список всех тестов
```

## Выбор запускаемых тестов { #choose }

Для запуска тестов по имени используется флаг `-F`. Список имён выводится при получении списка тестов:

```bash
$ ya make -t -F <test-name-1> -F <test-name-2>
```

При указании флага `-F` можно использовать [специальные символы](https://docs.python.org/3/library/fnmatch.html):

```bash
$ ya make -t -F <file>.py::<ClassName>::*
```

Можно запускать тесты только конкретного [типа](intro.md#type):

```bash
$ ya make -A --test-type unittest --test-type pytest
```

Для запуска только обычных тестов можно использование сокращение:

```bash
$ ya make -A --regular-tests
```

Для запуска только проверок стиля и форматирования кода:

```bash
$ ya make -A --style
```

Если запуск suite разбит на несколько chunk с помощью макросов `FORK_TEST()`/`FORK_SUBTESTS()`/`FORK_TEST_FILES()`, то вы можете запустить конкретный chunk:

```bash
$ ya make -A -F '[3/10] chunk'
$ ya make -A -F '[test_name1.py 3/10] chunk'
```

Внутри `[]` можно использовать `*`. Для того, чтобы `ya make` могл отличить фильтр по chunk от фильтра по имени теста, используется regex `^\[.*?] chunk$`, т.е. фильтр без `[]` или без `chunk` будет воспринят системой как фильтр для имени тестов.
Фильтрация по chunk удаляет из графа chunk, которые не подошли под фильтр, - они не будут запускаться совсем.

```bash
$ ya make -A -F '[3*] chunk'
$ ya make -A -F '[test_name1.py*] chunk'
```

## Теги { #tags }

Пользователь может размечать каталоги с тестами произвольными тегами при помощи макроса `TAG`:

```yamake
OWNER(g:my-group)

JUNIT5()

SIZE(MEDIUM) # Размер тестов

JAVA_SRCS(SRCDIR java **/*)
JAVA_SRCS(SRCDIR resources **/*)

TAG(my-tag-1 my-tag-2)

END()

```

После этого можно фильтровать тесты по указанным тегам:

```bash
$ ya make -tt --test-tag my-tag-1
```

## Параметры { #parameters }

Коду тестов можно передавать произвольные параметры:

```bash
$ ya make --t --test-param key1=value1 --test-param key2=value2
```

## Разные полезные флаги { #misc }

Если требуется, чтобы тестирование завершалось при падении хотя бы одного теста:

```bash
$ ya make -t --fail-fast
```

По-умолчанию показываются только упавшие тесты. Для отображения прошедших и пропущенных тестов:

```bash
$ ya make -t --show-passed-tests --show-skipped-tests
```
