# Запуск тестов в YT
Тестирующая система в `ya make` умеет переносить запуск тестов в `YT`. Это может быть полезно для тех, кто хочет запускать свои тесты в `GPU`-окружении и для тех, кто хочет запускать тесты в `porto` слоях

## Как в автосборке запускать тесты в YT? { #autocheck }
1) Вам нужна своя квота в `YT`. Если у вас ее нет, ее можно получить. Подробнее в [Документации YT](https://yt.yandex-team.ru/docs/gettingstarted#quotas)

2) Дайте роботу `arcadia-devtools` доступ в свой пул. О выдаче доступов к пулам можно почитать [здесь](https://yt.yandex-team.ru/docs/description/common/acl_manage#vydacha-roli-use-na-akkaunt)
3) Cоздайте путь в кипарисе, в котором будут храниться данные от запусков тестов в YT.
Создать путь в кипарисе можно с помощью веб-интерфейса, нажав кнопку Create object:
![create_object_button](https://wiki.yandex-team.ru/users/iaz1607/yt-pools/.files/createobjectbutton.jpg)

4) Дайте доступы `read`, `write`, `remove`, `mount` до этого пути аккаунту `arcadia-devtools`. О выдаче доступов к директориям можно почитать [здесь](https://yt.yandex-team.ru/docs/description/common/acl_manage#home_dir)

5) Создайте ``yson`` конфиг в аркадии и заполните поля `cypress_root`, `cluster` и `pool` в этом конфиге. `pool` - название вашего пула. `cypress_root` - путь, созданный в п.3. `cluster` - кластер, в котором живет ваш пул.
шаблон зполненного конфига:
    ```
    {
        cluster=hahn;
        pool=<your-pool-name>;
        cypress_root=<your-cypress-root>;
    }
    ```
6) Укажите в `ya.make` вашего теста путь до созданной в п.5 спеке с помощью макроса `YT_SPEC`:

    `YT_SPEC(devtools/dummy_arcadia/test/yt_test/large/yt_spec.yson)`

7) Укажите в `ya.make` вашего теста тег `ya:yt`.

## Запуск тестов в YT без собственного пула { #no-pool }
* Если явно не прописать пул в `YT_SPEC`, то локально ваш тест будет запускаться в `research` пуле, а в качестве `cypress_root` будет использован `//tmp`.
* Без указания пула, в автосборке ваши тесты будут запускаться в пуле и кипариссе, принадлежащим devtools. В этом случае, на запуск тестов  нет никаких вычислительных гарантий, а время жизни данных таких тестов в YT составляет 2 часа.
* Так как тесты без явного указания пулов не имеют гарантий на ресурсы и могут мигать, таким тестам всегда автоматически добавляется тег `ya:external` и их поломки видны только владельцам теста.

## Запуск тестов с GPU { #gpu }
Пример спеки, в виде yson файла, путь до которого нужно указать в ya.make макросе `YT_SPEC`, чтобы получить GPU окружение:
```
   cluster = hahn;
   pool = "devtools";
   cypress_root = "//home/devtools/tmp/ytexec";
   operation_spec = {
        "pool_trees" = [
            "gpu_geforce_1080ti";
        ];
    };
    task_spec = {
        "gpu_limit" = 1;
        "layer_paths" = [
            "//porto_layers/delta/gpu/driver/418.67";
            "//porto_layers/ubuntu-xenial-base.tar.xz";
        ];
    };
```

## Запуск тестов в porto-слоях { #porto }
* Про использование porto слоев в `YT` можно почитать в [документации](https://yt.yandex-team.ru/docs/description/mr/porto/layer_paths)
* [Пример](https://a.yandex-team.ru/arc/trunk/arcadia/devtools/dummy_arcadia/test/yt_test/large/yt_spec.yson?rev=7989921&blame=true) заполненного `YT_SPEC`, использующего porto слои
## Локальный запуск тестов в YT { #local }
* Чтобы локальный запуск теста перенесся в `YT`, нужно к команде запуска тестов добавить `--run-tagged-tests-on-yt`
* Если у вас есть доступ до пула, указанного в конфиге, тест запустится в этом пуле, иначе, тест запустится в общем `research` пуле.

## Таймауты в тестах, запускающихся в YT { #timeouts }
**Локальные запуски и `LARGE` тесты**
* Запуску теста в `YT` будет выделен таймаут, соответствующий размеру теста.
* Время, потраченное на подготовку окружения в `YT`, никак не повлияет на время, выделенное для исполнения теста.

**`SMALL\MEDIUM` тесты в автосборке**
* При запуске тестов в автосборке, у каждого теста помимо таймаута теста, есть жесткий таймаут, в который должен уложиться тестовый узел, в рамках которого исполняется тест. Таймаут ноды равен `test_timeout + X`. На данный момент `X = 5 минут`.
* Это значит, что если подготовка окружения в `YT` заняла больше времени, чем `X`, то тесту будет выделено меньше времени, чем `test_timeout`.
## Окружение в `YT` тестах { #environ }
* При запуске тестов в `YT`, тест запускается в чистом окружении, так же, как при локальном запуске.
* Тесты используют `tmpfs` в качестве файловой системы.
* Если ваш тест должен писать что-то тяжелое, например логи, можно воспользоваться `HDD` дисками. Путь до `HDD` можно найти с помощью аркадийных библиотеных функций тестирования ([cpp], [python], [java], [go]). Данные, написанные на `HDD` диск можно будет скачать после завершения работы теста.

## Результаты тестирования { #results }
* Все логи тестов лежат там же, где они бы лежали, если бы тест запускался не в `YT`.
* Данные о запуске операции в `YT` можно найти в директории `yt_run_test`. Путь до этой директории будет указан вместе с другими логами теста в секции `operation_logs`
* Данные, записанные в `HDD_PATH` и `coredump`-файлы теста можно скачать, следуя шагам, описанным в `README.md` файле. Этот файл лежит в директории `yt_run_test`.

## Требования к вычислительным ресурсам {#requirements}
* Для тестов в `YT` можно указывать требования аналогично тому, как это делается в обычных тестах.
* Отличие состоит в том, что при запуске тестов в `YT` нет ограничений на кол-во запрашиваемых ресурсов(`RAM\CPU\RAM_DISK`).
* Т.к. тесты в `YT` запускаются в `tmpfs`, все данные тестов (DATA\бинари\ресурсы) тоже лежат в `tmpfs`. Наша тестирующая сисетма учитывает это и заказывает дополнительный `tmpfs` под данные тестов.
* Если ваши тесты заказывают большое кол-во ресурсов, у них может увеличиться время ожидания подходящего кластера в `YT`, что может привести к уменьшению времени, выделяемого тесту.

## Снижение потребления ресурсов в вашей квоте {#quota}
Каждый коммит задевающий ваши тесты, в доступных для автосборки конфигурациях, будет приводить к их запуску. Для снижения потребления ресурсов вы можете:
* посмотреть в CI под какие платформы запускается тест и оставить только основную. Этого можно добиться с помощью комбинации макросов `IF()` и `RECURSE_FOR_TESTS`, см. [пример для sanitizer](https://docs.yandex-team.ru/ya-make/manual/tests/sanitizer#disable)
* форсированно отключить перезапуск тестов в CI, в случае их падений, добавив в `ya.make` с тестом макрос `TAG(ya:noretries)`
* убрать лишние зависимости теста

[cpp]: https://a.yandex-team.ru/arc_vcs/library/cpp/testing/common/env.cpp?rev=d5e14ffcd8313aeb4e891908417328039cbb34fc#L66

[python]: https://a.yandex-team.ru/arc_vcs/library/python/testing/yatest_common/yatest/common/runtime.py?rev=d5e14ffcd8313aeb4e891908417328039cbb34fc#L234

[java]: https://a.yandex-team.ru/arc_vcs/devtools/jtest/src/main/java/ru/yandex/devtools/test/Paths.java?rev=d5e14ffcd8313aeb4e891908417328039cbb34fc#L32

[go]: https://a.yandex-team.ru/arc_vcs/library/go/test/yatest/env.go?rev=d5e14ffcd8313aeb4e891908417328039cbb34fc#L168


