# Сессии

Сессия – это регистрируемый в системе факт использования автомобиля, который включает в себя поездку и связанные с ней действия. В зависимости от области применения существует три типа сессий.

## carsharing_session {#carsharing}

Используется в каршеринге. Все этапы сессии проходят через эволюцию тега **old_state_reservation**. Он одинаков для всех автомобилей и присваивается каждому из них.

Сессию инициирует пользователь с помощью приложения. Когда он бронирует машину, с тегом **old_state_reservation** выполняется [действие](tags.md#actions) **set_performer**. Пользователь становится исполнителем для тега **old_state_reservation**.

Дальнейшая смена этапов сессии происходит путем выполнения [действия](tags.md#actions) **evolve** над тегом **old_state_reservation**, и тег меняет свое состояние:

![](_images/sheme.svg)

По состоянию тега можно определить, какие действия с автомобилем происходят в данный момент. Как в начале, так и в конце сессии автомобиль находится в состоянии готовности для бронирования.

## engine_session {#engine}

Используется для мониторинга автомобилей. В этом случае нет пользователя и пользовательского приложения.

Сессия строится на основе данных телематики с двигателя автомобиля. Началом сессии служит момент, когда автомобиль приходит в движение. Окончанием — прекращение движения более чем на 10 минут.

## taxi_session {#taxi}

Используется в такси. Сессия формируется путем объединения информации из двух источников:

1. Админки Яндекс Такси — данные о начале и конце поездки.
1. Трека, полученного с телематики.

