# Теги

Тег — это информационный атрибут объекта. Он универсален и не привязан к конкретному типу объекта.

{% cut "Примеры тегов для автомобиля" %}

- Марка и модель.
- Тип резины и дисков.
- Наличие маршрутного компьютера.

{% endcut %}

{% cut "Примеры тегов для пользователя" %}

- Пользовательские настройки приложения.
- Ачивка <q>200 км без резкости</q>.
- Возможность работать в такси.

{% endcut %}

## Содержимое тега {#content}

Содержимое тега зависит от его типа. С типом тега связана логика работы, которую реализует этот тег.

Тег может быть сложным объектом и содержать внутри себя строки с дополнительной информацией. Например, тег, который используется для подключения к таксометру, содержит:

1. ID парка.
1. ID профиля в таксометре.
1. ключ API для подключения к таксометру.
1. ID клиента.

Структура такого тега для каждого пользователя одинакова, а значения параметров различны.

## Действия с тегами {#actions}

Система позволяет выполнять с тегом различные действия. Это могут быть как простые действия, например, добавить или удалить, так и достаточно сложные.

Существуют теги, которые предполагают работу над ними и имеют параметр **Исполнитель**. С наличием исполнителя связаны более сложные действия: тег можно взять в работу и закончить над ним работу. Это необходимо для того, чтобы у тега в каждый момент времени был только один исполнитель.

Примером такого тега может быть заявка на сервисное обслуживание автомобиля. Чтобы его не взяли в работу два разных техника, исполнителем назначается один из них. Информация об исполнителе доступна в приложении и в админке.

Примеры действий с тегами:

|Тег|Описание действия|
|------|------|
|**add**|Добавление к автомобилю необходимого тега, например, описывающего марку или модель.|
|**remove**|Удаление ненужного либо установленного по ошибке тега.|
|**update**|Редактирование тега. Например, исправление данных тега для таксометра.|
|**set_performer**|Добавление исполнителя.|
|**drop_performer**|Удаление исполнителя.|

## Эволюция тега {#evolution}

Тег может изменять свое состояние по заранее прописанному алгоритму. Процесс изменения описывается действием **evolve** и называется эволюцией тега. Это важный механизм, на котором построен ряд процессов. Он нужен для описания работы [сессий](sessions.md).

В качестве примера рассмотрим тег **old_state_reservation**. Он обязательно присваивается каждому автомобилю. С его помощью можно отследить весь цикл бронирования. Цикл состоит из нескольких этапов:

1. Бронирование автомобиля.
1. Приемка автомобиля.
1. Поездка.
1. Завершение.

Этапы цикла бронирования реализуются последовательно один за другим. Одновременно меняет свое состояние тег **old_state_reservation**. Это позволяет определить, какие действия с автомобилем происходят в данный момент.

Важное отличие эволюции тега от редактирования заключается в том, что смена состояний идет не случайным образом, а по заранее написанному алгоритму, и никак иначе. Например, возможен переход из приемки в поездку, но обратный переход из поездки в приемку невозможен.

Тег **old_state_reservation** активно используется в приложении и в роботах, которые отслеживают перемещение автомобиля.

