# Создать цели Градиента

Чтобы оформить цели, поставленные в результате планирования по системе [Градиент](https://wiki.yandex-team.ru/gradient/guide/), используются специальные типы целей — [{{ vs }}, зонтики и контуры](okr.md#types).

Цели Градиента можно создавать и редактировать с помощью стандартной формы или в [табличном представлении](table-view.md). О том, как заполнять поля в целях Градиента, читайте ниже.

## {{ vs }} {#vs}

Цели типа {{ vs }} соответствуют стримам — направлениям бизнеса Поискового портала. Количество таких направлений зафиксировано, создавать новые стримы не нужно.

Стрим — это головной элемент в иерархии целей.

## Зонтик {#umbrella}

Зонтик — это дочерний элемент для стрима. Зонтик объединяет контуры — проекты, которые относятся к одному направлению в рамках стрима.

Чтобы создать зонтик:

1. В правом верхнем углу страницы нажмите кнопку **Создать** и выберите **Создать OKR**.
1. Вверху страницы нажмите слово **контура** и выберите **Зонтика**.
1. Заполните основные поля так же, как при [создании обычной цели](new-goal.md).
1. Укажите информацию для Градиента:
    * В поле **VS ({{ vs }})** укажите стрим, к которому относится зонтик.
    * Если для зонтика существует общая задача на полугодие, укажите ее в поле **Чего хотим добиться (Objective)**.
    * В поле **Как определить успешность (Key Result)** укажите критерии достижения общей задачи зонтика.
    
    {% note info %}
    
    Зонтик может объединять разнородные проекты, поэтому заполнять поля **Чего хотим добиться (Objective)** и **Как определить успешность (Key Result)** для зонтика не обязательно.
    
    {% endnote %}
    
1. Нажмите кнопку **Создать**.

## Контур {#contour}

Контур — это дочерний элемент зонтика. Контур соответствует проекту, которому на планировании поставлены конкретные задачи (Objectives) и критерии их выполнения (Key results).

Дочерние элементы контура — это обычные цели, направленные на достижение ключевых результатов контура.

Чтобы создать контур:

1. В правом верхнем углу страницы нажмите кнопку **Создать** и выберите **Создать OKR**. Откроется форма создания контура.
1. Заполните основные поля так же, как при [создании обычной цели](new-goal.md).
1. В поле **В главных ролях** укажите всех сотрудников, которые участвуют в работе по целям контура.
    
    {% note warning %}
    
    Важно заполнять команды контуров, так как эти данные используются для учета сотрудников, которые работают в стриме. [Указать процент занятости сотрудников](hc-goal-card.md#info-staff) можно после сохранения контура на вкладке **Команда**.
    
    {% endnote %}
    
1. Укажите информацию для Градиента:
    * В поле **Зонтик** укажите зонтик, к которому относится контур.
    * В поле **Тип занятости** выберите значение из списка.
    
    Для инфраструктурных проектов:
    
    * **sustain** — задачи по поддержанию работоспособности сервиса, включая его естественный рост.
    * **optimization** — задачи, нацеленные на уменьшение затрат финансовых или человеческих ресурсов.
    * **i4i** — задачи, которые инфраструктура делает для инфраструктуры (один сервис для другого).
    * **mass** — задачи, у которых нет явно выделенного заказчика (много заинтересованных сервисов).
    * **sponsor** — задачи у которых есть явно выделенный заказчик из другого VS или БЮ (если бы не было заказчика, то мы бы не делали эту задачу).
    
    Для продуктовых проектов:
    * **new feature** — новая фича (не связанная с доработкой текущей функциональности, техдолгом, багами).
    * **client facing** — фича меняет фронт продукта для клиента или заметно меняет клиентский опыт.
    * **short term** — доработка имеет значительное влияние на ключевые результаты контура в горизонте квартала (не является фичей с долгосрочным эффектом).
    
    Для текущей непроектой работы: **run** — выполнение потока задач, например работа менеджеров продаж, юристов.
    * В поле **Чего хотим добиться (Objective)** укажите основную задачу контура.
    * В поле **Как определить успешность (Key Result)** укажите критерии достижения задач контура.
    
    {% note info %}
    
    Поля **Сценарий** и **HeadCount для реализации** заполняются после [согласования проектов на PMC](https://wiki.yandex-team.ru/gradient/guide/#how) (Portfolio Management Committee — комитет управления портфелем).
    
    {% endnote %}
    
1. Нажмите кнопку **Создать**.
