# Tutorials

## Beginner
Первые часы с Go.
* [Tour of Go](https://tour.golang.org/) - минимальная точка входа на примерах
* [How to write Go code](https://golang.org/doc/code.html) - минимально про `go` утилиту и как организован код

## Elementary
Изучается за день, и уже можно базово начать писать код.
* Go blog про встроенные типы и базовые конструкции
    * [Strings, bytes, runes and characters in Go](https://blog.golang.org/strings)
    * [Go Slices: usage and internals](https://blog.golang.org/go-slices-usage-and-internals)
    * [Arrays, slices (and strings): The mechanics of 'append'](https://blog.golang.org/slices)
    * [Go maps in action](https://blog.golang.org/go-maps-in-action)
    * [constants](https://blog.golang.org/constants)
    * [Defer, Panic, and Recover](https://blog.golang.org/defer-panic-and-recover)
    * [Error handling and Go](https://blog.golang.org/error-handling-and-go)
    * [Organizing Go code](https://blog.golang.org/organizing-go-code)
    * [go fmt your code](https://blog.golang.org/go-fmt-your-code)
    * [Godoc: documenting Go code](https://blog.golang.org/godoc-documenting-go-code)
    * [Effective Go](https://golang.org/doc/effective_go.html) - обзор базовых правил разработки и всех языковых конструкций
    * [Go Code Review Comments](https://github.com/golang/go/wiki/CodeReviewComments) - важное дополнение Effective Go про правила разработки

## Pre-intermediate
Второй день с Go.
* [The Go type system for newcomers](https://rakyll.org/typesystem/)
* [Go Data Structures: Interfaces](https://research.swtch.com/interfaces) - как устроены interface значения
* [The Laws of Reflection](https://blog.golang.org/laws-of-reflection) - про reflection в go
* [Go tooling essentials](https://rakyll.org/go-tool-flags/)
* [JSON and Go](https://blog.golang.org/json-and-go)
* [Slice tricks](https://github.com/golang/go/wiki/SliceTricks)
* Concurrency:
    * [The Go Memory Model](https://golang.org/ref/mem)
    * [Share Memory By Communicating](https://blog.golang.org/share-memory-by-communicating)
    * [Go Concurrency Patterns: Pipelines and cancellation](https://blog.golang.org/pipelines)
    * [Go Concurrency Patterns: Context](https://blog.golang.org/context)

Опционально.
* [FAQ](https://golang.org/doc/faq) - Заглянуть сначала сюда, если возникают вопросы вида "А почему в Go ...?"
* [Go by Example](https://gobyexample.com) - больше базовых примеров

## Low Intermediate
Третий день с Go.
* [Using Subtests and Sub-benchmarks](https://blog.golang.org/subtests)
* [TableDrivenTests](https://github.com/golang/go/wiki/TableDrivenTests)
* [Concurrency is not parallelism](https://blog.golang.org/concurrency-is-not-parallelism)
* [Go Concurrency Patterns](https://www.youtube.com/watch?v=f6kdp27TYZs)


## Intermediate
* Базовый тулинг
    * [Race detector](https://blog.golang.org/race-detector)
    * [Test coverage](https://blog.golang.org/cover)
* [Advanced Go Concurrency Patterns](https://blog.golang.org/advanced-go-concurrency-patterns)

## Upper Intermediate
* Advanced тулинг
    * [Profiling Go Programs](https://blog.golang.org/profiling-go-programs)
    * [Diagnostics](https://golang.org/doc/diagnostics.html)

## Other
[https://github.com/golang/go/wiki](https://github.com/golang/go/wiki)

## Архитектура приложений
1. [Clean architecture](http://blog.cleancoder.com/uncle-bob/2012/08/13/the-clean-architecture.html)
2. [Заблуждения clean architecture](https://habr.com/company/mobileup/blog/335382/)

## PS
Спасибо [@skipor](https://staff.yandex-team.ru/skipor) за изначальное наполнение.
