{% note info %}

Документация переехала на новый инструмент деплоя (от Яндекс.Облака). Теперь в документации поддерживается синтаксис YFM. Подробнее про синтаксис можно прочесть в репозитории [YFM](https://github.yandex-team.ru/data-ui/yfm/blob/master/DOCS.md).

Ключевые изменения:

- Оглавление перхало в файл `toc.yaml`;
- Настройки лежат в файле `.yfm`;
- В Аркануме появился виджет, который позволяет выкатить документацию в [production](http://docs.yandex-team.ru)/[testing](https://testing.docs.yandex-team.ru);
- Сейчас настроен авторелиз доументации, все что попадет в trunk будет автоматически выложено в в [production](http://docs.yandex-team.ru) и [testing](https://testing.docs.yandex-team.ru);
- На каждый pull request в комментарий будет прибегать робот и давать ссылку на свежую документацию.

{% endnote %}


# Как написать новую страницу или внести изменения

1. Создаем страницу, например `test_page.md` в папке **arcadia/billing/docs**:

   ```bash
   touch arcadia/billing/docs/test_page.md
   ```

2. Добавляем ее в SVN и выставляем тип  `text/markdown`:

   ```bash
   svn add test_page.md
   svn propset svn:mime-type 'text/markdown' test_page.md
   ```

3. Наполняем страницу текстом. Предварительно рекомендуется прочесть раздел [Общие правила оформления документации](#Общие правила оформления документации), который находится ниже;

4. Добавляем файл в оглавление `toc.yml`;

5. Собираем файл и проверяем его локально:

   ```bash
   mkdir docs
   ya make --checkout
   tar -xzf docs.tar.gz -C docs
   python3 -m http.server 8888 -d docs
   или
   cd docs
   python ../dev-server.py
   ```
   Либо делаем pull request:

   ```bash
   ya pr create -m 'My new page'
   ```
   N.B. ya make --checkout при сборке документации не вытаскивает директорию arcadia/tools.
   Нужно её руками чекаутить, после чего запускать сборку документации.


6. Если все хорошо, заливаем изменения в SVN:

   ```bash
   svn commit -m 'My new page'
   ```


# Краткая справка про используемый диалект Markdown

* Заголовки на отдельной строке начиная с `# `, `## ` или `### `.
* Выделение жирным в `**звёздочках**` или `__подчеркиваниях__`.
* Ссылки `[якорь](http://...)`, картинки `![с восклицательным знаком](http://...jpeg)`.
* Списки на строках начинающихся с `* неупорядоченный` или `1. упорядоченный`.
* Кусочек кода по тексту <code>&#96;в backtick&#96;</code>.
* Блок кода начинается и заканчивается на строку <code>&#96;&#96;&#96;с тремя backtick&#96;&#96;&#96;</code>.
* Яркий блок с информацией `{% note info %}`, на следующей строке текст без отступа, на слудющей строке `{% endnote %}`, после `note` может быть `warning` для предупреждений.

* Скрыть блок за кликом: `<details markdown="1"> <summary>Заголовок</summary> скрываемый контент</details>`.
* Цветной текст: `<span style="color: red;">текст</span>`.
* Дополнительный якорь, куда можно ссылаться: `<a name="my_anchor"></a>`, у заголовков полностью на английском они создаются автоматически по принципу `"FoO Bar" -> "foo-bar"`.
* Таблица:
```
| Заголовок 1 | Заголовок 2 | Заголовок 3 |
| ----------- | ----------- | ----------- |
| Ячейка   А1 | Ячейка   А2 | Ячейка   А3 |
| Ячейка   Б1 | Ячейка   Б2 | Ячейка   Б3 |
| Ячейка   В1 | Ячейка   В2 | Ячейка   В3 |
```


# Общие правила оформления документации

## Описание раздела

Каждый раздел начинается с краткого обзора, о чем будет идти речь.

## Ссылка на другой раздел

Название раздела в ссылке необходимо писать с большой буквы.

## Заголовки

Заголовки должны иметь якоря:

```
##### Пользователи, группы {: #users_groups :}
```

## Списки

Каждый элемент упорядоченного списка начинается с большой буквы, а неупорядоченного списка начинается с маленькой буквы и заканчивается символом ';'. Последний элемент списка заканчивается точкой.

**Упорядоченный:**

1. Вида доступа (чтение, запись и т.д.);
2. Пользователя, инициировавшего запрос;
3. Объекта, к которому доступ запрашивается.

**Неупорядоченный:**

* вида доступа (чтение, запись и т.д.);
* пользователя, инициировавшего запрос;
* объекта, к которому доступ запрашивается.

## Инфоблоки

Информационные примечания задаются: `{% note info %} ... {% endnote %}`. Само примечание начинается с большой буквы.

```
{% note info "Примечание" %}

Текст

{% endnote %}
```

Предупреждающие примечания задаются: `{% note warning %} ... {% endnote %}`. Само примечание начинается с большой буквы.

```
{% note info "Примечание" %}

Текст

{% endnote %}
```

Если для понимания раздела есть требования, то они оформляются следующим образом:

```
{% note warning "Внимание" %}

    Для понимания изложенного в разделе материала требуется знание основ/устройства/принципов ... того-то (со ссылками)

{% endnote %}
```

## Таблицы

На таблицу должна быть ссылка: **В таблице 1 представлен**...
Обязательно наличие слов: **Таблица N — *Название таблицы с большой буквы, без точки в конце***

Пример:

<small>Таблица 1 — Атрибуты субъектов</small>

| **Атрибут**         | **Тип**         | **Описание**                                                 |
| ------------------- | --------------- | ------------------------------------------------------------ |
| `name`              | `string`        | Имя субъекта (непустая строка)                               |
| `member_of`         | `array<string>` | Список имен групп, которым непосредственно принадлежит данный субъект |
| `member_of_closure` | `array<string>` | Список имен групп, которым принадлежит субъект (прямо или косвенно) |

Листинги

Аналогично таблицам. Желательна ссылка на листинг. Название с большой буквы, без точек на конце. Например: "в листинге 1 приведен пример запуска проверки ACL".

<small>Листинг 1 — Пример запуска проверки ACL</small>

```bash
$ yt check-permission yql write //tmp
{
    "action" = "allow";
    "object_id" = "1-3-411012f-1888ce1f";
    "object_name" = "node //tmp";
    "subject_id" = "c4-8aaa-41101f6-bec6113b";
    "subject_name" = "yandex";
}
```
