# JSON

JSON — самый популярный формат обмена данными между приложениями, его удобно использовать для получения данных от сервера. JSON сохраняют в файл с расширением `.json`.

Обычная схема работы:

1. Отправить запрос на сервер.
1. Получить в ответ JSON с набором данных.
1. Преобразовать JSON в объект JavaScript.
1. Использовать данные.

Структура разметки JSON напоминает JavaScript.

## Объекты {#objects}

Объект — набор пар ключ-значение, заключенных в фигурные скобки `{ }`.

Пары разделяются между собой запятыми — `,`, а ключ отделяется от значения через двоеточие — `:`.

В примере каждая пара ключ-значение — это строки (`string`): 
```json
{
  "key1": "value1",
  "key2": "value2"
}
```

Ключом может быть только строка (`string`).

Значением может быть строка (`string`), целое число (`integer`) или логическое значение (`boolean`).

Строки всегда выделяются двойными кавычками, для целых чисел и логических значений кавычки не ставятся.

## Массивы {#arrays}

Массивом в JSON является список элементов в квадратных скобках `[ ]`: 
```json
["first", "second", "third"]
```

Список элементов может содержать строки, числа, логические значения, массивы или другие объекты. Для целочисленных или логических значений кавычки не используются.

Массив целых чисел: 
```json
[1, 2, 3]
```

Массив логических значений: 
```json
[true, false, true]
```

## Комбинации массивов и объектов {#composition}

JSON может содержать объекты и массивы внутри друг друга.

Пример массива объектов: 
```json
[  
  {  
    "animal":"cat",
    "age": 6
  },
  {  
    "animal": "dog",
    "age": 2
  }
]
```

Объекты могут содержать массивы в части значения пары ключ-значение: 
```json
{
  "city": ["Moscow", "StPetersburg", "Novosibirsk", "Kazan"],
  "weather": ["sunny", "windy", "rain", "snow"]
}
```

## Комментарии {#comments}

JSON в основном не поддерживает комментарии, JavaScript-комментарий `// комментарий` приведет к ошибке.

