# YAML

YAML (англ. _YAML Ain't Markup Language_ или _Yet Another Markup Language_) — язык для хранения структурированной информации. Расширение файла может быть `.yaml` или `.yml`.

В большинстве случаев YAML и JSON — это разные способы структурирования одних и тех же данных.

## Синтаксис YAML {#syntax}

В синтаксисе YAML очень важны интервалы (пробелы) в начале строк. Каждый отступ из двух пробелов обозначает новый уровень, т.е. новый объект.

В примере объект `level1` содержит объект `level2`, который содержит объект `level3`. 
```yaml
level1:
  level2:
    level3:
```

{% note info %}

В YAML не используется Tab (так как интервал между вкладками нестандартен). Вместо этого дважды нажимается пробел.

{% endnote %}


Каждый уровень может содержать либо одну пару ключ-значение (также называемую словарем), либо последовательность (список дефисов): 
```yaml
level3:
  -
    itema:"one"
    itemameta: "two"
  -
    itemb: "three"
    itembmeta: "four"
```

Значения для каждого ключа могут быть заключены в кавычки. Если в значении есть двоеточие или кавычка, нужно заключить его в кавычки.

## Отличие YAML от JSON {#difference}

### Иерархия

Иерархия в файле YAML обозначается двойными пробелами, а в JSON объекты и массивы обозначаются фигурными и квадратными скобками соответственно.

### Кавычки

В YAML не обязательно использовать кавычки для строк, хотя кавычки также поддерживаются. Строки можно обозначать и кавычками, и без. Например:

```
key1: value1
```

или

```
key1: "value1"
```

### Комментарии

В YAML можно комментировать строки, используя знак `#`.

### Якорь

Якорь, или ссылочная переменная, — это приспособление для создания переменных, на которые можно ссылаться. YAML позволяет использовать якоря . Например, есть два схожих определения. Можно написать определение один раз и использовать указатель для ссылки на оба: 
```yaml
api: &apidef Application programming interface
application_programming_interface: *apidef
```

Если вы обратитесь к значению, для обоих будет использоваться одно и то же определение. `*apidef` действует как указатель на определение, установленное в `&apidef`.


## Сравнение YAML и JSON {#difference}

{% list tabs %}

- Пара ключ-значение

  JSON:
  ```json
  {
   "key1": "value1",
   "key2": "value2"
  }
  ```

  YAML:
  ```yaml
  key1: value1
  key2: value2
  ```

- Массив

  JSON:
  ```json
  ["first", "second", "third"]
  ```

  YAML:
  ```yaml
  - first
  - second
  - third   
  ```

- Объект с массивом

  JSON:
  ```json
  {
    "city": ["Moscow", "StPetersburg", "Novosibirsk", "Kazan"],
    "weather": ["sunny", "windy", "rain", "snow"]
  }
  ```

  YAML:
  ```yaml
  city:
   - Moscow
   - StPetersburg
   - Novosibirsk
   - Kazan
  weather:
   - sunny
   - windy
   - rain
   - snow
  ```
- Массив с объектами

  JSON:
  ```json
  [  
   {  
     "animal":"cat",
     "age": 6
   },
   {  
      "animal": "dog",
      "age": 2
    }
  ]
  ```

  YAML:
  ```yaml
  -
    animal: cat
    age: 6
  -
    animal: dog
    age: 2
  ```
{% endlist %}
