# HTTP-методы

С помощью метода указывается тип операции, который нужно выполнить. Учитывайте, что все методы, кроме `GET` тем или иным образом модифицируют объект. Например, если вы удалите объект, вы уже не сможете его скопировать.

## Типы методов {#types-of-methods}

В документации на HTTP API есть два типа методов:
- **Метод HTTP** — тип запроса, определяющий операцию, которую нужно осуществить с указанным ресурсом. Это обращение к API через протокол. 
  
  Часто используется понятие HTTP-запрос, хотя оно не полностью эквивалентно HTTP-методу. Запрос содержит в себе еще заголовки, версию протокола и URI и т.д.
  
- **Метод API** (ручка) — действие, которое HTTP-метод совершает над ресурсом, включает запрос и ответ.
  
   В нашей документации лучше использовать понятие **операция**, чтобы избежать двусмысленности. Но **метод API** использовать тоже можно. В разговорном варианте называется ручкой.

## Что делают методы {#table-of-methods}

Метод | Действие
----- | -----
`GET` | Чтение
`POST` | Создание
`UPDATE` | Обновление
`PUT` | Изменение
`PATCH` | Частичное изменение
`DELETE` | Удаление
`COPY` | Копирование
`ADD` | Добавление
`HEAD` | Чтение (сокращенная версия `GET`, не возвращает тело запроса)
`OPTIONS` | Запрос описания других методов, которые поддерживаются сервером
`LINK/UNLINK` | Создание/удаление связи между объектами
`PURGE` | Удаление с очисткой кеша
`LOCK/UNLOCK` | Блокировка/разблокировка
`PROPFIND` | Извлечение свойств ресурса, упомянутого в URI


