# Запрос

Запрос — сообщение, которое клиент отправляет серверу.

## Пример запроса {#request-example}

Запрос, с помощью которого можно создать задание через [API Яндекс&#160;Толоки](https://yandex.ru/dev/toloka/doc/concepts/create-task.html):

```
POST https://toloka.yandex.com/api/v1/tasks ?
  [async_mode=<true/false>]
& [allow_defaults=<true/false>]
& [skip_invalid_items=<true/false>]
& [open_pool=<true/false>]
& [operation_id=<id операции>]

Authorization: OAuth <OAuth-токен>
Content-Type: application/JSON

{<данные задания>}
```

В этом примере:
- `POST https://toloka.yandex.com/api/v1/tasks` — стартовая строка:
    - `POST` — метод для создания задания;
    - `https://` — протокол;
    - `toloka.yandex.com/api/v1/` — путь к ресурсу API Толоки;
    - `tasks` — ресурс.
    
- `async_mode`, `allow_defaults`, `skip_invalid_items`, `open_pool`, `operation_id` — необязательные параметры строки запроса;
- `Authorization`, `Content-Type` — HTTP-заголовки;
- `{<данные задания>}` — тело запроса.


## Стартовая строка {#start}

В стартовой строке (англ. _starting line_) запроса указывается метод, протокол, путь к ресурсу и ресурс, например:

```
POST https://toloka.yandex.com/api/v1/tasks
```

### Метод запроса {#method}

Методы HTTP-запроса устанавливают назначение запроса и операцию, которую нужно выполнить с указанным ресурсом. 

Метод обозначается обычно одним коротким английским словом, записанным заглавными буквами. Написание названия метода чувствительно к регистру.

Пример: `POST`, `GET`.


### Протокол {#protocol}

В запросе указывается протокол. От него зависит способ передачи данных и набор доступных методов.

В документации Яндекса обычно не указывается версия протокола, но при необходимости номер версии записывается в конце стартовой строки. Например: 
```
GET http://developer.mozilla.org/ru/docs/Web/HTTP/Messages HTTP/1.1
```


### Путь к ресурсу (конечная точка) {#endpoint}

Путь к ресурсу задается базовым путем (адресом сервиса) и параметрами пути.

Введя в адресную строку `https://toloka.yandex.com/api/v1/tasks`, вы:

1. Обратитесь к серверу `toloka.yandex.com`.
2. Запросите ресурс под названием `/tasks`.

### Ресурс {#resource}

Ресурс — это объект, с которым пользователь сможет взаимодействовать через API. Один и тот же ресурс обычно имеет множество связанных конечных точек, каждая из которых имеет разные пути и методы, но возвращает различную информацию об одном и том же ресурсе.

Пример описаний методов с ресурсом заданий API Толоки `/tasks`:
- Создать задание: `POST /tasks`
- Получить задание: `GET /tasks/<task_id>`
- Изменить задание: `PATCH /tasks/<task_id>`


## Типы параметров {#parameters}

### Параметры пути к ресурсу (path) {#path}

Параметры в пределах конечной точки перед строкой запроса, отделяются с помощью `/`. В документации обычно выделяются фигурными (`{}`) или угловыми скобками (`<>`). Параметры пути являются частью конечной точки.

Пример:

```
https://toloka.yandex.ru/api/v1/operations/{id операции}/log
```

Здесь `{id операции}` — параметр пути.

### Параметры строки запроса (query) {#query}

Обязательные и дополнительные данные, которые конкретизируют, какое действие произойдет. Указываются в конечной точке после знака вопроса и перечисляются один за другим с амперсандом (`&`) в качестве разделителя. Порядок параметров не важен.

В документации Яндекса необязательные параметры обычно оформляются квадратными скобками (`[ ]`). В других случаях обязательные параметры помечаются звездочкой (`*`).


Пример:

```
POST https://toloka.yandex.ru/api/v1/tasks ?
  [async_mode=<true/false>]
& [allow_defaults=<true/false>]                      
```

В запросе эти параметры будут выглядеть вот так:

```
https://toloka.yandex.ru/api/v1/tasks?allow_defaults=true&async_mode=false
```

### Параметры заголовка запроса (header) {#header}

В заголовках содержится информация о домене, сжатии, шифровании и формате данных, кодировке и прочая важная информация.

Заголовки запроса HTTP имеют стандартную для заголовка HTTP структуру из двух частей: 
* Строка, не зависящая от регистра. Завершается двоеточием.
* Значение, структура которого определяется заголовком. 
  
Весь заголовок, включая значение, представляет собой одну строку, которая может быть довольно длинной.

Пример:

```
Content-Type: application/JSON
```

Заголовки обычно относятся к авторизации и для каждой конечной точки не документируются.

Существует множество заголовков. Их можно разделить на несколько групп:

- Основные заголовки (англ. _general headers_), например, `Via (en-US)`, относящиеся к сообщению в целом.
- Заголовки запроса (англ. _request headers_), например, `User-Agent`, `Accept-Type`.
- Заголовки сущности (англ. _entity headers_), например `Content-Length`, относящиеся к телу сообщения. Они отсутствуют, если у запроса нет тела.

### Параметры тела запроса (body) {#body}

В теле сообщения содержатся данные, которые требуется передать. Тело всегда отделяется от заголовков хотя бы одной пустой строкой. В теле может передаваться HTML-документ или JSON с данными.

Пример:

```json
{
  "overlap": 3,
  "infinite_overlap": false
}                      
```

Тело может быть добавлено, если метод запроса допускает его передачу. Запросы, собирающие ресурсы, такие как `GET`, `HEAD`, `DELETE` или `OPTIONS`, в нем обычно не нуждаются.

При передаче тела запроса нужно передать соответствующий параметр заголовка. Без этого заголовка попытка передать тело запроса выдаст примерно такую ошибку: `UNSUPPORTED_MEDIA_TYPE`.

Тела можно условно разделить на две категории:

- Одноресурсные тела (англ. _single-resource bodies_), состоящие из одного отдельного файла, определяемого двумя заголовками: `Content-Type` и `Content-Length`.
- Многоресурсные тела (англ. _multiple-resource bodies_), состоящие из множества частей, каждая из которых содержит свой сегмент информации.

