# Заголовок страницы запроса

Возвращает конфетку.


## Формат запроса {#request-format}
```
хост (обычно -- https://yandex.<домен>/{имя постоянного path-параметра}/{имя path-параметра})
  ? имя обязательного query-параметра=<текст для проброса в формат запроса (что будет написано в треугольных скобках в формате запроса)>
  & [имя query-параметра=<текст для проброса в формат запроса (что будет написано в треугольных скобках в формате запроса)>]
  & [добавляйте еще параметры=<и еще текст>]
```

### Параметры {#params}

- `имя постоянного path-параметра` — здесь ничего не пишем, тогда текст не будет пробрасываться в формат запроса.
- `имя path-параметра`, `имя обязательного query-параметра`, `имя query-параметра`, `добавляйте еще параметры` — описание параметра.
 
### Тело запроса (только для post) {#request-body}


{% list tabs %} 

- XML

	```xml
	<to>
                  <code>c146</code>
                  </to>
                  <from>
                  <title>Симферополь</title>
                  </from>
	```

- JSON

	```javascript
	{ 
                  "to":
                  {
                  "code":"c146",
                  },
                  "from":
                  {
                  "title":"Симферополь"
                  }
                  }
    ```

{% endlist %}


_Автолинковка на основе таблиц:_

| Название поля/элемента | Описание                         |
|------------------------|----------------------------------|
| `to`[^*^](#aster)                  | Информация о пункте прибытия.    |
| `code`                 | Код пункта прибытия.             |
| `from`                 | Информация о пункте отправления. |
| `title`                | Название пункта отправления.     |


_Автолинковка на основе tree_

```json
{  
            "id":{integer},
            "templateId":{integer},
            "parameters":[
            {...}
            ],  
            "tnsArticles":[
            {
            "id":"{string}",
            "name":"{string}"
            },
            ...
            ],
            "tnsBrands":[
            {
            "id":"{string}",
            "name":"{string}"
            },
            ...
            ],
            ...
            }
```

`id`[^*^](#aster)

: Идентификатор креатива.

`templateId`

: Идентификатор шаблона. Список шаблонов можно посмотреть с помощью операции `GET/templates`.

`parameters`

: Массив объектов с параметрами шаблона, которые используются при создании креатива. Список параметров шаблона можно посмотреть с помощью операции `GET/templates`.

`tnsArticles`

: Массив объектов, содержащий рекламируемые категории товаров и услуг.

  `id`
  
  : Идентификатор категории товара или услуги.
  
  `name`
  
  : Название категории товара или услуги.
  
`tnsBrands`

: Массив объектов, содержащий рекламируемые бренды.

  `id`
  
  : Идентификатор рекламируемого бренда.
  
  `name`
  
  : Название рекламируемого бренда.


###### ^*^ Обязательный параметр {#aster}

## Формат ответа {#response-body}

_Возьмите пример из раздела [Тело запроса (только для post)](#request-body)_


## Коды ответа {#response-codes}

#|
||Код   | Описание||
||      | 

{% cut "Ответ API" %}

Опционально

{% endcut %}

||
||      |  ||
||      |  ||
||      |  ||
|#


## Пример {#example}
