# Perl 

Интерфейс устанавливается пакетом `yandex-lang-detect-perl`.


## Класс lookup {#class_lookup}

В классе реализован функционал библиотеки по выбору домена и региона пользователя, языка отображаемой страницы и списка релевантных пользователю языков.

**Список методов класса:**

Метод | Описание
----- | -----
[find](#m_find) | Определяет язык отображения страницы.
[find_without_domain](#m_find_without_domain) | Определяет язык отображения страницы альтернативным алгоритмом, не учитывающим домен запроса.
[list](#m_list) | Создает список релевантных пользователю языков.
[filepath](#m_filepath) | Возвращает путь к файлу данных `lang-detect-data.txt`.
[cookie2language](#m_cookie2language) | Преобразует числовой идентификатор языка в строковый.
[language2cookie](#m_language2cookie) | Преобразует строковый идентификатор языка в числовой.
[findDomain](#m_findDomain) | Возвращает домен пользователя.
[findDomainEx](#m_findDomainEx) | Определяет домен и регион пользователя.


### Конструктор {#class_lookup}

Конструктор класса принимает в качестве параметра путь к файлу с данными `lang-detect-data.txt`.

### Метод find {#m_find}

```perl
sub find( )
```

Возвращает язык отображения страницы.

В качестве параметра принимает ассоциативный массив (хеш) с ключами:

Ключ | Описание
----- | -----
geo | Регион пользователя.
language | Язык из поля **Accept-Language** заголовка HTTP пакета.
domain | Домен.
cookie | Язык из куки **my**.
filter | Перечень доступных в домене языков.
pass-language | [Язык](source-data.md) из **Паспорта**.
default | Язык сервиса по умолчанию.


**Возвращаемое значение**

Хеш, содержащий язык отображения страницы.

Ключ | Описание
----- | -----
lang | Код языка, например uk,kk.
name | Название языка, например Ua,Kz.


### Метод find_without_domain {#m_find_without_domain}

```perl
sub find_without_domain( )
```

Возвращает язык отображения страницы.

В качестве параметра принимает ассоциативный массив (хеш) с ключами:

Ключ | Описание
----- | -----
geo | Регион пользователя.
language | Язык из поля **Accept-Language** заголовка HTTP пакета.
cookie | Язык из куки **my**.
filter | Перечень доступных в домене языков.
pass-language | [Язык](source-data.md) из **Паспорта**.
default | Язык сервиса по умолчанию.


**Возвращаемое значение**

Хеш, содержащий язык отображения страницы.

Ключ | Описание
----- | -----
lang | Код языка, например uk,kk.
name | Название языка, например Ua,Kz.


### Метод list {#m_list}

```perl
sub list( )
```

Возвращает список релевантных пользователю языков.

В качестве параметра принимает хеш с теми же ключами, что и метод `find`.

**Возвращаемое значение**

Массив хешей с перечнем языков. Первое значение - язык сервиса по умолчанию. Ключи хеша такие же как в выводе метода `find`.

### Метод filepath {#m_filepath}

```perl
sub filepath( )
```

Возвращает путь к файлу данных `lang-detect-data.txt`.

Параметров не имеет.

**Возвращаемое значение**

Cкаляр, содержащий путь к файлу с данными.

### Метод cookie2language {#m_cookie2language}

```perl
sub cookie2language( )
```

Предназначен для преобразования числового идентификатора языка в строковый идентификатор.

Параметры:

Параметр | Описание
----- | -----
Скаляр | Целочисленный идентификатор языка из куки** my**.


**Возвращаемое значение**

Строковый идентификатор языка.

### Метод language2cookie {#m_language2cookie}

```perl
sub language2cookie( )
```

Преобразует строковый идентификатор языка в числовой.

Параметры:

Параметр | Описание
----- | -----
Скаляр | Строковый идентификатор языка.


**Возвращаемое значение**

Целочисленный идентификатор языка.

### Метод findDomain {#m_findDomain}

```perl
sub findDomain( )
```

Возвращает домен пользователя.

В качестве параметра принимает хеш с ключами:

Ключ | Описание
----- | -----
geo | Регион пользователя.
domain | Домен.
filter | Перечень доступных для переадресации доменов.
cr_cookie | `cr`-блок куки [куки yp](https://wiki.yandex-team.ru/cookies/y#yp).


**Возвращаемое значение**

Скаляр, содержащий домен пользователя.

### Метод findDomainEx {#m_findDomainEx}

```perl
sub findDomainEx( )
```

Возвращает домен и регион пользователя.

В качестве параметра принимает хеш с ключами:

Ключ | Описание
----- | -----
geo | Регион пользователя.
domain | Домен.
filter | Перечень доступных для переадресации доменов.
cr_cookie | `cr`-блок куки [куки yp](https://wiki.yandex-team.ru/cookies/y#yp).


**Возвращаемое значение**

Хеш, содержащий домен и регион пользователя.

Ключ | Описание
----- | -----
domain | Домен.
changed | 1 - если логикой библиотеки найден домен для переадресации.
content-region | Регион пользователя.



## Пример {#examples}

```perl
use langdetect;
use Data::Dumper;

my $l = new langdetect::lookup('/usr/share/yandex/lang_detect_data.txt');
print "\nfilepath: ", $l->filepath(), "\n";

$url='http://mail.yandex.ru/neo2';
$geo=[24896,20529,20524,187,166,10001,10000];

my $di = {
    'domain'=>$url,
    'geo'=>$geo,
    'filter'=>['by','kz','ua','ru'],
};
print "\nfindDomain:\n", Dumper($l->findDomainEx($di)), "\n";

my $ui = {
    'geo'=>$geo,
    'filter' => ['ru','be','kk','tt', 'uk'],
    'language' => 'en',
    'domain' => 'yandex.ru',
    'cookie' => 2, # 0 - auto, 1 - ru, 2 - uk
    'pass-language' => 'kk', # it has high priority than cookie value
    'default' => 'ru',
};
print "find:\n", Dumper($l->find($ui)), "\n";
print "list:\n", Dumper($l->list($ui)), "\n";
```

Результат

```perl
filepath: /usr/share/yandex/lang_detect_data.txt

findDomain:
$VAR1 = {
          'domain' => 'mail.yandex.ua',
          'changed' => 1,
          'content-region' => 24896
        };

find:
$VAR1 = {
          'lang' => 'kk',
          'name' => 'Kz'
        };

list:
$VAR1 = [
          {
            'lang' => 'ru',
            'name' => 'Ru'
          },
          {
            'lang' => 'kk',
            'name' => 'Kz'
          },
          {
            'lang' => 'uk',
            'name' => 'Ua'
          }
        ];

```

