# Python

Интерфейс устанавливается пакетом `xscript-yandex`. Установка с помощью pip недоступна из-за ограничений на портальные библиотеки.


## Класс lookup {#class_lookup}

В классе реализован функционал библиотеки по выбору домена и региона пользователя, языка отображаемой страницы и списка релевантных пользователю языков.

Все ключи описанных ниже методов могут быть опциональны, при пустом словаре и результат будет тоже пустой. Все ключи и значения входного словаря должны быть строками.

**Список методов класса:**

Метод | Описание
----- | -----
[find](#m_find) | Определяет язык отображения страницы.
[findWithoutDomain](#m_findWithoutDomaine) | Определяет язык отображения страницы альтернативным алгоритмом, не учитывающим домен запроса.
[list](#m_list) | Создает список релевантных пользователю языков.
[filepath](#m_filepath) | Возвращает путь к файлу данных `lang-detect-data.txt`.
[cookie2language](#m_cookie2language) | Преобразует числовой идентификатор языка в строковый.
[language2cookie](#m_language2cookie) | Преобразует строковый идентификатор языка в числовой.
[findDomain](#m_findDomain) | Возвращает домен пользователя.
[findDomainEx](#m_findDomainEx) | Определяет домен и регион пользователя.
[trySwap](#m_trySwap) | Обновление данных.


### Конструктор {#class_lookup_a}

Конструктор класса принимает в качестве параметра путь к файлу с данными `lang-detect-data.txt`.

### Метод find {#m_find}

```
def find( params )
```

Возвращает язык отображения страницы.

В качестве параметра принимает словарь с ключами:

Ключ | Описание
----- | -----
geo | Регион пользователя
language | Язык из поля **Accept-Language** заголовка HTTP запроса.
domain | Домен.
cookie | Язык из куки **my**.
filter | Перечень доступных языков.
pass-language | [Язык](source-data.md) из **Паспорта**.
default | Язык сервиса по умолчанию.


**Возвращаемое значение**

Cписок, содержащий язык отображения страницы.

### Метод findWithoutDomain {#m_findWithoutDomaine}

```
def findWithoutDomain( params )
```

Определяет язык отображения страницы альтернативным алгоритмом, не учитывающим домен запроса.

В качестве параметра принимает словарь с ключами:

Ключ | Описание
----- | -----
geo | Регион пользователя
language | Язык из поля **Accept-Language** заголовка HTTP запроса.
cookie | Язык из куки **my**.
filter | Перечень доступных языков.
pass-language | [Язык](source-data.md) из **Паспорта**.
default | Язык сервиса по умолчанию.


**Возвращаемое значение**

Cписок, содержащий язык отображения страницы.

### Метод list {#m_list}

```
def list( params )
```

Возвращает список релевантных пользователю языков.

В качестве параметра принимает словарь с теми же ключами, что и метод `find`.

**Возвращаемое значение**

Список с перечнем языков.

### Метод filepath {#m_filepath}

```
def filepath()
```

Возвращает путь к файлу данных `lang-detect-data.txt`.

Параметров не имеет.

**Возвращаемое значение**

Строка, содержащая путь к файлу с данными.

### Метод cookie2language {#m_cookie2language}

```
def cookie2language( value )
```

Преобразует числовой идентификатор языка в строковый.

Параметры:

Параметр | Описание
----- | -----
value | Целочисленный идентификатор языка из куки **my**.


**Возвращаемое значение**

Строковый идентификатор языка.

### Метод language2cookie {#m_language2cookie}

```
def language2cookie( lang )
```

Преобразует строковый идентификатор языка в числовой.

Параметры:

Параметр | Описание
----- | -----
lang | Строковый идентификатор языка.


**Возвращаемое значение**

Целочисленный идентификатор языка.

### Метод findDomain {#m_findDomain}

```
def findDomain( params )
```

Возвращает домен пользователя.

В качестве параметра принимает словарь со следующими ключами:

Ключ | Описание
----- | -----
geo | Регион пользователя.
domain | Домен.
filter | Перечень доступных для переадресации доменов.
cr_cookie | `cr`-блок куки [куки yp](https://wiki.yandex-team.ru/cookies/y#yp).


**Возвращаемое значение**

Список, содержащий домен пользователя.

### Метод findDomainEx {#m_findDomainEx}

```
def findDomainEx( params )
```

Возвращает домен и регион пользователя

В качестве параметра принимает словарь со следующими ключами:

Ключ | Описание
----- | -----
geo | Регион пользователя.
domain | Домен.
filter | Перечень доступных для переадресации доменов.
cr_cookie | `cr`-блок куки [куки yp](https://wiki.yandex-team.ru/cookies/y#yp).


**Возвращаемое значение**

Словарь, содержащий домен и регион пользователя со следующими ключами:

Ключ | Описание
----- | -----
domain | Домен.
content-region | Регион пользователя.
changed | True - если логикой библиотеки найден домен для переадресации.


### Метод trySwap {#m_trySwap}

```
def trySwap()
```

Метод определяет изменился ли файл `lang-detect-data.txt` с момента создания объекта класса `lookup`.

**Возвращаемое значение**

**true** - если файл изменился.

**Примечания**

Если метод вернул **true**, т.е. файл изменился - следует создать новый объект класса `lookup`, а старый удалить.


## Пример {#examples}

```python
import langdetect
#Параметры вызовов
geo_regions = '24896,20529,20524,187,166,10001,10000'
pass_lang = 'ru'
filepath = '/usr/share/yandex/lang_detect_data.txt'
#Словарь для вызова findDomainEx
dict1 = { 'domain': 'http://mail.yandex.ru/neo2', 'filter': 'ua,by,kz', 'geo': geo_regions }
#Словарь для вызовов find и list
dict2 = { 'geo': geo_regions, 'language': 'en', 'domain': 'yandex.ru', 'cookie': '0', 'filter': 'tt,ru,uk', 'pass-language': pass_lang, 'default': 'ru' }

l = langdetect.lookup(filepath)

print "findDomainEx:\n", l.findDomainEx(dict1)

print "find:\n", l.find(dict2)
print "list:\n", l.list(dict2)
empty = {}
print "find empty:\n", l.find(empty)
print "list empty:\n", l.list(empty)

print "trySwap:\n", l.trySwap()
```

Результат

```no-highlight
findDomainEx:
{'domain': 'mail.yandex.ua', 'changed': True, 'content-region': 24896}
find:
[('ru', 'Ru')]
list:
[('ru', 'Ru'), ('uk', 'Ua')]
find empty:
[]
list empty:
[]
trySwap:
False

```

