# Слой бизнес-логики

[Бизнес-логика](https://ru.wikipedia.org/wiki/%D0%91%D0%B8%D0%B7%D0%BD%D0%B5%D1%81-%D0%BB%D0%BE%D0%B3%D0%B8%D0%BA%D0%B0) - по простому - это логика, направленная на выполнение задачи (получение данных, выполнение действия), не зависящая от источника данных.

Примеры:
- обработка получаемых данных (фильтрация, сортировка, преобразование, связка с другими данными)
- действия, фолбеки при специфичных данных
- последовательность выполняемых действий
- получение данных для выполнения действия и логика, зависимая от данных

Слой содержит:
- доменные модели
- юзкейсы
- доменные `Exception`
- компараторы, фильтраторы
- другое, что отражает предметную область

{% note alert %}

Слой бизнес логики не должен содержать импортов из других слоёв или `android`

{% endnote %}

## Доменная модель

Отражает сущности, которые являются предметной областью приложения.

В основном это:
- `data class`
- `enum`

Могут содержать в себе только другие доменные сущности или `java/kotlin` типы.

{% note warning %}

Доменная модель - это [POJO](https://ru.wikipedia.org/wiki/POJO)
То есть не должна содержать логику
Логика должна храниться в юзкейсах

{% endnote %}

## UseCase

Класс, который выполняет бизнес функцию.

1. Называется исходя из того, что делает, Например:
- `GetAllOrdersUseCase`
- `CancelOrderByIdUseCase`
- `GetWidgetDataUseCase`

2. Имеет 1 метод, который называется `execute`.

3. Может иметь в зависимостях другие юзкейсы или репозитории

{% note alert %}

UseCase не должен ходить напрямую в источники данных (`DataStore`, `Facade`, `HttpClient` и т.д.).
Только через репозиторий

Не используем аннотацию `@Reusable`

{% endnote %}

## Доменный Exception

Нужен для того, чтобы явно отделять ошибки, которые могут произойти и бизнес-логика о них знает.

Наследуются от `RuntimeException`.

Не должны содержать логики. Нужны только для идентификации ошибки.
