# Основные моменты

В Android-приложении Маркета придерживаемся подхода чистой архитектуры с некоторыми особенностями

Код приложения разделяется на слои:
- `domain` (бизнес-логика)
- `data` (слой получения данных)
- `presentation` (слой представления, UI)
- `di` (настройка DI для приложения)

Подробное описание для каждого слоя в смежных пунктах

## Взаимодействие слоёв

1. Основной слой - это `domain`

{% note warning %}

Он не зависит от других слоёв.
То есть никаких импортов от `data` или `presentation` слоёв не должно быть в `domain` слое.

{% endnote %}

От domain слоя зависят `data` и `presentation`.

2. `data` слой преобразует данные всущности, которые лежат в `domain` слое и знает о них, потому что зависит от `domain` слоя

3. `presentation` слой зависит от `domain` слоя, потому что от него получает данные и выполняет действия

{% note warning %}

`data` и `presentation` слои ничего друг о друге не знают.

{% endnote %}

Примерная схема взаимодейстия слоёв

![alt](https://jing.yandex-team.ru/files/apopsuenko/53104c89d9cf44a59c95e351b7485574.1fc5012.png)

## Наши особенности

Подробнее для каждого слоя особенности описаны в разделе каждого слоя.

Про взаимодействие слоёв особенности такие:

1. Интерфейс репозитория

- По канону у репозитория должен быть интерфейс и он должен лежать в `domain` слое. А имплементации лежат в `data` слое
- Таким образом `domain` слой может получать данные от `data` слоя, но не знать о его имплементации
- В Маркете мы пренебрегли этим правилом. У нас нет интерфейсов для репозиториев и `domain` слой ссылается на конкретную имплементацию

2. `Entities`

- У нас нет явно выделенных `Entities`. Такого понятия у нас нет вообще
- У нас просто есть доменные модели, о которых знают `data` и `presentation` слои

3. `UseCase` vs `Interactor`

- У нас нет понятия `Interactor` в принципе
- Логика пишется в `UseCase`
- Но есть такая сущность, как `UseCases`. Это фасад, который объединяет в себе `UseCase`, необходимые презентеру
- Таким образом связываются презентеры и юзкейсы

## Что почитать
- [Статья дяди Боба](https://blog.cleancoder.com/uncle-bob/2012/08/13/the-clean-architecture.html) [Перевод](https://habr.com/ru/post/269589/)
- [Видео дяди Боба](https://www.youtube.com/watch?v=Nsjsiz2A9mg)
- [Книга от дяди Боба](https://nda.ya.ru/t/_AORsHoH3yLA8e)
- [Проект от Fernando Cejas (один из первопроходцев в клине в Android)](https://github.com/android10/Android-CleanArchitecture)
- [Интересная статья про заблуждения адаптации Clean Architecture в Android](https://habr.com/ru/company/mobileup/blog/335382/)
