# Описание

Целью скрипта `start_task.sh` является упрощение жизни Android разработчика при работе над тикетом. А именно:
1. Убрать ручное переключение между ветками и их созданием, в том числе для минимизации человеческого фактора.
2. Провалидировать тикет на существование дубликатных веток
3. Исключить возможность опечатки в названии ветки

# Алгоритм работы скрипта
![start_task.sh algorithm](https://wiki.yandex-team.ru/users/kuanysh-z/nachalo-raboty-nad-tiketom/.files/starttask.drawio2-1.png)
Для корректного определения типа тикета нужно соблюдать следующие правила:
1) У эпикового тикета не должно быть родительского тикета без [meta] в названии.
2) У эпикового тикета в названии должно присутствовать [epic], если у него есть фичевые подзадачи.

# Инструкция
## Входные параметры
Скрипт `start_task.sh` принимает один обязательный аргумент {номер тикета} и один опциональный аргумент {суффикс ветки}.

Пример:
1. ``./start_task.sh BLUEMARKETAPPS-28522``
Результат: epic/28522 либо feature/28522 в зависимости от типа тикета.
2. ``./start_task.sh BLUEMARKETAPPS-28522 start-task-script``
Результат: epic/28522-start-task-script epic/28522-start-task-script в зависимости от типа тикета.

## Дополнительные опции
Также поддерживаются опции через дефис:
1. ``-e`` или ``-f``
Принудительно задать тип ветки epic или feature соотвественно.
2. ``-x``
Принудительно создать ветку от текущей, без переходов в develop и/или в родительскую ветку.

Пример:
1. ``./start_task.sh BLUEMARKETAPPS-28522 -fx``
Результат: без проверки тикета будет создан feature/28522 от текущей ветки.
2. ``./start_task.sh BLUEMARKETAPPS-28522 -e``
Результат: без проверки тикета будет создан epic/28522 из свежего develop.

Также можно передать --help для вывода информацию по скрипту в консоль.
``./start_task.sh --help``

## Corner Cases
1. В origin уже есть ветка с номером тикета.
В таком случае в интерактивном режиме предлагается выбрать на какой ветке продолжить работу либо создать новую ветку.
2. У эпикового тикета есть родительский тикет без [meta] в названии.
В таком случае в интерактивном режиме предлагается выбрать тип ветки
