# Адаптация нового разработчика

Цель адаптации — погрузить нового разработчика в проект, помочь освоиться в коде, код ревью, релизных процессах и зоопарке технологий Маркета. Успешной адаптацией является полная самостоятельность нового разработчика с контурными задачами.

Адаптацией занимается ментор, если ты читаешь эту статью, то скорее всего ты решил взять на себя такую обязанность. Добро пожаловать в клуб! Ты, как ментор, будешь первой точкой входа по большинству вопросов. Ниже приведены советы, рекомендации и прочее, что поможет адаптировать новичка.

Удачи! 😊

## С чего начать

В первый день выхода нового разработчика, напиши ему в телеграм и дай ссылку на [статью нового разработчика](https://docs.yandex-team.ru/market-mobile/android/for-new-employee) и попроси выполнить все действия указанные в ней. Сообщи, что по всем вопросам может обращаться к тебе.

## Первая встреча

Следущий шаг — добавь в календарь ознакомительную встречу на следущий день

{% note warning %}

Проследи, чтобы новый разработчик принял приглашение в календаре

{% endnote %}

На первой встрече, следует провести небольшую неформальную беседу:
* Представиться и рассказать немного о себе
* Попросить человека сделать тоже самое
* Рассказать про Маркет (что это, чем занимается, цели)
* Спросить какие были трудности при настройке рабочего места

Затем, следует пройтись по [статье для нового разработчика](https://docs.yandex-team.ru/market-mobile/android/for-new-employee) в формате чеклиста, и проверить, что новый сотрудник все сделал:
* Заполнил страничку на стафе
* Раскатил ssh ключ на стаф
* Установил/заказал [необходимое](https://docs.yandex-team.ru/market-mobile/android/for-new-employee#1.-neobhodimoe-po) и [дополнительное](https://docs.yandex-team.ru/market-mobile/android/for-new-employee#2.-dopolnitelnoe-po) ПО
* Скачал репозиторий
* Установил гитхуки
* Настроил и сбилдил проект
* Запросил и получил все доступы в [IDM](https://idm.yandex-team.ru)

В конце помоги собрать проект и проведи небольшой ликбез, расскажи про его контур, что его ждет в дальнейшем и подбери ему какую нибудь небольшую задачу для начала, пускай вливается. Можно взять из поддержки или попросить у руководителя его контура. Контур и руководителя можно посмотреть на стафе. На этом первую встречу можно завершить.

### Чаты и боты

После заполнения информации в стафе, можно добавь новичка во все рабочие чатики:
* `android dev` — чат разработки android маркет
* `Mobille Dream Team` — чат мобильных разработчиков маркета android + ios
* `Мобильная разработка и QA` — общий чат разработчиков мобилок и тестировщиков
* `MarketMobile` — вообще общий чат приложеньки маркета
* `У кулера без NDA` — это просто флудилка, там любые темы кроме работы
* `Автотесты под Android Беру`

{% note warning %}

Не забудь рассказать про эти чаты

{% endnote %}

Познакомь с телеграм ботами. Из основных:
* `@codereview_bot` — уведомления о кодревью
* `@UhuraToolsBot` — яндексовый помощник
* `@YandexHelpDeskbot` — хелп деск

Других можно посмотреть [здесь](https://tg.yandex-team.ru/catalog?tab=bots)

## Запланируй и проведи ряд встреч

После первой встречи, надо запланировать встречи на будущее и обсудить ряд тем описанных ниже. В приоритете те темы, которые помогут справится новичку с его текущими задачами и влиться в контур, а далее по желанию.

### Приложение

Покажи приложение и расскажи про основные разделы:
* Выдача
* [Морда](https://docs.yandex-team.ru/market-mobile/common/glossology#morda)
* Чекаут
* КТ
* Дебажное меню
  * переключение прод/тестинг
  * метрика
  * эксперименты и feature toggle

{% note info %}

Про некоторые вещи, описанные здесь, нету отдельной документации или страницы на вики. Определения для таких вещей можно попробовать поискать в [глоссарии](https://docs.yandex-team.ru/market-mobile/common/glossology)

{% endnote %}

### Архитектура

Покажи код в среде разработки и обсуди следующие моменты:

* Какая архитектура используется (2022: Redux)
* Стайл гайд кода
* Бэкенд:
  * [FAPI](https://docs.yandex-team.ru/market-mobile/common/glossology#f)
  * CAPI
  * MAPI
  * [Rearr флаги](https://docs.yandex-team.ru/market-mobile/common/glossology#rearr-factors-/-rearr-flagi)
* Архитектура микросервисов маркета
  * [репорт](https://docs.yandex-team.ru/market-mobile/common/glossology#report)
  * чекаутер
  * комбинатор
  * индексатор
* offer / sku / model / product — хотя бы на начальном уровне и где искать про это информацию
* [CMS](https://docs.yandex-team.ru/market-mobile/common/glossology#cms)

### Тех процесс

Объясни, как "движется" тикет от создания до релиза:

* Трекер + [тикет](https://docs.yandex-team.ru/market-mobile/common/qa-tracker)
* [Создание нового тикета](https://st.yandex-team.ru/createTicket?queue=BLUEMARKETAPPS)
* [Статусы тикета](https://wiki.yandex-team.ru/users/a-chechetkin/jekran-novichka-mobilnogo-testirovanija/#osobennostimobilnogotestirovanijaprilozhenijjberu)
* [Оформление PR](https://docs.yandex-team.ru/market-mobile/common/code_review/code_review_create)
* [Ревью](https://docs.yandex-team.ru/market-mobile/common/code_review/code_review_motivation) — как проходить, как проводить + Картошка
* [ЦУМ](https://tsum.yandex-team.ru/) + сборка через пайплайн + кубики пайплайна
* Связь тикета с ревью и пайплайном
* Тимсити и что делать, если что то упало
* [Релиз приложения](https://docs.yandex-team.ru/market-mobile/common/release-scenario)

### Тестирование

Расскажи, как работать с Маркетом для тестирования задач:

* Как пишутся [ui тесты](https://wiki.yandex-team.ru/market/mobile/marketapps/android/uitests/), [статья для быстрого старта](https://wiki.yandex-team.ru/users/fzhiyenbayeva/flou-napisanija-ui-avtotestov-v-android/)
* [Unit](https://docs.yandex-team.ru/market-mobile/android/tests/unit-tests) тесты и code coverage. Если есть подходящий тест в контуре — отдай на реализацию.
* Эксперименты и фичатоглы, где их можно переключить, как и когда заводить и когда удалять
* Мониторинги, графана, трассировки, дебаг меню
* Как оформлять заказ в тестинге, подменять эндпоинт, работать с проксименом, заводить тестовый аккаунт, попадать в эксперименты.
* Как сбилдить на свой девайс и где взять девайс для нормального билда. (Кубик, колхоз). Как собирать свою ветку в бету из тимсити?
При необходимости помоги разобраться с charles — [вики](https://wiki.yandex-team.ru/jandekskarty/testing/manual-po-snifferu-charles/) + [настройка](https://wiki.yandex-team.ru/eva/testing/projects/yandex.music/nastrojjka-sniffera-charles/)
* Расскажи про билд варианты, экраны для разработчика, как переключать прод — тестинг.

### Полезные ресурсы

В Яндексе много всего интересного, про что стоит также упомянуть:

* [Трекер](https://st.yandex-team.ru)
* [Вики](https://wiki.yandex-team.ru)
* [Документация](https://docs.yandex-team.ru/market-mobile/)
* [Аркадия](https://a.yandex-team.ru/arc_vcs/)
* [Stackoverflow](https://stackoverflow.yandex-team.ru)
* [Мёбиус](https://moe.yandex-team.ru/courses/my)
* Сервисы
  * [обмен кодом](https://paste.yandex-team.ru)
  * [сохранение картинок](https://jing.yandex-team.ru)
  * [секретница](https://yav.yandex-team.ru)

### Дежурство

У новичка скорее всего еще не скоро будет дежурство, но посмотри по [графику дежурств](https://abc.yandex-team.ru/services/beruapps/duty/), когда оно будет. Проведи встречу перед дежурством на ней расскажи про обязанности дежурного, в какие чатики идти за помощью, за чем следить. Проверь, что есть все необходимые доступы к метрике и дай ссылку на [статью дежурного](https://docs.yandex-team.ru/market-mobile/common/duty-guide).

### Разное

* Оффлайн устройство маркета. 1P, 3P, FBS, FBY, DBS и т.д.
* [Хурал](https://vconf.yandex-team.ru/streams) и прочие встречи

## Трудности

Уточни, есть ли какие-либо трудности. Попроси новичка записать все проблемы с которыми он сталкивается и их решения. Пусть потом поделится с тобой. Если это какая-то новая проблема не отраженная в этой статье — дополни [список](https://a.yandex-team.ru/arc/trunk/arcadia/docs/market/mobile/common/adaptation-guide.md?edit=true#новый-разработчик-как-правило-сталкивается-с-рядом-однотипных-проблем-57) или добавь это в статью для [новичков](https://docs.yandex-team.ru/market-mobile/android/for-new-employee).

## Завершение

После обсуждения всех тем, можно завершить постоянные встречи

## Проблемы, с которыми сталкивается новый разработчик

Дополняй этот раздел при возникновении новых проблем у новичка

### Сборка проекта

Модуль для запуска по умолчанию не выбран, его нужно создать самому: в Android Studio выбрать «Edit configurations» -> добавить новую конфигурацию -> ввести любое имя и выбрать модуль blue-market-android.market.

### Build Variants

Для возможности работы с тестовым окружением необходимо поменять Build Variants blue-market-android.market с baseDebug на qaDebug. Теперь можно изменить бэкэнды на тестовые: Профиль -> Для разработчиков -> Окружение -> проставить где есть test/testing. После любого изменения настроек потребуется перезагрузка приложения, dialog появится автоматически.

### Настройка девайса/эмулятора

Для возможности работы с тестовым окружением через эмулятор (для работы с физическим устройством необходим Charles) необходимо получить роль «Разработчик android приложений» [тут](https://idm.yandex-team.ru/user/fans1n/roles#rf=1,rf-role=1E8Td39K#user:apopsuenko@abc/services/meta_market/market/market_map/beruapps/*/1778(fields:();params:()),rf-expanded=1E8Td39K,f-status=all,sort-by=-updated) (Открыв ссылку, в поле «Роли сервиса Мобильные приложения Беру» следует выбрать «Разработчик android приложений», ниже в поле «Стафф» выбрать свой аккаунт, в поле «Идентификатор ресурса» ввести 1389598). В качестве связующего звена между полученной ролью и доступом к работе с тестовыми окружениями выступает VPN.
