# Архитектурное ревью в мобилках Маркета

## Проблематика

Периодически возникают серьезные проекты, которые требуют больших усилий для внедрения. И несут за собой потенциальную опасность для стабильности работы приложения и планомерного внедрения функционала.

## Цели

1. Обеспечить качество архитектуры и технических решений при реализации проектов
2. Выявления слабых/трудоёмких/опасных мест на ранних этапах
3. Единообразия технических решений
4. Документирование функционала

## Правила

План:
1. Проработка проекта в контуре
2. Проработка реализации в приложении
3. Собрание ревью и защита решения (должно быть минимум 3 ревьювера)
4. Можно на еженедельной встрече сообщить о встрече и подтвердить необходимое количество участников. Или вбросив в чат android/ios-разработчиков

Ревью проводится в случаях:
- разработчик захотел проверить решение
- команда увидела, что проект может быть сложным и попросила провести ревью

{% note warning %}

Не нужно созывать ревью, чтобы все помогли найти решение. Нужно прийти с готовым решением и его защитой.
Ревью может подсказать альтернативное решение. Но не должно быть такого, что участники сядут и будут продумывать, как реализовать проект.
Если у вас не нашлось идей, то позовите коллег, чтобы помогли вам найти решение. Но это не должно происходить на ревью.

{% endnote %}

- При наличии критичных проблем, препятствующих запуску решения - его необходимо переработать, дабы не навредить всему сервису.
- При наличии некритичных проблем, исполнитель обязан занести проблемы как минимум в техдолг, чтобы исправить в дальнейшем.
- У ревью нет цели остановить разработку. Цель - внедрять проработанные и грамотные, не ломающие всё приложение, решения.


## Возможные проблемы

- трата времени на ревью
При проработанном решении встреча отнимет только рассказ этого решения и набросы, которые будут очень полезны
При отсутствии проработанного решения не нужно приступать к разработке

- жёсткие требования от ревьюверов
Цель ревью - не забрить решение, а сделать его лучше и не сломать при его реализации весь сервис.

## Подготовка к ревью

- Для ревью желательно подготовить отдельную вики страницу. Пример описанной архитектуры крупных проектов [раз](https://wiki.yandex-team.ru/market/pokupka/projects/users-2019/kontur-ltv/dev/efim-na-ki/efim-na-km.-arxitektura/), [два](https://wiki.yandex-team.ru/market/pokupka/projects/users-2019/bluevendors/promocodemarket40/dev/), [три](https://wiki.yandex-team.ru/users/yvgrishin/avtokomplekty/)
- В отрисовки диаграмм, алгоритмов и блок-схем поможет вот этот инструмент [drawio](https://drawio.yandex-team.ru/ )
- Ну и главное помнить, что не нужно упарываться делая идеальное описание для проекта

## После ревью

Важно ответить на следующие вопросы
1. Было ли полезно ревью?
2. Изменилось ли итоговое решение после ревью?
3. Все осталось по прежнему, только зря потратил время?

Форма для участников ревью пожалуйста, оставь свою [обратную связь](https://forms.yandex-team.ru/surveys/61420/)
