# Оформление пул реквеста

Для ускорения и повышения качества процесса ревюь нужно придерживаться простых правил:

### Опиши вносимые изменения

Ревьювер не должен тратить время на выяснение всех деталей реализуемой задачи, он должен сосредоточиться на её реализации. Потратив на составление описания задачи 5 минут вы можете значительо повысить скорость прохождения самого ревью, не стоит принебригать этим правилом. 

* Хороший пул реквест должен содержать лаконичное описание решаемой задачи. 
* Должны быть перечисленны все ньюансы технического решения. Если код содержит осознанное нарушение принятой архитектуры - должна быть мотивация, почему сделали именно так, будет ли возвращен техдолг
* Если задача затрагивает дизайн - должны быть прикреплены скриншоты затронутого компонента
* Должна быть указана ссылка на реашемую задачу
* Затронутый код должен относиться только к реашемой задаче, не стоит делать попутные изменения, даже если они не значительны. 

### Подготовь код к ревью

Затраченное время на подготовку кода к ревью компенсируется качеством и скоростью его проведения.
При завершении работы над задачей в первую очередь оцени, соостветвует ли diff следующим критериям

* Не содержит больше 500 строк кода. Если задача требует более объемного решения - возможно стоит разбить её на несколько каскадных пул реквестов. 
* Все не реализованные части кода отложенные на последующие задачи содержать пометки TODO с сылками на эти задачи 
* Написанный код должен соответсвует архитектуре и принятой конвенции. Любое нарушение архитекуры должно иметь мотивацию и обоснование, лучше если оно будет предварительно согласованно с ведущими разработчиками. Значительные нарушения принятой архитектуры не допускаются. Нашрушение принятых конвенций не допускается. 

### Проведи self review

* Хорошая практика - перед публикациий пул реквеста провести self review, это помогает выявить глупые ошибки допущенные на этапе разработки (опечатки, неудачный нейминг, фармотирование файлов, отладочный код).

* Предоставляемый на ревью код должен в первую очередь удовлетворять самого разработчика, он не должен содержать замечаний, которые бы ты оставил на аналогичный код кому-то другому.

* Если в коде есть осознанный техдолг - можно сразу оставить комментарий самому себе с мотивацией, почему пришлось сделать именно так, это поможет избежать обуждений которые обязательно возникнут, но обычно ни к чему не ведут. 

### После отправки кода на реьвю

При возникновении спорных моментов и больших обсуждений - лучше унести всё обсуждение в личку с автором пр, в самом пул реквете кратно описать принятое решение. 

На каждое оставленное замечание необходимо дать ответ, что поправленно, что оставленно без изменений и почему. Для критичных замечаний Resolve conversation может нажимать **только автор замечания**, для некритичного допустимо нажимать автором пул реквеста. 

**После исправлений замечаний - обязательно написать комманду /fixed** 

Не копи открытые пул реквесты за исключением декомпозиции объемной задачи на каскадные пул реквесты. Чем больше открытых разработчиком пул реквестов - тем больше времени тратится на переключение контекста между этими задачамии, всегда закладывайте время на исправления текущей задачи и её завершение. 

{% note warning %}

Завершение пул реквеста - это задача с высоким приоритетом. К обсуждениям замечаний следует приступить незамедлительно, к исправлениям критичных замечаний сразу после текущей задачи. 

{% endnote %}

### Чек лист создания пул реквеста

* Кратко описал решаемую задачу
* Подсветил ньюансы реализации
* Провел селф ревью перед отправкой
* Приложил максимум усилий чтобы минимизировать код
* Указал на оставленный техдолд в описани или коментариях, привёл аргументацию техдолга