# Проведение code review

Проведение код ревью это такая же часть нашей работы, как и написание кода. Не нужно недооценивать значимость этого процесса, плохой код который ты утвердил не глядя или не стал смотреть может настигнуть тебя в любой момент. 

Проводя код ревью, отноститься к рецензии нужно так, как если бы после этого пул реквеста следующую задачу по данному функционалу делал ты. В наших репозиториях нет чужого кода, весь код общий и владеет им вся команда разработки. 

{% note warning %}

SLA на проведение ревью - 1 день

Выдели себе по 15 минут утром и вечером на регулярный просмотр назначенного кода. 

{% endnote %}

Ревью кода - это задача с **высоким приоритетом**. При назначении пул реквестов необходимо приступать к ней сразу после текущей задачи, если текущая задача объемная - то в заранее выделенное время. Это позволит всем разработчиком меньше переключать контекст, не путаться мержу ветками, отражать прозрачный статус задач в трекере

Если ты понимаешь что у тебя совсем нет времени на проведения ревью в течении одного дня - сразу же снять с себя пул реквест

# Как провести ревью

* Конечной целью ревью является улучшение текущей кодовой базы, сам код не должен содержать ктирические ошибки но может быть не идеальным и содержать незначительные ошибки. 
* Все коментарии оставленные к пул реквесту должны иметь пометку что обязательно к исправлению а что нет. Оставь пометку [важно] если коментарий обязателен к исправлению, либо перечисли все критичные моменты в отдельном сообщении при запросе изменений
* Апрув пул реквеста автоматически приравнивается к отсутсвию критичных замечанй и может быть смержен без исправлений (на усмотрения автора), наличие критичных замечаний должно вести к запросу на изменения
* При возникновении спорных моментов и больших обсуждений - лучше унести всё обсуждение в личку с автором пр, в самом пул реквете кратно описать принятое решение. 
* Не стоит оставлять замечания по код стайлу, все нарушения должны отлавливаться автоматикой
* Не нужно требовать изменений, не зафиксированных в принятой архитектуре и конвенции

**Если пул реквест уже содержит запрос на изменение** - не стоит его игнорировать, наоборот нужно как можно скорее дать свою резолюцию кода, чтобы избежать итеративных правок. Если кроме оставленных предыдущим ревьювером замечаний у тебя не возникло новых - можно оставить апрув.

**Если пул реквест уже содержит апрув** - не стоит смотреть его не внимательно. Твоя рецензия не менее важна чем рецензия первого разработчика, по этому мы и просим несколько апрувов. 

**Не оставлять просто коментарии без резолюции, всегда доводи начатое ревью до конца** - это позволит сократить итерации исправлений, в идеальном случае их не должно быть больше двух (отработка замечений обоих ревьюверов) 

# Чек-лист ревьювера

* Код понятен 
* Код не противоречит принятым конвенциям
* Код не противоречит принятой архитектуре
* Код не содержит грубых ошибок, способных привести к крашам приложения
* Оставленные коментарии содержат конкретику, предложение исправлениий
* Коментарии обезличенны, проводя ревью я принимаю участие над реализацией этой задачи