# Дополнительно

## Полезности при локализации
1. [Примеры запросов](https://wiki.yandex-team.ru/users/dmpolyakov/yqlrequests/)
2. Трассировки

   Трассировка - это список запросов, которые делались на бекендах с одной точкой входа в виде приложения(в нашем случае)
В чарлизе найди заголовок с именем X-Market-Request-Id и вставь значение в ссылку https://tsum.yandex-team.ru/trace/{X-Market-Request-Id}
Откроется сайт со списком запросов. Можно посмотреть, какие запросы совершались, какие прошли, какие - нет.

Чтобы понять, запрос был кривой или КАПИ совершили ошибку можно:
1. сделать перезапрос (запросы к репорту поддаются такой манипуляции).

   Заходим через ssh на public.market.yandex.net и дёргаем курлом запрос к репорту. Должен быть тот же ответ, что пришёл и к КАПИ. И смотрим, там проблема или всё норм.

2. грепнуть логи. Скрипт для грепания лежит [здесь](https://arcanum.yandex-team.ru/arc_vcs/mobile/market/tools/logs-grep-script).

   Ему на вход нужны `requestId`, `host` и дата. Эти данные можно найти, щёлкнув в цуме на первый запрос (от мобилки к КАПИ).
По логам скорее всего можно понять, в чём проблема. Если нет, то тогда уже можно обратиться в чатик КАПИ и попросить помощи.
Можно грепнуть и самостоятельно, если скрипт поломался, инструкция будет ниже

3. [Таймлайн](https://tsum.yandex-team.ru/timeline/?from=now%2Fd&to=now) релизов в ЦУМе

## Зачем мы расследуем ошибки на бекендах
1. потому что на КАПИ мало ресурсов и если ребята будут распыляться по ошибкам, то они не будут делать для нас продуктовые задачи

2. потому что у компонентов точки входа - это фронты и мы можем узнавать о проблемах первыми

3. потому что проблемы у наших пользователей. А мы стараемся делать хороший продукт, который будет дарить нашим пользователям радость и хорошее настроение

4. потому что мы все - одна команда и нужно сигнализировать коллегам, если у них есть какие-то проблемы, потому что все мы - люди и можем отвлечься и пропустить какие-то ошибки.

## Грепание логов КАПИ

Новый [формат](https://wiki.yandex-team.ru/market/mobile/marketapps/android/kak-xodit-na-developerskie-servera/#logi) логов

1. Читать логи можно с машинок `logview.market.yandex.net`
``` shell script
ssh logview.market.yandex.net
```
2. Логи находятся в папках `/mnt/nanny/[testing|prestable|production]_market_content_api_[sas|iva|vla]`
3. Для чтения лога по `X-Request-Id` нужно:

   3.1. определить из какой среды первая пришел (шестой символ в нем, если x - `stable`, если p - `prestable`, если t - `testing`, если l - `local`).
   Пример: **h2414t0220b360cefb** - запрос из тестинга

   3.2. посмотреть в access логах на какой машинке выполнялся запрос
   ``` shell script
    ssh public.market.yandex.net
    clickhouse-client -h health-house.market.yandex.net -u ro -d market
    SELECT host, marketReqId FROM marketapi_access WHERE (date = '2018-09-21') AND (requestId = 'h1264p0921f9537b74')
   ```

   3.3. вызвать
   ``` shell script
    grep '<вставьте ваш X-Request-Id>' /mnt/nanny/<testing|prestable|production>_market_content_api_[sas|iva|vla]/<номер_машинки>.search.yandex.net/content-api/market-api.log > out.txt
   ```
   Если узнать номер машинки не удалось, то грепайте по всем машинкам и ДЦ
   `grep '<вставьте ваш X-Request-Id>' /mnt/nanny/<testing|prestable|production>_market_content_api_*/*/market-api.log`

   3.4. если интересующие логи архивированы в gz, то grep заменяем на zgrep

   3.5. забрать логи с удаленной машинки на локальную
   ```scp -r <ваш_логин>@logview<logview_host>.market.yandex.net:out.txt out.txt```

   **Забирать логи нужно с того хоста logview на котором вы сейчас находитесь**. В шаге 1 вы идете через балансер, он может закинуть вас на любую доступную машинку

4. Каких-то папок на `logview` может не быть или будут проблемы с их чтение (напишет в консоль), тогда возможно сервис нужно перемонтировать.
   Для этого нужно вызвать
  `sudo mount-service-log -o remount <testing|prestable|production>_market_content_api_<sas|vla|iva>` (подставьте нужное вам значение).

   **НЕ надо всегда по умолчанию перемонтировать логи** на машине (только если есть проблема с чтением), потому как машинки `logview` общие и если вы сделаете remount, а чтение работает, то можете кому-то разломать grep по логам.

5. Если не работает sudo

   То значит вы не разработчики из https://abc.yandex-team.ru/services/market/, и нужно туда добавиться. (в идеале кто-то один создаст заявку на вашу группу или службу)



