# Что такое Front API

**Front API (далее FAPI)** - это фасадный бекенд, который используют фронтовые приложения маркета. Основной особенностью FAPI является нормализованный ответ (см. [нормальная форма](https://ru.wikipedia.org/wiki/%D0%9D%D0%BE%D1%80%D0%BC%D0%B0%D0%BB%D1%8C%D0%BD%D0%B0%D1%8F_%D1%84%D0%BE%D1%80%D0%BC%D0%B0)). В качестве публичного api предоставляется единственная ручка формата `POST https://<host>/api/<version>/`. Целевое действие и ответ ручки определяется набором резолверов.

Результатом вызова ручки FAPI является нормализованный набор данных (объект `collections` с результатом работы каждого из вызванных резолверов (объект `results`).

## Что такое резолвер
**Резолвер** - это серверный метод. Он может возвращать статические данные, вычислять ответ по входным параметрам или возвращать данные с других бекендов. Так же резолвер может выполнять целевое действие, например: добавлять товар в корзину, подписывать пользователя на email рассылку и тд.

Резолверы перечисляются в query параметре `name` через запятую. Параметр `dictionary` отвечает за формат ответа. Если передать `true`, то ответ будет в формате словаря. Иначе ответ будет в формате массива.

## Документация по актуальным резолверам

Для ветки `master` из репозитория [market/front](https://github.yandex-team.ru/market/marketfront) генерируется [документация по всем резолверам](https://pages.github.yandex-team.ru/market/marketfront/fapi/index.html). Так же под каждым пулл-реквестом в репозитории [market/front](https://github.yandex-team.ru/market/marketfront) генерируется документация, в которой можно найти резолверы, появившиеся в пулл-реквесте.

## Пример запроса

```
https://ipa.market.yandex.ru/api/v1?name=resolveUserFriends&dictionary=true
{
  "params": [
    {
      "userId": "5728341"
    }
  ]
}
```

## Пример ответа (словарь)

```json
{
  "results":[
    {
      "handler": "resolveUserFriends",
      "result": ["6957325", "1263731", "8693452"]
    }
  ],
  "collections": {
    "userProfiles": {
      "1263731": {
        "name": "Fooler",
        "age": 20,
        "phone": "+7 912 327-23-86"
      },
      "6957325": {
        "name": "Barry",
        "age": 24,
        "phone": "+7 920 964-28-54"
      },
      "8693452": {
        "name": "Bazil",
        "age": 21,
        "phone": "+7 900 154-32-78"
      }
    }
  }
}
```
