## 1. О процессе и задачах

* [Workflow статусов тикета](https://wiki.yandex-team.ru/users/a-chechetkin/jekran-novichka-mobilnogo-testirovanija/#osobennostimobilnogotestirovanijaprilozhenijjberu)
* Для создания тикетов необходимо пользоваться стандартной [формой](https://st.yandex-team.ru/createTicket?queue=BLUEMARKETAPPS), куда можно попасть через желтую кнопку `создать задачу` на любой старнице в трекере.
* В части мобильной разработки нас интересует очередь **BLUEMARKETAPPS**
* При создании тикета типа `задача` в форме присутствует поле `Как тестировать` - оно обязательно для заполнения! Чем подробнее будет описание, тем меньше вопросов будет задавать ваш коллега-QA и тем спокойнее будет ваш внутренний интроверт.

{% note warning %}

Часто встречаются задачи, где из описания есть только название, а само поле `описание` пустует. Ввиду не умения многих тестировщиков читать сквозь пространство и время мысли авторов, есть большая необходимость заполнять это поле. Это особенно важно для задач, где необходимо проверить отработки хэндлера/фича-тоггла/реара/экспа и т.п.

{% endnote %}


## 2. О полях в теркере
{% cut "Что происходит с тикетом после того, как ревью пройдено" %}

* Тикет переходит автоматом в статус `Решен`. На этом этапе в ЦУМе начинает собираться пайплайн и генерируется сборка для тестирования. Когда сборка готова, тикет переходит в статус `Можно тестировать`, а в комментариях тикета появляется соответствующее сообщение с сылками на билд и пайплайн.
* Как и везде, тут тоже есть исключения: бывает так, что протестировать задачу надо до того, как ревью будет пройдено. (Чуть подробнее и на языке порграммистов описано [тут](https://docs.yandex-team.ru/market-mobile/android/git-flow-guide#parallel-epic-pipeline) и [тут](https://wiki.yandex-team.ru/market/users/apps/android/developmentflow/#testirovaniejepikov)). В этом случае разработчик может отдельно скинуть билд тестировщику и "махнуть флажком "можно тестировать", либо отдельно запустить руками пайплайн в момент, когда тикет пошел ревьюироваться ревьюерами - то есть до того, как тикет перейдет в статус `Решен`. Однако, в этом случае следует иметь ввиду, так как эта сборка получена до проведения ревью, есть шанс, что она пойдет обратно на доработку. Но будем честны, такой шанс есть всегда :) 

{% endcut %}

{% cut "Что делает разработчик с тикетом после того, как ревью пройдено" %}

В тикетах очереди BLUEMARKETAPPS есть вкладка `Тестирование`. В ней есть несколько важных полей, которые должны заполнять разработчики при передаче тикета в тестирование:
* Важно проставить свой контур в поле **Компонент** или **Тэг** (выбор зависит от того, что какой контур предпочитает использовать, однако, рекомендуется отдать предпочтение [**Тэгу**](https://wiki.yandex-team.ru/users/belirafon/unifikacija-razmetki-tiketov-v-konturax-b2c-marketa/))
* **Test Scope** - это поле отвечает за необходимость и возможность ручного тестирования данного тикета со стороны QA. Если тикет можно проверить руками - ставим `Да`, если нет (например: тикет сугубо технический на то, чтобы вынести определенный функционал в отдельный модуль в приложении) - ставим `Нет`.
* **Регрессия** и **Затронутые компоненты** - эти поля отвечают за оценку затронутого функционала, с точки зрения полноты необходимого регресса этого тикета, когда он попадет в релиз. 
Это очень важный поля, посколько от них зависит будет ли выполнены необходимые и достаточные проверки, а также не будет ли проведена лишняя работа, которая растит Time-To-Market релиза. Заполнять эти поля следует так:   

    * Если весь твой тикет крайне взрывоопасен и ты считаешь, что требуется провести полный регресс — поставь `Регрессия: Полный`.
    * Если твой тикет не очень взрывоопасен, но есть взрывоопасные компоненты, то ставим `Регрессия: Короткая`, а в поле «Затронутые компоненты» указываем взрывоопасные компоненты.
    * Если твой тикет не взрывоопасен, поставь `Регрессия: Короткий`, а в поле `Затронутые компоненты` укажи `Ничего существенного не затронул`

* **Autotesting** - означает покрытие задачи автотестами. Принимает значения:
    * Требуется тест - необходимо написать автотест к задаче или отредактировать имеющийся, если это необходимо.
    * Тест написан - автотест уже есть.
    * Тестирование не требуется - для данной задачи не нужно писать автотесты.

{% endcut %}

{% note tip %}

Разработчику важно обратить внимание на автотесты в пайплайне. Потому как тестировщик все равно придет к вам с этим, если они упали. ¯\_(ツ)_/¯ 

{% endnote %}


{% note tip %}

Если необходимого полюшка не видно, можно и нужно воспользоваться кнпокой `выбрать поля`, расположенной прям под строкой с SLA

{% endnote %}
