# Джобы в релизном пайплайне

##
## Сборка

- Если тупит TeamCity, то просто перезапуск этой джобы
- Если сломалась сборка или тесты, то кидаем ПР с правкой в релиз и после вливания, перезапускаем с **первого шага**

{% note tip %}

Нужно перейти на TeamCity и посмотреть, почему упала сборка, а не просто перезапускать её в надежде, что всё само как-то исправится

{% endnote %}

{% note info %}

Если упала сборка из-за того, что не отправилась apk в GP, то го в [чат](https://t.me/joinchat/BHtYaVJqrZBPmLFwNGQxfg)
Если проблемы с TeamCity, то го в [чат](https://t.me/joinchat/AAAAAECtIetSv3Z_sqhQrQ)

{% endnote %}

## Автотесты

- Если упали все тесты, то чиним как можно быстрее
- Если только некоторые, то чиним + говорим дежурному QA, какие тесты упали, чтобы проверил руками, если их не много
- Если их много, то нужно как можно быстрее понять, в чём причина падения и поправить, чтобы QA не тратили время на проверку функционала, который можно проверить тестами

{% note warning %}

Кидаем ПР с правкой в **релизную** ветку

{% endnote %}

## Проверка метрик

- Зона ответственности дежурного QA.
- Вкратце, нужно проверить, чтобы код, написанный в рамках тикета, который едет, был в релизе
- Если тикет привязался случайно и он точно не едет и его кода нет в релизе, то обратись к [dmpolyakov](https://staff.yandex-team.ru/dmpolyakov)

![alt text](https://jing.yandex-team.ru/files/apopsuenko/Data.08c6857.png)

## Мерж в транк

Если джоба упала, потому что конфликты, то:

#### Android

1. Заводим задачу на мерж
2. Отводим ветку заведенной задачи **от trunk**, черрипикаем в нее коммиты фиксов **из релизной ветки**, правим конфликты, коммитим+пушим решение конфликтов
3. Создаем ПР в аркадии с таргет веткой **trunk**. Ждем завершения ревью и всех тестов (линтер, unit-тесты)
4. Мерджим ПР в trunk
5. Перезапуск джобы "Мерж в trunk" **на релизном пайплайне** не поможет, кубик упадет. Поэтому после мержа новой ветки в trunk, скипаем джобу мержа (лучше согласовать это с дежурным qa / Сашей Миронычевым)

#### iOS

1. Заводим задачу на мерж
2. Отводим ветку заведенной задачи **от релиза**, мержим **в неё trunk**, правим конфликты, коммитим+пушим решение конфликтов
3. Создаем ПР в аркадии с таргет веткой **trunk**. Ждем завершения ревью и всех тестов (линтер, unit-тесты)
4. Мерджим ПР в trunk
5. Перезапускаем джобу "Мерж в trunk" **в релизном пайплайне**

## Проверка крешфри

- Нужно зайти и глянуть в [метрике](https://wiki.yandex-team.ru/Market/mobile/marketapps/Dezhurstva/#metrika), нет ли каких-то крешей, которые появились на новой версии.
- Это могут быть креши не от QA, а от внутренних тестировщиков например.
- Так как собранная версия летит во внутреннее тестирование в Google Play. Так что нужно заходить и смотреть. Ещё можно глянуть в [Firebase](https://wiki.yandex-team.ru/Market/mobile/marketapps/Dezhurstva/#firebase).

## Проверка метрик

- Если катится хотфикс, то норма, что эта джоба падает, так как данных нет.
- Если обычный релиз.
  - Данные в запросе есть, просто мало. Тогда можно катиться и джобу нужно перезапустить через 2-4 часа
  - Данных нет. Все столбцы по 0. Это значит, что отвалились метрики. Нужно чинить. За подробностями к [Лёше Осипову](https://staff.yandex-team.ru/osialx) или [Саше Попсуенко](https://staff.yandex-team.ru/apopsuenko). В данном случае **публиковаться нельзя**

![alt text](https://jing.yandex-team.ru/files/apopsuenko/Data.1cfe885.png)

- Ошибка `uuid not matched` в условиях, когда мало кликов (меньше пары десятков), может быть проигнорирована. На малых объёмах джоба сбоит, поэтому следует пропустить её и перезапустить через день-другой.

![alt text](https://jing.yandex-team.ru/files/4ch7ung/2020-07-07%2014.35.55.jpg)

![alt text](https://jing.yandex-team.ru/files/4ch7ung/2020-07-07%2014.35.59.jpg)

## Получение предыдущей версии

Скорее всего ошибка в данной джобе из-за того, что не найдена версия в стартреке. А версия может быть не найдена, потому что указана версия неправильно при создании пайплайна.
Выход - пересоздать пайплайн или запустить проверки руками.

В [запросе](https://yql.yandex-team.ru//Operations/Xue93Z3udu4FLCpfmY0-Ix35-cECkcm407mV6cDMczM=) переключаемся на параметры и вставляем те, которые нужны.
`startDate` - дата старта регресса.
`endDate` - дата завершения регресса. (для текущего регресса - сегодня)
Для предыдущей версии даты можно посмотреть в пайплайне.


![alt text](https://jing.yandex-team.ru/files/apopsuenko/Data.0be5672.png)

## Проверка на деградацию скорости

- Если не найдено данных, то возможно регресс только начался и ещё не накликали.

- Если данные есть, то нужно посмотреть на запросы

1. [Открываем](https://jing.yandex-team.ru/files/apopsuenko/Data.6b52eb5.png) логи.

2. В логах [ищем](https://jing.yandex-team.ru/files/apopsuenko/Data.7e33771.png) текущую версию
Находим ссылку. Переходим по ней и видим данные + количество хитов.

3. Если мало [хитов](https://jing.yandex-team.ru/files/apopsuenko/Data.5e26c8a.png) - меньше **15**, то можно игнорировать.

4. Если хитов достаточно, то нужно искать, в чём проблема.

    4.1. Для начала проанализируем модели устройств

    [Запрос](https://yql.yandex-team.ru/Operations/YFDF0SyLNWzPh4coF7_K2WA8HopYbf4K6zFcfI4W_h0=) с разбивкой по моделям
    Внимательно смотрим на результаты. Если какая-то модель имеет очень большие цифры, то возможно медиана большая из-за этой модели.

    4.2. В текущем релизе есть очень большая цифра, которая может сдвигать основную медиану.

    Также основное число хитов на _Honor_, но глядя на значения _Honor_ в предыдущем релизе, стало даже лучше.
    На остальные цифры, у которых по 1-2 хитом не стоит так сильно доверяться.

    4.3. Если нашли

    [Пример](https://yql.yandex-team.ru/Operations/YFDH0fMBw2RBchPV7P_toMtdbCZrWKGYwaiaO8y8XPA=) запроса на метрики морды
    [Пример](https://yql.yandex-team.ru/Operations/YFGvxAPTTg2Zbl47qnMir_wH3k6Cf2Et6GDyQgV20S0=) запроса на детальные метрики по каждому событию (requestId берём из поля метрики морды)

    4.4. По этим запросам можно найти сильно большую цифру, посмотреть детальные метрики и примерно понять, в чём проблема, что стало такое долгое.

    Можно сравнить с предыдущей версией.

    Пример:

    [Текущий релиз](https://jing.yandex-team.ru/files/apopsuenko/Data.e8e8f7f.png)

    [Предыдущий релиз](https://jing.yandex-team.ru/files/apopsuenko/Data.f4d808f.png)

{% note tip %}

Запросы в YQL можно запускать параллельно, так что можно сразу стартануть несколько.

{% endnote %}
