# Коды ошибок в UI

В случае показа ошибки в приложении Android к сообщению об ошибке дописывается десятизначный код ошибки. Данный десятизначный код - идентификатор ошибки, по которому её можно найти в метрике здоровья в yql.

## Как это выглядит

Существуют три типа отображаемых ошибок с кодами: [алерты](https://jing.yandex-team.ru/files/pvsukharev/photo_2021-11-01_12-32-24.jpg), [view](https://jing.yandex-team.ru/files/pvsukharev/photo_2021-11-01_12-32-242.jpg) и [экраны](https://jing.yandex-team.ru/files/pvsukharev/photo_2021-11-01_12-32-243.jpg).

## Как получить информацию об ошибке из метрики

Для получения информации, делаем запрос:

[Поиск по errorId](https://yql.yandex-team.ru/Operations/YUGk3K5OD06_9uWCxbeP5mnn3EFMvmvD74XEioS3wDg=)

В данный запрос необходимо подставить в качестве errorId сам код ошибки и указать временной диапазон, когда ошибка произошла. В случае успеха вернётся полная информация об ошибке - стектрейс ошибки, сообщение, а также к какому контуру она относится.

## Если ничего найти не удалось

Если у пользователя была ошибка, но в запросе мы ничего найти не можем, то можно поискать аналогичные ошибки у других пользователей. Для этого из десятизначного кода ошибки берём первые четыре символа и делаем запрос по типу ошибки: 

[Поиск по errorTypeId](https://yql.yandex-team.ru/Operations/YX-y1ZfFt-O5u95vHdA2c-YucQ9Hi6CILyobrRY9les=)

Данный запрос вернёт все ошибки, отправленные в метрику здоровья, и идентичные пользовательской - они имеют такой же стектрейс (то есть, и то же самое место и причину возникновения), сообщение и прочую информацию, то есть эти ошибки абсолютно идентичны той, которая возникла у пользователя. Эту информацию можно смело использовать для расследования проблемы.

## Если всё равно ничего найти не удалось

Либо приложение по какой-то причине не отправило метрику, либо метрика не доехала до БД. Чтобы исключить первый случай, проверьте, что на экране, где возникла ошибка, действительно отправляется метрика здоровья для подобного типа ошибок. Для этого не обязательно воспроизводить саму ошибку, достаточно посмотреть в коде. Если метрика ошибки отправляется, и её всё равно нет в выдаче, возможно, какие-то проблемы с обработкой метрик на серверной стороне.
