# How Membrace moderation works

**Membrace** is a moderation service that labels content using both AI models and human experts.

## How it works {#pipeline}

1. You upload your data via the API.

1. Most of the data is processed automatically, and you get the results right away.

1. In difficult cases, when automated labeling isn't certain about the quality, the data is also checked by human experts. The results of human labeling are sent to you. They are also used for training the AI model.

This data processing cycle lets the model adapt to new content and non-standard queries.

![How it works](../_assets/how-it-work.png "Enter address" =600x)

## What **Membrace** can do{#use-case}

We have solutions for various industries:

**Ecommerce**

  * Image moderation (compliance checks).
  * Data deduplication (for goods and services).
  * Filtering out prohibited goods or services.
  * Moderation and analysis of customer reviews.

**Online communities**

  * Moderation of posts and comments.
  * Profile checks.
  * Filtering out prohibited goods or services.

**Online dating**

  * Profile checks.
  * Moderation of chats and messages.

**Gaming**

  * In-game content checks.
  * Moderation of chats and reviews.
  * Identification of fake profiles.

Check our [website](https://membrace.ai/industries#/tab/436460030-1 to learn more about Membrace and what it can do for your business.).

## Advantages {#advantages}

* **Flexibility.** 35 customizable moderation classes and 30 AI models that we can adapt to your needs.
* **Learning ability.** Our models keep learning and improving thanks to data obtained through manual labeling.
* **Service and support.** At your request, our manager will contact you to discuss the details and find the best solution for your project. Once we have all the information we need, we'll set everything up.
* **High accuracy.** We use reliable quality control methods to check both our human experts and our AI models. This way, we make sure that our labeling results are more than 95% accurate, even in non-standard cases.
* **Scalability.** We can process more than 10 million tasks per day. This means we can deliver results even during spikes caused by spam attacks, high-profile events, flash mobs, and other issues.
* **Real-time moderation.** The estimated response time for AI models is 200 milliseconds.

