# Запуск потоковой обработки

После того, как проект согласован и принято решение о его запуске, можно приступать к интеграции через API:

{% cut "Шаг 1. Зарегистрируйтесь." %}

1. Перейдите по [ссылке](https://passport.yandex.com/auth?origin=toloka_requesters&retpath=https://toloka.yandex.com/signup/requester) и создайте аккаунт:
      	
    {% cut "С помощью логина в Google" %}
    	
      1. В окне регистрации нажмите **Google**.

		   ![Регистрация с помощью логина в Google - Шаг 1](../_assets/login_google1.png "Выберите Google" =127x)

      1. Выберите нужный логин и подтвердите создание аккаунта.

	     ![Регистрация с помощью логина в Google - Шаг 2](../_assets/login_google2.png "Подтвердите создание аккаунта в Толоке" =126x)
		
	  {% endcut %}

	  {% cut "С помощью электронной почты" %}
	
      1. В окне регистрации введите адрес электронной почты и нажмите **Log in**.

         ![Регистрация с помощью адреса электронной почты - Шаг 1](../_assets/login_email1.png "Введите адрес" =124x)

      1. На вашу почту придет код подтверждения. Введите его в открывшемся окне.

         ![Регистрация с помощью адреса электронной почты - Шаг 2](../_assets/login_email2.png "Введите код подтверждения" =126x)
    	
    {% endcut %}

  1. Завершите регистрацию, заполнив информацию о себе.

     ![Завершение регистрации](../_assets/info-about-yourself.png "Заполните информацию о себе" =417x)

{% endcut %}

{% cut "Шаг 2. Пополните баланс." %}

1. Пополните баланс.

   1. Перейдите на вкладку **Profile**.

      ![Профиль](../_assets/profile.png "Перейдите в свой профиль" =630x)

   1. Для быстрого старта воспользуйтесь промокодом:

	   1. Нажмите кнопку **Enter promo code**.

	      ![Пополнить баланс с помощью промокода](../_assets/enter-promo-code.png "Нажмите кнопку для ввода промокода" =307x)

	   1. Введите `TOLOKAKIT1` — после активации ваш баланс будет пополнен.

		   ![Активировать промокод](../_assets/promocode.png "Введите и активируйте промокод" =206x)

   {% note info %}
  
   Для дальнейшего использования вам потребуется привязать ваш аккаунт к биллинговой системе. Инструкцию по привязке аккаунта можно посмотреть по [ссылке](https://toloka.ai/ru/docs/guide/concepts/budget.html).

   {% endnote %}

{% endcut %}

{% cut "Шаг 3. Сообщите нам ваш логин." %} 

   Отправьте вашему консультанту логин, с которым вы зарегистрировались — мы привяжем к нему готовое решение для вашей задачи. Логин вы можете посмотреть в [профиле](https://toloka.yandex.com/requester/profile).

{% endcut %}

{% cut "Шаг 4. Дайте название проекту." %} 

  1. Перейдите по ссылке, которую мы пришлем в ответ на письмо с логином.

  1. Создайте проект:

      1. В блоке **Настройка проекта** введите название приложения, затем нажмите **Go to instructions setup**.

    	    ![Настройка проекта](../_assets/project-name.png "Введите название" =631x)

      1. В блоке **Настройка инструкции** ничего вводить не надо, просто перейдите к следующему блоку — нажмите **Go to Final check**.

            ![Настройка инструкции](../_assets/go-final-check.png "Перейдите к итоговой проверке" =630x)

      1. В блоке **Итоговая проверка** нажмите **Create project**.

        	![Итоговая проверка](../_assets/final-check.png "Создайте проект" =633x)

  1. На экране появятся данные созданного проекта. Скопируйте ID проекта и отправьте его вашему консультанту.

        ![Созданный проект](../_assets/project-id.png "Скопируйте ID проекта" =629x)

  1. Дождитесь активации проекта. Информацию о статусе вы увидите на той же странице, с которой копировали ID.
	
	    ![Статус проекта](../_assets/project-activated.png "Проект активирован" =634x)

{% endcut %}

{% cut "Шаг 5. Подключите API и начните пользоваться." %} 
	
   1. Получите авторизационный токен: на вкладке **Integrations** вашего [профиля](https://toloka.yandex.com/requester/profile/integration) нажмите кнопку **Get OAuth token**.

      ![OAuth-токен](../_assets/get-oauth-token.png "Получите токен" =626x)  

   1. Для обмена через API все готово — отправляйте данные для проекта и получайте результаты их модерации:

      - Используйте потоковую обработку данных (не пакетную). Инструкцию смотрите [в Справке](https://toloka.ai/ru/docs/toloka-apps/api/concepts/streaming-items.html). 

      - Вам понадобится ID проекта, полученный на предыдущем шаге. ID проекта в Справке соответствует переменная `{app_project_id}`.

      {% note info %}
	  
	    Дополнительную информацию по API можно посмотреть на страницах:
	    - [Получить информацию о проекте](https://toloka.ai/ru/docs/toloka-apps/api/ref/app-project/app-projects_app_project_id_get.html)
	    - [Получить информацию об элементе разметки](https://toloka.ai/ru/docs/toloka-apps/api/ref/item/app-projects_app_project_id_items_item_id_get.html)
	    - [Получить список всех элементов в проекте](https://toloka.ai/ru/docs/toloka-apps/api/ref/item/app-projects_app_project_id_items_get.html)

      {% endnote %}

{% endcut %}
