# Как работает сервис модерации Membrace

**Membrace** — это сервис, который сочетает в себе разметку данных с помощью AI-моделей и людей-экспертов. 

## Схема работы {#pipeline}

1. Вы загружаете данные через API.

1. Основная часть данных обрабатывается автоматическими методами и вы сразу же получаете результаты. 

1. Для сложных запросов, когда автоматика не уверена в качестве, данные дополнительно проверяются экспертами — ручная обработка. Результаты ручной разметки направляются вам, а также используются для обучения AI-модели. 

Такой цикл обработки данных позволяет модели адаптироваться к новым вариантам контента и нестандартным запросам.

![Как это работает](../_assets/how-it-work.png "Введите адрес" =600x)


## Что умеет делать **Membrace** {#use-case}

Мы можем решать задачи для разных сфер бизнеса:

**Электронная коммерция**

  * Модерация изображений на соответствие требованиям.
  * Дедупликация товаров и услуг.
  * Фильтрация запрещенных товаров или услуг.
  * Модерация и анализ отзывов клиентов.

**Интернет-сообщества**

  * Модерация сообщений и комментариев.
  * Проверка профилей.
  * Фильтрация запрещенных товаров или услуг.

**Онлайн-знакомства**

  * Проверка профилей.
  * Модерация чатов и сообщений.

**Гейминг**

  * Проверка внутриигрового контента.
  * Модерация чатов и обзоров.
  * Выявление фейковых профилей.

Подробнее о задачах, которые можно решить с помощью Membrace, читайте на нашем [сайте](https://membrace.ai/industries#!/tab/436460030-1).

## Преимущества {#advantages}

* **Гибкость.** 35 настраиваемых классов модерации и 30 AI-моделей, которые мы можем адаптировать под ваши задачи.
* **Обучаемость.** Наши модели продолжают учиться и совершенстоваться на данных, которые поступают после ручной обработки.
* **Сервис и поддержка.** После вашего запроса, наш менеджер свяжется с вами, чтобы обсудить детали проекта и подобрать наилучшее решение для вашей задачи. По результатам обсуждения мы настроим вам проект.
* **Высокая точность.** Мы применяем надежные методы контроля качества и к экспертам, и к AI-моделям, что обеспечивает точность на уровне более 95% даже для нестандартных запросов.
* **Масштабируемость.** Мы можем обрабатывать более 10 миллионов задач в день, что позволит обрабатывать данные даже при всплесках, вызванных спам-атаками, резонанстными событиями, флеш-мобами и т.д.
* **Обработка в режиме реального времени.** Ориентировочное время, за которое AI-модели возвращают ответ, — 200 мс.