# Урок 10. Доступы

{% include [note-alert](../_includes/onboarding-alert.md) %}

## Шаг 1. Рассмотрим уровни доступов {#step-1}

Существует 4 уровня доступов к объектам (воркфлоу, операция, данные):
- **Read** — просмотр содержимого объекта данных и запуск графа с таким блоком данных.
- **Modify** — редактирование черновиков графа и операций, запуск и остановка графа, списывание операции.
- **Execute** — запуск операции в своих графа.
- **Owner** — создатель объекта (операции, данных, воркфлоу, проекта), обладает всеми правами на объект.

Подробнее о [правах доступа](https://docs.yandex-team.ru/nirvana/concepts/roles).

## Шаг 2. Проверим уровень доступа к объектам Нирваны {#step-2}

Уровень доступа к объекту в Нирване определяется **ролью**, которая выдана для пользователя на этот объект. Список ролей можно найти [здесь](https://nirvana.yandex-team.ru/roles).

Текущий уровень доступа для объектов Нирваны:

{% cut "Уровень доступа для операции отображен на странице операции в нижнем левом углу" %}

Например, для операции [Toloka v1 Get Task Suites](https://nirvana.yandex-team.ru/operation/c2ddcd6d-a7e4-4539-b77c-55f651fa1e67)![](https://jing.yandex-team.ru/files/lirriel/2021-05-26T09:19:20Z.1680398.png)

{% endcut %}

{% cut "Уровень доступа для данных отображен на странице объекта данных" %}

![](https://jing.yandex-team.ru/files/lirriel/2021-05-26T09:20:56Z.503ac68.png)

{% endcut %}

Если страница с объектом Нирваны отображается, то у вас есть как минимум доступ на чтение. Если нет никакого доступа до объекта, то при переходе по ссылке на объект отобразится ошибка:

{% cut "нет доступа до объекта данных" %}

![](https://jing.yandex-team.ru/files/lirriel/2021-05-26T09:26:06Z.5665504.png)

{% endcut %}

{% cut "нет доступа до операции на чтение" %}

![](https://jing.yandex-team.ru/files/lirriel/2021-05-26T09:27:50Z.b142854.png)

{% endcut %}

{% cut "нет доступа для выполнения операции" %}

![](https://jing.yandex-team.ru/files/lirriel/2021-05-26T09:33:55Z.80f51bd.png)

{% endcut %}

### Задание к шагу 2

1. Определите уровень доступа к операции [Hitman Process Download Results](https://nirvana.yandex-team.ru/operation/13e8e084-c398-11e6-98ff-0025909427cc).
2. Определите уровень доступа к данным [Test data](https://nirvana.yandex-team.ru/data/407c128f-37e8-46e3-aa9c-b699ca1ed737).

## Шаг 3. Научимся запрашивать доступ {#step-3}

В Нирване нет встроенной системы запроса доступа к объектам. Когда вы сталкиваетесь с ошибкой доступа ("Access denied", "is not allowed to"), необходимо написать владельцу объекта (`Owner`) и запросить у него необходимый вид доступа. Владелец объекта отображен в комментарии об ошибке: "Its owner...". Необходимая для доступа роль указана в комментарии об ошибке: "granted the permission to users having the following roles: ROLES".

Чтобы стать участником (`Participants`) роли:
1. Перейдем на [страницу ролей](https://nirvana.yandex-team.ru/roles).
2. Найдем необходимую роль по названию и нажмем на нее.
3. Выберем `Request ownership or participation`, где мы будем перенаправлены на IDM.
4. Нажмем на блок роли и поставим флаг **Администратор**, если необходимо редактировать роль.
5. Нажмем **Запросить**.

### Задание к шагу 3

1. Запросите доступ к выполнению операции [Wiki grid to JSON](https://nirvana.yandex-team.ru/operation/2eee392d-ae8f-46ee-a440-17c44aa25342/overview).

## Шаг 4. Предоставим персональный доступ {#step-4}

Персональный доступ к объекту Нирваны выдается по названию персональной роли для операции, воркфлоу и данных. Персональная роль определяется логином пользователя `@login` и выдается каждому сотруднику.

{% cut "Доступ к воркфлоу" %}

1. Перейдите на страницу воркфлоу.
2. Нажмите `Workflow Details`.
3. В разделе `Permissions` для типа роли (Read, Motify, Execute) нажмите `+` -> `Add custom role`.
4. введите название роли в текстовое поле и нажмите `Close`.

{% endcut %}

{% cut "Доступ к операции" %}

1. Перейдите на страницу операции.
2. Выберите `Edit`.
3. В разделе `Permissions` для типа роли (Read, Motify, Execute) нажмите `+` -> `Add custom role`.
4. Введите название роли в текстовое поле и нажмите `Apply`.

{% endcut %}

{% cut "Доступ к данным" %}

1. Перейдите на страницу объекта данных
2. В разделе `Permissions` для типа роли (Read, Motify, Execute) нажмите `+` -> `Add custom role`.
3. Введите название роли в текстовое поле и нажмите `Save`.

{% endcut %}

## Задание к шагу 4

1. Создайте новый workflow с использованием операции [Wiki grid to JSON](https://nirvana.yandex-team.ru/operation/2eee392d-ae8f-46ee-a440-17c44aa25342/overview) и сохраните его
2. Предоставьте коллеге по команде права на чтение workflow
3. Сохраните изменения

## Шаг 5. Предоставим доступ группе пользователей {#step-5}

Доступ на группу работает по схеме выдаче персонального доступа. Ключевое отличие — вместо логина вводится название роли. Существующие роли отображены на [странице ролей](https://nirvana.yandex-team.ru/roles).

## Задание к шагу 5

1. Создайте текстовый объект данных.
2. Сохраните объект данных с использованием дефолтной квоты.
3. Предоставьте доступ к данным на чтение для роли `robot-hitman`.

## Шаг 6. Рассмотрим страницу ролей и создадим роль {#step-6}

Список существующих в системе ролей отображен [тут](https://nirvana.yandex-team.ru/roles). На странице роли можно искать по названию (`Name`) и участникам (`Participants`). Участники могут быть представлены как персональными логинами, так и названиями групп. Также роли можно отсортировать по тому, являетесь ли вы их владельцем.

При нажатии на роль в списке отображается описание, название и список участников. Для перехода на страницу роли нужно нажать `Open details`.

{% cut "Создание роли:" %}

1. Перейдем на страницу ролей.
2. Нажимаем **Create role**.
3. Укажем название роли и нажмем **Create**.
4. Выберем группу или набор логинов в поле **Participants**.
5. Применим изменения, нажав галочку.(подробнее [тут](https://docs.yandex-team.ru/nirvana/operations/security/create-role))

{% endcut %}

{% cut "Редактирование роли" %}

1. Редактировать название роли **нельзя**.
2. Редактирование описания осуществляется через страницу роли:
   2.1. Нажмем **Edit**.
   2.2. Обновите описание в поле **Description**.
   2.3. Сохраните изменения, нажав **Save**.
3. Редактирование списка участников3.1. Удаление участника из списка - нажать на иконку корзины на странице роли.3.2. Добавление участников идентично описанию для создания роли

{% endcut %}

{% cut "Удаление роли" %}

1. Перейдем на страницу роли.
2. Нажмем **Delete**.
3. Подтвердите удаление роли.
(подробнее [тут](https://docs.yandex-team.ru/nirvana/operations/security/delete-role))

{% endcut %}

## Задание к шагу 6

1. Создайте роль {login}-nirvana-onboarding-role.
2. Предоставьте роль на вашу группу на стаффе.
3. Сделайте группу админом роли.
4. Добавьте описание для роли.
5. Сохраните изменения.
6. Удалите роль.
