# Урок 17. Отладка упавшего графа

{% include [note-alert](../_includes/onboarding-alert.md) %}

Руководство по отладке упавших операций можно найти [здесь](https://wiki.yandex-team.ru/nirvana/manual/troubleshooting/).

![https://lead-assessors.s3.yandex.net/857bfde7-b69d-462a-a6e1-83a1eb0eb1ed](https://lead-assessors.s3.yandex.net/857bfde7-b69d-462a-a6e1-83a1eb0eb1ed)

## Перезапуск

Один и тот же инстанс нельзя запустить дважды — только клонировать исходный граф. В получившуюся копию можно внести любые изменения: удалить или добавить блоки, скорректировать опции и связи. Если первоначальный граф завершился с ошибкой (упал), перед запуском ее нужно найти и исправить. Иногда ошибка вызвана неполадками в связанных сервисах (например, их временной недоступностью) — тогда копию графа можно запустить в неизменном виде.

Будь внимателен с детерминированными операциями: если входные данные остались прежними, а в опции не вносились коррективы, то детерминированная операция отдаст те же результаты, что и в прошлый раз, вне зависимости от изменений в других блоках. Чтобы запретить такой операции брать результат из кеша Нирваны и заставить ее обработать входные данные заново, необходимо что-то изменить. В некоторых детерминированных кубиках есть опция `timestamp` или `ts` (обычно с пометкой вроде **for Nirvana cache only**), которая используется преимущественно для этой цели. Поскольку она только хранит в себе заданное значение времени, ее изменение никак не повлияет на работу операции. Когда ты запишешь в нее другое число, с точки зрения Нирваны операция станет другой и данные из кеша взяты не будут. Аналогичным образом действует изменение `Code` (локального ID) детерминированного кубика хотя бы на один символ. Чтобы найти его, нажми на нужный кубик и перейди на вкладку `Details` панели `Selection Details`.

![(https://lead-assessors.s3.yandex.net/1f5a2bec-fa14-4dfa-8186-12f9ff787ab2)](https://lead-assessors.s3.yandex.net/1f5a2bec-fa14-4dfa-8186-12f9ff787ab2)

![https://lead-assessors.s3.yandex.net/53775fbb-00ec-45ab-b89f-478930211a96](https://lead-assessors.s3.yandex.net/53775fbb-00ec-45ab-b89f-478930211a96)

Иногда полный перезапуск невозможен. К примеру, если в процессе выполнения инстанса предполагалось создание пула в ЯНГе или начисление оплаты пользователям, то запуск копии приведет к тому, что пул создаётся повторно, а оплата начисляется в двойном размере. В таких случаях важна политика клонирования результатов в настройках инстанса. Чтобы определить ее, кликни по пустому пространству и перейди во вкладку `Config` панели `Selection Details`. Найди там опцию **Results Cloning Policy** и выберите нужный вариант:
- `Do not clone results` — результаты будут взяты из кеша только для детерминированных операций.
  - Это вариант по умолчанию. При клонировании инстанса все операции графа будут выполняться заново, за исключением детерминированных.
- `Clone top-level block results` — результаты успешно завершенных блоков будут клонированы из предыдущего запуска полностью. Результаты частично завершенных блоков проигнорируются.
  - С такой политикой будут выполняться те блоки, которые не успели выполниться, и композитные операции. Частично завершенные выполнятся заново.
- `Clone results recursively` — результаты успешно завершенных блоков будут клонированы полностью. Вложенные результаты частично завершенных блоков композитных операций также будут клонированы рекурсивно.
  - Граф запустится с момента падения, все полученные результаты будут переиспользованы. Обычно для безопасного перезапуска выбирают именно эту политику. Иначе эта функция называется «дораныватель», поскольку она позволяет «доранать» граф с момента возникновения ошибки, а не с самого начала.

  ![https://lead-assessors.s3.yandex.net/4a619498-317e-4d74-abef-3a4eccb813c0 =500x](https://lead-assessors.s3.yandex.net/4a619498-317e-4d74-abef-3a4eccb813c0)

  Поскольку при перезапуске с выбранной политикой выполняются не все операции, на доран уходит значительно меньше времени, чем на запуск полного клона графа. Эту особенность можно использовать и для инстансов, которые завершились успешно. Создайте клон инстанса и измените `Code` у тех операций, которые необходимо выполнить заново. В настройке с политикой клонирования результатов выберите `Clone results recursively`.

  Когда  вы запустите граф, то выполняться в нем будут только кубики с измененным `Code` — результаты работы всех остальных будут взяты из предыдущего запуска.Больше про дораныватель и его историю можно прочитать [здесь](https://clubs.at.yandex-team.ru/nirvana/2706) и [здесь](https://clubs.at.yandex-team.ru/nirvana/697).

  ![https://lead-assessors.s3.yandex.net/48326c85-676f-449f-a160-6080ce90211b =500x](https://lead-assessors.s3.yandex.net/48326c85-676f-449f-a160-6080ce90211b)

  Чтобы найти причину падения графа, необходимо просмотреть отчеты упавших операций. В некоторых случаях короткое сообщение об ошибке рядом с названиями вкладок даст вам всю необходимую информацию о ее причинах. Для более вдумчивого анализа откройте и изучите файл **error.log**: выделите нужный кубик и перейдите во вкладку `Logs` панели `Selection Details`.Руководство по отладке упавших операций можно найти [здесь](https://wiki.yandex-team.ru/nirvana/manual/troubleshooting/).

  ![https://lead-assessors.s3.yandex.net/857bfde7-b69d-462a-a6e1-83a1eb0eb1ed =500x](https://lead-assessors.s3.yandex.net/857bfde7-b69d-462a-a6e1-83a1eb0eb1ed)
