# Урок 19. Как найти нужную операцию?

{% include [note-alert](../_includes/onboarding-alert.md) %}

## Вступление

Одно из самых полезных качеств Нирваны, делающей её такой прекрасной - наличие [библиотеки готовых операций](https://nirvana.yandex-team.ru/browse?selected=879274). Это позволяет делать production-ready решения на базе Нирваны в короткие сроки.

Задачу, которую вы решаете, вероятно, уже много раз решали до вас (поспрашивайте, вдруг даже сохранился граф 😉) и в большинстве случаев её можно декомпозировать так, что для решения достаточно будет в правильном порядке соединить несколько кубиков-операций. Одна из сложностей, с которыми вы столкнётесь - а как же найти подходящие операции?

*Прим. автора: здесь и далее "библиотека" используется в контексте "все операции Нирваны", а "Библиотека" (с большой буквы) - как синоним секции [/Library](https://nirvana.yandex-team.ru/browse?selected=879274).*

## Как искать операции?

### Библиотека

Библиотека представлена каталогом [/Library](https://nirvana.yandex-team.ru/browse?selected=879274) и предназначена для хранения только проверенных и рекомендованных операций. Ссылку на Библиотеку можно найти на навигационной панели слева, сразу под домашним каталогом.

{% cut "Скриншот" %}

![https://jing.yandex-team.ru/files/shmakov-ao/2021-09-12_11-40-45.png](https://jing.yandex-team.ru/files/shmakov-ao/2021-09-12_11-40-45.png)

{% endcut %}

Библиотека содержит три основных подкаталога:
- `ml` — Операции, связанные с проектами machine learning.
- `services` — Операции для работ с различными сервисами (Толока, ClickHouse, Hitman).
- `util` — Операции для работ с различными данными (геобаза, изображения, JSON, Python).
Все операции сгруппированы по сервисам или типам данных с которыми они работают. Если вы не до конца понимаете, что вам нужно - рекомендуется заглянуть в Библиотеку, отсортированный список наиболее стабильных и популярных операций поможет определиться.

И в целом, рекомендую 10 минут побродить по директориям Библиотеки, поглядеть что вообще есть, пригодится в будущем.
### Урок 1. Найти операцию, которая забирает данные из таблицы на Вики

1. Идём в [Библиотеку](https://nirvana.yandex-team.ru/browse?selected=879274).
2. Вики - сервис. Пробуем найти в папке "[services](https://nirvana.yandex-team.ru/browse?selected=889784)".
3. Ого! Такая папка нашлась! Вот это нам повезло, да? - [Wiki](https://nirvana.yandex-team.ru/browse?selected=1068646).
4. Смотрим описание операций в папке ([Wiki Get Grid Raw Data](https://nirvana.yandex-team.ru/browse?selected=1088662)): `The operation gets 'raw' (unformatted) Wiki grid's data for a given path` `(e.g. page[/subpage][/subpage]`. Выглядит ровно как то, что нам нужно.
5. Далее можно посмотреть примеры использования операций или документацию к ней, чтобы понять как пользоваться, какие данные отдаются в итоге и как их обрабатывать.

## Свободный поиск

К свободному поиску можно перейти с боковой панели [Operations](https://nirvana.yandex-team.ru/operations/filter/1).

*Прим. автора: В моей практике - это наиболее часто используемый и удобный вариант поиска.*

Поддерживается поиск по:
- названию
- автору операции
- тегам
- фильтрам:
  - по жизненному циклу операции (draft, ready)
  - по текущему статусу (active, optionally deprecated, mandatory deprecated)
  - по наличию звёздочки официальности и так далее
Замечания:
- Частота использования операции и количество пользователей могут служить хорошим ориентиром для поиска качественной операции.
- Переформулировки хорошо работают, если не нашли подходящее сразу - попробуйте несколько раз переформулировать или отбросить склоняемую часть запроса.
### Урок 2. Ищем операцию для перемешивания Json

Нам нужна какая-то проверенная операция, которая перемешает наши Json'ы и при в случае перезапуска на том же наборе данных и опций будет возвращать один и тот же результат (deterministic).

Сформируем критерии для поиска:
- Детерминированность.
- Актуальность - операция не должна быть deprecated.
- Проверенность - операция должна быть официальной, с большим числом пользователей.

1. Открываем вкладку ["Operations"](https://nirvana.yandex-team.ru/operations/filter/1).
2. Пишем в поисковой строке "json shuffle".
3. Add Filter - Deterministic - True
4. Add Filter - Deprecation Status - Active
5. Add Filter - Official - True
Готово! Мы её нашли.

{% cut "Скриншот" %}

![https://jing.yandex-team.ru/files/shmakov-ao/2021-09-12_12-47-48.png](https://jing.yandex-team.ru/files/shmakov-ao/2021-09-12_12-47-48.png)

{% endcut %}

## Спросить коллегу

- Коллеги могут знать что-то чего не знаете вы, используйте это.
- Можно связываться с авторами похожей операции.
- Можно поспрашивать у ответственных за отдельные каталоги. Посмотреть ответственного за каталог можно кликнув по кнопке с вашим уровнем доступа в правом верхнем углу.

  {% cut "Скриншот" %}

  ![https://jing.yandex-team.ru/files/shmakov-ao/2021-09-12_11-30-58.png](https://jing.yandex-team.ru/files/shmakov-ao/2021-09-12_11-30-58.png)

  {% endcut %}

## Обратиться к сообществу Нирваны

Внутри Яндекса у Нирваны достаточно большое сообщество.Если не удалось найти операцию самостоятельно, то можно попросить помощи коллег по следующим каналам (упорядочены по убыванию приоритета - выше те, в которые стоит обращаться в первую очередь).
- [Nirvana Community](https://nda.ya.ru/t/sTBqRYdb4Dt2ga) (Telegram) - коммьюнити чат, в чате также присутствуют менеджеры и разработчики Нирваны, поддержка через чат не гарантируется.
- [Очередь NVSUP в Трекере](https://st.yandex-team.ru/createTicket?queue=NVSUP&_form=73402) - отвечает разработка или менеджеры Нирваны.
- [nirvana-lib@yandex-team.ru](mailto:nirvana-lib@yandex-team.ru) - подключена к очереди NVSUP, создаёт в ней тикеты. То же самое, что обратиться сразу в очередь.
- [Клуб Нирвана в Этушке](https://clubs.at.yandex-team.ru/nirvana/) - {red}(**сомневаюсь, что Этушку нужно так использовать**).

## Доработка операций под ваши нужды

Если вы нашли подходящую операцию (не важно из Библиотеки или нет), но в ней чего-то не хватает, чтобы решить конкретно вашу задачу, есть какие-то баги или операцию можно улучшить (ускорить, уменьшить затраты памяти и т.д.) - попросите автора доработать операцию. Для операций из Библиотеки можно это делать прямо в тикете операции [NIRVANALIB](https://st.yandex-team.ru/NIRVANALIB).

## Когда стоит создавать свою операцию

В случае, если поиски подходящей операции не увенчались успехом.Пожалуйста, не делайте форки существующих операций, это порождает множество одинаковых операций с похожими названиями, одинаковыми функциями и неясными различиями. Вместо этого лучше попросить автора исходной операции доработать её.

Если вам достаточно работать с API сервиса и подходящего кубика для этого не нашлось - можно заказать кубик на основе [Wget v1 base](https://wiki.yandex-team.ru/hitman/nirvana/wget/) (через тикет в очереди [HITMANSUP](https://st.yandex-team.ru/createTicket?queue=HITMANSUP)).

## Пополнение Библиотеки и каталогизация операций

В Библиотеке собраны и каталогизированы операции, которые будут полезны большому количеству пользователей Нирваны.
- У каждой папки есть описание и список ответственных. Если вы хотите добавить свою операцию в определённую папку Библиотеки - не стесняйтесь призывать в тикет ответственных за неё. Именно ответственный за папку принимает решение о добавлении операции.
- Если вы понимаете, что в корне Библиотеки не хватает нового каталога, то призывайте в тикет рассылку.

## Требования к операциям в Библиотеке

1. Операция должна иметь понятные для рядового пользователя название и описание.
   - Если у вас есть хорошая инструкция по использованию операции, то её следует положить в [специальный раздел на Wiki](https://wiki.yandex-team.ru/nirvana/library/.create).
2. Операция должна иметь набор тегов, к которым она относится. Теги помогают находить операции в библиотеке.
   - Сейчас у нас есть следующий [набор официальных тегов](https://wiki.yandex-team.ru/users/bob1708/workhard/onetimeprojects/Instrukcija-po-tegirovaniju-operacijj/nirvanatags/) ({red}(**уточнить актуальность**)).

- У Библиотечных операций есть ссылка на тикет, в нём можно и нужно обсуждать операцию и её улучшения. Тикет можно найти нажав кнопку "Proposed" на странице операции или поиском по очереди [NIRVANALIB](https://st.yandex-team.ru/NIRVANALIB).

  {% cut "Скриншот" %}

  ![https://jing.yandex-team.ru/files/shmakov-ao/2021-09-12_11-52-01.png](https://jing.yandex-team.ru/files/shmakov-ao/2021-09-12_11-52-01.png)

  {% endcut %}

- Если знаете операцию, которая пока не в Библиотеке, но которую стоит туда добавить - нажимайте кнопку "Propose" ("Propose for library") на странице операции.

  {% cut "Скриншот" %}

  ![https://jing.yandex-team.ru/files/shmakov-ao/2021-09-12_11-52-34.png](https://jing.yandex-team.ru/files/shmakov-ao/2021-09-12_11-52-34.png)

  {% endcut %}

- Дополняйте операции понятным описанием, ссылками на документацию, это очень помогает понимать что операция делает без траты времени на самостоятельные запуски и разбор.
- Если вы нашли Библиотечную операцию, но вам не хватает функциональности, сперва напишите в тикет операции, обсудите с автором её доработку.
- Дайте знать, если встретите операцию, которая не соответствует папке каталога, куда мы её положили, или совсем неподходящую для Библиотеки.
- Также замечания можно присылать на рассылку [nirvana-lib@yandex-team.ru](mailto:nirvana-lib@yandex-team.ru).

## Хочу больше узнать про операции

Добро пожаловать в [официальную документацию](https://docs.yandex-team.ru/nirvana/concepts/operations)
