# Урок 23. Квоты

{% include [note-alert](../_includes/onboarding-alert.md) %}

## Зачем нужны квоты

Нирвана обладает ограниченным количеством ресурсов (вычислительной мощности, хранилища). Для распределения этого ресурса существуют квоты. Чтобы создать блок данных или запустить граф в Нирване (далее будем называть их инстансами), необходимо выбрать квоту.
## Какие бывают квоты

В Нирване выделяются следующие основные виды квот:
- **объём хранилища** - куда запишутся произведённые инстансом данные
- **вычислительные ресурсы** - CPU и GPU (RAM выделяется пропорционально CPU)
- **количество созданных инстансов, запущенных инстансов и блоков операций**
Помимо перечисленных существуют также специфичные квоты на количество операций YT в Нирване, Scraper (прокачка веба), скриншотилку и другие сервисы. На них мы подробно останавливаться не будем.

{% cut "Скриншот общих ресурсов Нирваны доступных всему Яндексу" %}

![https://jing.yandex-team.ru/files/shmakov-ao/2021-07-29_10-27-08.png](https://jing.yandex-team.ru/files/shmakov-ao/2021-07-29_10-27-08.png)

{% endcut %}

Это устарешие сведения: [работа с квотами перенесена в Нирвану](https://clubs.at.yandex-team.ru/nirvana/6127)

## Урок 1. Смотрим на состояние квоты в Диспенсере

1. Найдите в Dispenser квоту "No guarantee (default)" и оцените текущее состояние этой квоты.
1. Посмотрите состояние других проектных квот.
{red}(Какой вывод должен из этого сделать человек? Default - страдание, проектные квоты - хорошо?)
## Как завести квоту

Квотирование обеспечивает сервис [Dispenser](https://dispenser.yandex-team.ru/).Чтобы в Dispenser появилась ваша проектная квота, оформите [заявку на добавление новой квоты](https://wiki.yandex-team.ru/intranet/abc/dispenser/docs/hierarchy/).Квоты не подлежат удалению, но их можно переносить в архив Dispenser.Добавление новых пользователей и изменение объёмов квоты также происходит через Dispenser.
## Как запросить доступ к существующей квоте

Дать право на использование квоты могут ответственные за квоту. Нужно написать кому-нибудь из списка ответственных или на рассылку, привязанную к квоте.
## Как запустить инстанс в нужной квоте

Выбор квоты производится в интерфейсе запуска инстанса. Инстанс при этом должен быть в состоянии Draft, иначе выбор квоты будет заблокирован. На правой панели перейдите на вкладку **Config** и в пункте **Quota** выберите подходящую.

{% cut "Скриншот" %}

![https://jing.yandex-team.ru/files/shmakov-ao/2021-07-26_18-25-50.png](https://jing.yandex-team.ru/files/shmakov-ao/2021-07-26_18-25-50.png)

{% endcut %}

## Урок 2. Какие квоты доступны

1. Клонируйте [граф](https://nirvana.yandex-team.ru/flow/167b2499-8a0f-4fb6-b69a-4cd16e574a5f/c0af1afb-c931-40ba-9409-d984897186fc/graph) или откройте любой доступный инстанс в состоянии Draft.
1. Перейдите на вкладку "Config".
1. Нажмите на выпадашку "Quota" и посмотрите какие квоты вам доступны.
   {red}(Там точно будет Default и может не быть никакой другой. Может какую-то мини-квоту для обучения завести?)

### Какие квоты и для чего нужно использовать

- **No gurantee** ([default](https://dispenser.yandex-team.ru/nirvana/projects/default)) - только для тестирования и разовых запусков, которым не критично время выполнения.
- **Non-Yandex pet-projects & research** ([external-activities](https://dispenser.yandex-team.ru/nirvana/projects/external-activities)) - для pet-projects, экспериментов и исследований, не относящихся к вашей основной рабочей деятельности.
- **Проектные квоты** (любые другие в [этом дереве](https://dispenser.yandex-team.ru/nirvana/projects)) - единственный вид квоты, который подходит для регулярного запуска процессов (aka продакшен).

### Как следить за состоянием квоты

#### Графики

Состояние квоты можно отслеживать по показателям в [Dispenser](https://dispenser.yandex-team.ru/nirvana/projects).

{% cut "Скриншот" %}

![https://jing.yandex-team.ru/files/shmakov-ao/2021-07-29_10-40-40.png](https://jing.yandex-team.ru/files/shmakov-ao/2021-07-29_10-40-40.png)

{% endcut %}

Справа от каждого показателя (выделено красной рамкой) есть значок, по клику на которой открываются графики в Solomon, показывающие потребление квоты во времени. По ним удобно отлавливать пики и планировать запуски своих процессов на менее загруженные периоды, если квота переполняется.

## Урок 3. Проверяем, почему возникают задержки при запусках в квоте

1. Откройте состояние квоты "[No guarantie (default](https://dispenser.yandex-team.ru/nirvana/projects/default))".
1. Перейдите на график "Создано графов / 10 мин" (справа). Откроется график в Solomon.
1. Выберите скейл Day в правой части.
На графике видно, что в первые минуты каждого часа создаётся очень много графов и регулярно пробивается квота на количество созданных графов за 10 минут. Это значит что графы, которые стартуют в это время, просто встают в очередь и подвисают, пока эти 10 минут не истекут. Если перенести запуск минут на 20 вперёд от начала часа, то с большей вероятностью граф сразу стартанёт и быстрее завершится, без ожидания.

{% cut "Скриншот" %}

![https://jing.yandex-team.ru/files/shmakov-ao/2021-07-29_10-46-51.png](https://jing.yandex-team.ru/files/shmakov-ao/2021-07-29_10-46-51.png)

{% endcut %}

Традиционно, самые загруженные периоды:
- Начало каждого часа.
- Каждый третий час суток (0, 3, 6, 9, 12, 15, 18, 21)
- Начало дня (7, 8, 9 утра)

### Правильная настройка графов

Если квоту не очищать, то при регулярных запусках она рано или поздно переполнится. Чтобы ваша квота долго не переполнялась, необходимо настроить автоматическую очистку квоты, заполнив следующие параметры на той же вкладке **Config**.
- **Result Time To Live (days)** - время хранения данных, произведенных инстансом.
  - Минимальное значение, которое можно указать – 0 (при этом данные записываются, хранятся несколько часов, а затем удаляются).
  - Значение по умолчанию - 14 дней.
  - Если вы не укажете число в этом поле, данные в хранилище MDS останутся навсегда.
  - Когда данные инстанса удалятся - не получится просмотреть информацию на входах-выходах кубиков в этом графе, но сам граф, его связи и код в кубиках будут видны.
- **Results Cleaning Threshold (bytes)** — пороговый размер данных для очистки (в байтах): данные меньшего размера не будут удалены автоматической очисткой или действием Reject results. Позволяет при очистке квоты сохранять мелкие файлы, которые могут пригодиться в будущем (конфиги, мета-информацию).
  - Значение по умолчанию - 0 (удаляются любые данные).
  - Рекомендуемое значение - 0.
- **Instance TTL** - срок жизни инстанса в днях. Этот параметр не влияет непосредственно на квоту, но важен для уменьшения нагрузки на базу данных Нирваны.
  - Для процессов, запускаемых 1 раз в сутки, мы рекомендуем установить значение Instance TTL равным 30 дней. Это хороший компромисс между возможностью заглянуть в запуски прошлого месяца и умеренной нагрузкой на базу данных Нирваны. Если ваш процесс запускается реже - можно выбрать большее значение Instance TTL. Если процесс запускается чаще - лучше выбрать меньшее значение Instance TTL.
  - Не стоит оставлять Instance TTL пустым — Нирвана не подходит для резервного хранения информации о большом количестве запусков в далёком прошлом. Для такой цели лучше выбрать специализированный инструмент (к примеру, таблицы в YT).
  - Когда инстанс удаляется - не получится посмотреть граф и его данные.

## Урок 4. Настраиваем TTL

1. В графе из урока 2 настройте TTL по рекомендациям.
   - Result TTL: 14
   - Instance TTL: 30
   - Results Cleaning Threshold: 0
1. Запустите граф.

### Ручная очистка хранилища

Если доступный объём в хранилище подходит к концу - нужно удалить неактуальные данные, чтобы освободить место.Переходим на вкладку "[Instances](https://nirvana.yandex-team.ru/instances/)" в Нирване.
1. Настраиваем через кнопку "Add Filter":
   - **Lifecycle Status**: launched (графы, которые уже запущены и отбежали)
   - **Quota Project**: квота, которую планируете очищать
   - Остальные параметры по вкусу
1. Получившийся список упорядочиваем по убыванию **Storage**.
1. Выбираем инстансы, данные которых хотим удалить и нажимаем **Reject Results** в нижней части экрана.

   {% cut "Скриншот" %}

   ![https://jing.yandex-team.ru/files/shmakov-ao/2021-07-29_11-16-12.png](https://jing.yandex-team.ru/files/shmakov-ao/2021-07-29_11-16-12.png)

   {% endcut %}

## Урок 5. Ручная очистка хранилища (из графа)

1. Откройте запущенный в предыдущем уроке инстанс.
1. Посмотрите в верхней части страницы объём хранилища, который этот инстанс "занимает" (4.4 MB).

   {% cut "Скриншот" %}

   ![https://jing.yandex-team.ru/files/shmakov-ao/2021-07-30_10-16-43.png](https://jing.yandex-team.ru/files/shmakov-ao/2021-07-30_10-16-43.png)

   {% endcut %}

1. Эти данные нам не нужны, давайте очистим хранилище от них прямо сейчас, чтобы не ждать.
1. Нажмите на 3 точки в правой части экрана, выберите Reject Results. Прочитайте сообщение.

   {% cut "Скриншот" %}

   ![https://jing.yandex-team.ru/files/shmakov-ao/2021-07-30_10-21-16.png](https://jing.yandex-team.ru/files/shmakov-ao/2021-07-30_10-21-16.png)

   {% endcut %}

1. Нажимайте Reject Results.
1. Готово, вы великолепны и теперь знаете практически всё, что необходимо для работы с квотой в Нирване!

## Рекомендации

- Обязательно настройте **Result Time To Live**, **Instance Time To Live** и **Results Cleaning Threshold** на всех графах.
- Если запускаетесь по cron - разносите запуски по времени в течение дня. Запускайтесь не в начале каждого часа, а со смещением на несколько минут или только когда вы знаете, что поступили данные и их нужно обработать.
- Оптимизируйте процессы, чтобы не запускались лишний раз и не работали вхолостую на пустых данных, используйте кубики, которые позволяют пропускать выполнение последующих блоков, если на входе пустота (Json if, Json Filter if и прочие), а также пользуйтесь связями по исполнению в тикетах.
- Не тяните в граф гигабайты данных, во многих случаях в этом нет необходимости. Не нужно затаскивать тяжёлые таблицы в граф, если аналогичные вычисления можно провести через запрос в YQL.

## Если перечисленное выше не помогло

Можно заказать расширение квоты по [инструкции](https://docs.yandex-team.ru/nirvana/concepts/quotas.md#quota-make-wide).

## Хочу больше узнать про квотирование в Нирване

Добро пожаловать [официальную документацию](https://docs.yandex-team.ru/nirvana/concepts/quotas).
