# Урок 14. Подграфы

{% include [note-alert](../_includes/onboarding-alert.md) %}

## Шаг 1. Изучим концепцию подграфов {#step-1}

1. **Что такое подграф**

    Это обычный граф в Нирване, который имеет входы и/или выходы, и который можно использовать в других графах.

2. **В чем отличие подграфа и композитной операции**

    - Подграф предназначен, в первую очередь, для удобного структурирования основного графа
    - У подграфа нет явного версионирования — внести изменения в драфт подграфа может любой сотрудник с доступом к редактированию
    - Из-за отсутствия версионирования подграф не предназначен для массового переиспользования другими коллегами, т.к. любые изменения могут сломать ключевые процессы без возможности простого отката версии

3. **Основной сценарий использования**

    Подграфы являются удобным инструментом для модульного подхода в разработке графов. С помощью подграфов можно объединять большие куски графов, которые отвечают за какой-то общий функционал, в отдельные кубики. Это значительно упростит восприятие основного графа для других сотрудников, а также поможет сфокусировано подходить к разработке — вместо постоянного изменения в основном графе ты можешь вносить изменения в отдельные небольшие подграфы, которые проще тестировать.

## Шаг 2. Создадим граф для использования в виде подграфа {#step-2}

Мы сделаем подграф, который будет выполнять ту же функцию, что и композитная операция, которую мы создавали в уроке [Создание композитных операций](composite-operations.md).
1. Создадим новый граф, назовем его так, чтобы в дальнейшем можно было найти его по имени.
2. Добавим в граф две связанные операции: Light Json Shuffle и Light Json Limit

    ![https://jing.yandex-team.ru/files/mikelius/browser_2021-07-30_16-51-59.png](https://jing.yandex-team.ru/files/mikelius/browser_2021-07-30_16-51-59.png)

3. Создадим глобальную опцию limit и свяжем её с опцией операции.

    ![https://jing.yandex-team.ru/files/mikelius/browser_2021-07-30_19-33-37.png](https://jing.yandex-team.ru/files/mikelius/browser_2021-07-30_19-33-37.png)

4. Создадим вход и выход для нашего графа.

    ![https://jing.yandex-team.ru/files/mikelius/browser_2021-07-30_19-34-42.png](https://jing.yandex-team.ru/files/mikelius/browser_2021-07-30_19-34-42.png)

5. Сохраним граф.
> При необходимости можно настроить дополнительные опции графа: — доступы, квоту, приоритет и т.д.

## Шаг 3. Запустим граф с созданным подграфом {#step-3}

1. Создадим новый граф, добавим на него [этот датасет](https://nirvana.yandex-team.ru/data/c33a8221-5f7a-40f6-9d7c-9bcf59a1c984).
2. Откроем блок слева **Add new block** и перейдем на вкладку **Workflows**. Найдем созданный на шаге 2 граф по имени и добавим его в основной граф.

    ![https://jing.yandex-team.ru/files/mikelius/browser_2021-07-30_19-38-37.png](https://jing.yandex-team.ru/files/mikelius/browser_2021-07-30_19-38-37.png)

3. Укажем значение опции подграфа limit = 10 и попробуем позапускать основной граф несколько раз.

# Шаг 4. Изучим типовой пример использования подграфа {#step-4}

Типовой пример использования подграфов

    ![https://nirvana.yandex-team.ru/flow/57048cd9-a96c-452d-8ab9-6137be068969/440e87e5-bcb9-444d-a99f-b660d6e27221/graph](https://nirvana.yandex-team.ru/flow/57048cd9-a96c-452d-8ab9-6137be068969/440e87e5-bcb9-444d-a99f-b660d6e27221/graph)

1. Отправляем на сервис данные.

    ![https://jing.yandex-team.ru/files/mikelius/browser_2021-07-30_19-45-54.png](https://jing.yandex-team.ru/files/mikelius/browser_2021-07-30_19-45-54.png)

2. Ждем их обработки.

3. Получаем результаты обработки данных.

    ![https://jing.yandex-team.ru/files/mikelius/browser_2021-07-30_19-46-27.png](https://jing.yandex-team.ru/files/mikelius/browser_2021-07-30_19-46-27.png)

4. В зависимости от конкретного результата для каждого объекта запускаем разные сценарии дальнейшей обработки этих данных.

    ![https://jing.yandex-team.ru/files/mikelius/browser_2021-07-30_19-47-51.png](https://jing.yandex-team.ru/files/mikelius/browser_2021-07-30_19-47-51.png)

Отлично, ты изучил основные особенности работы с композитными операциями и подграфами! Переходи к следующему уроку.
