//[passport](../../../index.md)/[com.yandex.passport.api](../index.md)/[KPassportApi](index.md)

# KPassportApi

[passport]\
interface [KPassportApi](index.md)

Experimental replacement for [PassportApi](../-passport-api/index.md) as api accessor of android passport library. It is designed to be Kotlin-compatible. All blocking WorkerThread methods are replaced by suspend ones.

Not designed to use from java: use [Passport](../-passport/index.md) for oldtimer java clients.

## Functions

| Name | Summary |
|---|---|
| [acceptAuthInTrack](accept-auth-in-track.md) | [passport]<br>abstract suspend fun [acceptAuthInTrack](accept-auth-in-track.md)(uid: [PassportUid](../-passport-uid/index.md), url: Uri): Result&lt;Boolean&gt;<br>Подтвердить или отклонить авторизацию в треке<br></br> |
| [acceptDeviceAuthorization](accept-device-authorization.md) | [passport]<br>abstract suspend fun [acceptDeviceAuthorization](accept-device-authorization.md)(uid: [PassportUid](../-passport-uid/index.md), userCode: String): Result&lt;Unit&gt;<br>Подтверждает авторизацию на устройстве |
| [addAccount](add-account.md) | [passport]<br>abstract suspend fun [addAccount](add-account.md)(passportEnvironment: [KPassportEnvironment](../-k-passport-environment/index.md), masterToken: String): Result&lt;[PassportAccount](../-passport-account/index.md)?&gt;<br>Добавить почтовый аккаунт внешних почт (&quot;mailish&quot;)<br></br> Этим методом можно добавить только такой тип аккаунтов<br></br> |
| [authorizeByCode](authorize-by-code.md) | [passport]<br>abstract suspend fun [authorizeByCode](authorize-by-code.md)(code: [PassportCode](../-passport-code/index.md)): Result&lt;[PassportAccount](../-passport-account/index.md)&gt;<br>Возвращает аккаунт [PassportAccount](../-passport-account/index.md) по коду [PassportCode](../-passport-code/index.md).<br></br> Добавляет в базу аккаунтов или обновляет (по uid) существующий аккаунт и его &quot;мастер&quot; токен.<br></br> |
| [authorizeByCookie](authorize-by-cookie.md) | [passport]<br>abstract suspend fun [authorizeByCookie](authorize-by-cookie.md)(cookie: [PassportCookie](../-passport-cookie/index.md)): Result&lt;[PassportAccount](../-passport-account/index.md)&gt;<br>Возвращает аккаунт [PassportAccount](../-passport-account/index.md) по cookie [PassportCookie](../-passport-cookie/index.md), полученной из результата работы WebView или из каких-либо внешних источников.<br></br> Добавляет в базу аккаунтов или обновляет (по uid) существующий аккаунт и его &quot;мастер&quot; токен.<br></br> |
| [authorizeByDeviceCode](authorize-by-device-code.md) | [passport]<br>abstract suspend fun [authorizeByDeviceCode](authorize-by-device-code.md)(passportEnvironment: [KPassportEnvironment](../-k-passport-environment/index.md), deviceCode: String): Result&lt;[PassportAccount](../-passport-account/index.md)&gt;<br>Заканчивает авторизацию на устройстве. |
| [autologin](autologin.md) | [passport]<br>abstract suspend fun [autologin](autologin.md)(activity: ComponentActivity, useSmartlock: Boolean, properties: [PassportAutoLoginProperties](../-passport-auto-login-properties/index.md)): Result&lt;[PassportAccount](../-passport-account/index.md)&gt;<br>abstract suspend fun [autologin](autologin.md)(activity: ComponentActivity, useSmartlock: Boolean, properties: [PassportAutoLoginProperties.Builder](../-passport-auto-login-properties/-builder/index.md).() -&gt; Unit): Result&lt;[PassportAccount](../-passport-account/index.md)&gt;<br>Производит поиск подходящего для приложения аккаунта в системном хранилище. |
| [dropToken](drop-token.md) | [passport]<br>abstract suspend fun [dropToken](drop-token.md)(token: String): Result&lt;Unit&gt;<br>Удалить токен по его значению.<br></br> Токен будет удалён из внутренней таблицы. Если токен уже удалён, никаких действий производиться не будет.<br></br><br></br> В случае, если сервер ответил, что токен больше не валиден, нужно его удалить, вызвав этот метод до запроса нового токена [getToken](get-token.md)<br></br> |
| [getAccount](get-account.md) | [passport]<br>abstract suspend fun [getAccount](get-account.md)(uid: [PassportUid](../-passport-uid/index.md)): Result&lt;[PassportAccount](../-passport-account/index.md)&gt;<br>Возвращает аккаунт [PassportAccount](../-passport-account/index.md) по уникальному идентификатору [PassportUid](../-passport-uid/index.md)<br></br> |
| [getAccountManagementUrl](get-account-management-url.md) | [passport]<br>abstract suspend fun [getAccountManagementUrl](get-account-management-url.md)(uid: [PassportUid](../-passport-uid/index.md)): Result&lt;Uri&gt;<br>Возвращает url страницы на которой пользователь может просмотреть или изменить свои данные в аккаунте. |
| [getAccounts](get-accounts.md) | [passport]<br>abstract suspend fun [getAccounts](get-accounts.md)(filter: [PassportFilter](../-passport-filter/index.md)): Result&lt;List&lt;[PassportAccount](../-passport-account/index.md)&gt;&gt;<br>abstract suspend fun [getAccounts](get-accounts.md)(filter: [PassportFilter.Builder](../-passport-filter/-builder/index.md).() -&gt; Unit): Result&lt;List&lt;[PassportAccount](../-passport-account/index.md)&gt;&gt;<br>Возвращает список аккаунтов, соответствующих фильтру [PassportFilter](../-passport-filter/index.md).<br></br> &quot;Тимовские&quot; аккаунты [Passport.PASSPORT_ENVIRONMENT_TEAM_PRODUCTION](../-passport/-p-a-s-s-p-o-r-t_-e-n-v-i-r-o-n-m-e-n-t_-t-e-a-m_-p-r-o-d-u-c-t-i-o-n.md) и [Passport.PASSPORT_ENVIRONMENT_TEAM_TESTING](../-passport/-p-a-s-s-p-o-r-t_-e-n-v-i-r-o-n-m-e-n-t_-t-e-a-m_-t-e-s-t-i-n-g.md) не различаются между собой при добавлении в список.<br></br> |
| [getAuthorizationUrl](get-authorization-url.md) | [passport]<br>abstract suspend fun [getAuthorizationUrl](get-authorization-url.md)(properties: [PassportAuthorizationUrlProperties.Builder](../-passport-authorization-url-properties/-builder/index.md).() -&gt; Unit): Result&lt;String&gt;<br>Возвращает URL для авторизации внутри WebView, то есть меняет авторизацию в приложении на авторизацию по куке.<br></br><br></br><u>yandexuidCookieValue</u> значение куки [yandexuid](https://wiki.yandex-team.ru/cookies/yandexuid/)<br></br> Используется для защиты от CSRF атак. Кука проставляется на любом сервере Яндекса в соответствующем TLD до вызова авторизации.<br></br> Возможно, в данный момент времени эта защита не включена, но может быть включена позднее.<br></br> В этом случае, без равенства yandexuid в урле и куке пользователя дополнительно попросят подтвердить вход.<br></br><br></br> Q. Можно ли этот метод использовать для авторизации на любой странице Яндекса?<br></br> A. Можно, главное, чтобы значение параметра <u>tld</u> и TLD внутри <u>returnUrl</u> совпадали.<br></br><br></br> Q. Что будет, если передать URL на произвольную страницу?<br></br> A. Бэкенд проверяет <u>returnUrl</u> и может отказаться генерировать ссылку.<br></br><br></br> |
| [getCode](get-code.md) | [passport]<br>abstract suspend fun [getCode](get-code.md)(uid: [PassportUid](../-passport-uid/index.md), credentialProvider: [PassportCredentialProvider](../-passport-credential-provider/index.md)): Result&lt;[PassportCode](../-passport-code/index.md)&gt;<br>Returns the code (&quot;confirmation code&quot;) by a unique identifier [PassportUid](../-passport-uid/index.md). |
| [getCurrentAccount](get-current-account.md) | [passport]<br>abstract suspend fun [getCurrentAccount](get-current-account.md)(): Result&lt;[PassportAccount](../-passport-account/index.md)?&gt;<br>Возвращает системный аккаунт, который был ранее сохранен через вызов [setCurrentAccount](set-current-account.md). Информация о сохраненном аккаунте записывается в SharedPreferences того приложения, которое осуществляет вызов вышеуказанной функции. |
| [getDeviceCode](get-device-code.md) | [passport]<br>abstract suspend fun [getDeviceCode](get-device-code.md)(passportEnvironment: [KPassportEnvironment](../-k-passport-environment/index.md), deviceName: String?, clientBound: Boolean): Result&lt;[PassportDeviceCode](../-passport-device-code/index.md)&gt;<br>Начинает процесс авторизации другого устройства. |
| [getLinkageCandidate](get-linkage-candidate.md) | [passport]<br>abstract suspend fun [getLinkageCandidate](get-linkage-candidate.md)(uid: [PassportUid](../-passport-uid/index.md)): Result&lt;[PassportAccount](../-passport-account/index.md)?&gt;<br>Возвращает аккаунт, подходящий для связывания с указанным аккаунтом. |
| [getPersonProfile](get-person-profile.md) | [passport]<br>abstract suspend fun [getPersonProfile](get-person-profile.md)(uid: [PassportUid](../-passport-uid/index.md), needDisplayNameVariants: Boolean): Result&lt;[PassportPersonProfile](../-passport-person-profile/index.md)&gt;<br>Получение пользовательских данных для дальнейшего их редактирования |
| [getToken](get-token.md) | [passport]<br>abstract suspend fun [getToken](get-token.md)(uid: [PassportUid](../-passport-uid/index.md)): Result&lt;[PassportToken](../-passport-token/index.md)&gt;<br>Возвращает авторизационный токен по уникальному идентификатору [PassportUid](../-passport-uid/index.md).<br></br><br></br> Этот токен имеет набор прав (scope), соответствующие OAuth приложению – паре client id / client secret из [PassportCredentials](../-passport-credentials/index.md), указанному при инициализации библиотеки в методе [Passport.initializePassport](../../../../passport/passport/com.yandex.passport.api/-passport/initialize-passport.md) для соответствующего окружения [PassportEnvironment](../-passport-environment/index.md).<br></br><br></br> Для описания этого токена можно также встретить название &quot;клиентский токен&quot;, в противоположность &quot;мастер токену&quot;, права которого позволяют получать другие токены, но не содержат &quot;клиентские&quot;. Такие токены используются внутри библиотеки.<br></br><br></br> В случае, если сервер ответил, что данный токен больше не валиден, нужно его удалить, вызвав метод [dropToken](drop-token.md), до запроса нового токена.<br></br><br>[passport]<br>abstract suspend fun [getToken](get-token.md)(uid: [PassportUid](../-passport-uid/index.md), credentials: [PassportCredentials](../-passport-credentials/index.md)): Result&lt;[PassportToken](../-passport-token/index.md)&gt;<br>abstract suspend fun [getToken](get-token.md)(uid: [PassportUid](../-passport-uid/index.md), arguments: [PassportPaymentAuthArguments](../-passport-payment-auth-arguments/index.md)): Result&lt;[PassportToken](../-passport-token/index.md)&gt;<br>Возвращает авторизационный токен по уникальному идентификатору [PassportUid](../-passport-uid/index.md).<br></br>. |
| [getTurboAppAnonymizedUserInfo](get-turbo-app-anonymized-user-info.md) | [passport]<br>abstract suspend fun [getTurboAppAnonymizedUserInfo](get-turbo-app-anonymized-user-info.md)(properties: [PassportTurboAppAuthProperties](../-passport-turbo-app-auth-properties/index.md)): Result&lt;[PassportTurboAppJwtToken](../-passport-turbo-app-jwt-token/index.md)&gt;<br>Отдаёт обезличенную информацию о пользователе, включая publisher-specific user id (PSUID). Выдаёт JWT-токен, подписанный секретом приложения. |
| [getTurboAppUserInfo](get-turbo-app-user-info.md) | [passport]<br>abstract suspend fun [getTurboAppUserInfo](get-turbo-app-user-info.md)(passportEnvironment: [KPassportEnvironment](../-k-passport-environment/index.md), oauthToken: String): Result&lt;[PassportTurboAppJwtToken](../-passport-turbo-app-jwt-token/index.md)&gt;<br>Отдаёт информацию о пользователе, включая publisher-specific user id (PSUID). Выдаёт JWT-токен, подписанный секретом приложения. |
| [login](login.md) | [passport]<br>abstract suspend fun [login](login.md)(activity: ComponentActivity, loginProperties: [PassportLoginProperties](../-passport-login-properties/index.md)): Result&lt;[PassportLoginResult](../-passport-login-result/index.md)&gt;<br>abstract suspend fun [login](login.md)(activity: ComponentActivity, loginProperties: [PassportLoginProperties.Builder](../-passport-login-properties/-builder/index.md).() -&gt; Unit): Result&lt;[PassportLoginResult](../-passport-login-result/index.md)&gt;<br>Performs login procedure in async/suspend manner. You don't need to startActivityForResult or onActivityResult-handling anymore. |
| [logout](logout.md) | [passport]<br>abstract suspend fun [logout](logout.md)(uid: [PassportUid](../-passport-uid/index.md)): Result&lt;Unit&gt;<br>Метод требуется вызывать в случае, если пользователь нажал &quot;Выйти&quot; в приложении |
| [onInstanceIdTokenRefresh](on-instance-id-token-refresh.md) | [passport]<br>abstract suspend fun [onInstanceIdTokenRefresh](on-instance-id-token-refresh.md)(): Result&lt;Unit&gt;<br>Метод требуется вызывать при срабатывании слушателя InstanceIDListenerService.onTokenRefresh |
| [onPushMessageReceived](on-push-message-received.md) | [passport]<br>abstract suspend fun [onPushMessageReceived](on-push-message-received.md)(from: String, data: Bundle): Result&lt;Boolean&gt;<br>Метод требуется вызывать при получении любого push сообщения. Если push сообщение будет предназначено для AM, то метод вернет true. В приложении такое сообщение не должно обрабатываться. |
| [performLinkageForce](perform-linkage-force.md) | [passport]<br>abstract suspend fun [performLinkageForce](perform-linkage-force.md)(firstUid: [PassportUid](../-passport-uid/index.md), secondUid: [PassportUid](../-passport-uid/index.md)): Result&lt;Unit&gt;<br>Выполняет связку аккаунтов без выполнения проверок на стороне АМ. |
| [performSync](perform-sync.md) | [passport]<br>abstract suspend fun [performSync](perform-sync.md)(uid: [PassportUid](../-passport-uid/index.md)): Result&lt;Unit&gt;<br>Принудительно обновляет данные об аккаунте. |
| [removeAccount](remove-account.md) | [passport]<br>~~abstract~~ ~~suspend~~ ~~fun~~ [~~removeAccount~~](remove-account.md)~~(~~uid: [PassportUid](../-passport-uid/index.md)~~)~~~~:~~ Result&lt;Unit&gt;<br>&quot;Настоящее&quot; удаление аккаунта и связанных с ним данных из системной базы. |
| [sendAuthToTrack](send-auth-to-track.md) | [passport]<br>abstract suspend fun [sendAuthToTrack](send-auth-to-track.md)(uid: [PassportUid](../-passport-uid/index.md), trackId: String): Result&lt;Unit&gt;<br>Авторизовать пользователя по коду <tt>trackId</tt> в аккаунт [PassportUid](../-passport-uid/index.md).<br></br> Пользователь должен иметь валидную авторизацию (&quot;мастер токен&quot;).<br></br> Текущий сценарий использования предполагает получение <tt>trackId</tt> с помощью сканера QR кодов на странице [https://passport.yandex.ru/auth?mode=qr](https://passport.yandex.ru/auth?mode=qr) и передачу авторизации пользователя из приложения на эту страницу.<br></br> |
| [setCurrentAccount](set-current-account.md) | [passport]<br>abstract suspend fun [setCurrentAccount](set-current-account.md)(uid: [PassportUid](../-passport-uid/index.md)): Result&lt;Unit&gt;<br>Сохраняет UID и имя аккаунта с переданным [PassportUid](../-passport-uid/index.md) в SharedPreferences вызывающего приложения. Впоследствии его можно извлечь использованием функции [getCurrentAccount](get-current-account.md). Стоит заметить, что при невозможности обнаружить аккаунт с переданным Uid будет выброшено исключение. |
| [stashValue](stash-value.md) | [passport]<br>abstract suspend fun [stashValue](stash-value.md)(uid: [PassportUid](../-passport-uid/index.md), cell: [KPassportStashCell](../-k-passport-stash-cell/index.md), value: String?): Result&lt;Unit&gt;<br>Добавляет или обновляет сохранённое значение <tt>value</tt> по ключу [cell](../-passport-stash-cell/index.md) для аккаунта [uid](../-passport-uid/index.md).<br></br> Для добавления новых ключей в список [PassportStashCell](../-passport-stash-cell/index.md) свяжитесь с командой разработки этой библиотеки.<br></br><br>[passport]<br>abstract suspend fun [stashValue](stash-value.md)(passportUids: List&lt;[PassportUid](../-passport-uid/index.md)&gt;, cell: [KPassportStashCell](../-k-passport-stash-cell/index.md), value: String?): Result&lt;Unit&gt;<br>Функция аналогична .stashValue, но позволяет выполнить операцию сразу для нескольких аккаунтов |
| [updateAvatar](update-avatar.md) | [passport]<br>abstract suspend fun [updateAvatar](update-avatar.md)(uid: [PassportUid](../-passport-uid/index.md), uri: Uri): Result&lt;Unit&gt;<br>Обновление аватара для аккаунта. Операция может происходить длительное время.<br></br><br></br> Приложение самостоятельно заботится о нужных правах для соответствующих <tt>Uri</tt>,<br></br> например, <tt>android.permission.READ_EXTERNAL_STORAGE</tt>, иначе будет брошено исключение [PassportIOException](../../com.yandex.passport.api.exception/-passport-i-o-exception/index.md)<br></br> Такое же исключение может быть брошено и для некорректного <tt>Uri</tt>.<br></br> |
| [updatePersonProfile](update-person-profile.md) | [passport]<br>abstract suspend fun [updatePersonProfile](update-person-profile.md)(uid: [PassportUid](../-passport-uid/index.md), personProfile: [PassportPersonProfile.Builder](../-passport-person-profile/-builder/index.md).() -&gt; Unit): Result&lt;Unit&gt;<br>Обновление пользовательских данных |

## Properties

| Name | Summary |
|---|---|
| [accountUpgrader](account-upgrader.md) | [passport]<br>abstract val [accountUpgrader](account-upgrader.md): [PassportAccountUpgrader](../-passport-account-upgrader/index.md)<br>Used for account upgrade functionality. |
| [intentFactory](intent-factory.md) | [passport]<br>abstract val [intentFactory](intent-factory.md): [KPassportIntentFactory](../-k-passport-intent-factory/index.md)<br>Factory used for intent creation. |
| [internalApi](internal-api.md) | [passport]<br>abstract val [internalApi](internal-api.md): KPassportInternalApi<br>Limiter use only. Contact passport team if you need this. |
