//[passport](../../../index.md)/[com.yandex.passport.api](../index.md)/[KPassportIntentFactory](index.md)

# KPassportIntentFactory

[passport]\
interface [KPassportIntentFactory](index.md)

Experimental interface, responsible for passport-based intent creation.

## Functions

| Name | Summary |
|---|---|
| [createAccountNotAuthorizedIntent](create-account-not-authorized-intent.md) | [passport]<br>abstract fun [createAccountNotAuthorizedIntent](create-account-not-authorized-intent.md)(context: Context, properties: [PassportAccountNotAuthorizedProperties](../-passport-account-not-authorized-properties/index.md)): Intent?<br>Создает Intent для показа плашки с информацией о необходимости повторного ввода пароля для аккаунта |
| [createAuthByQrConfirmIntent](create-auth-by-qr-confirm-intent.md) | [passport]<br>abstract fun [createAuthByQrConfirmIntent](create-auth-by-qr-confirm-intent.md)(uri: Uri): Intent<br>Возвращает <tt>Intent</tt> для запуска <tt>Activity</tt> для подтверждения входа по QR коду. |
| [createAuthorizationByQrIntent](create-authorization-by-qr-intent.md) | [passport]<br>abstract fun [createAuthorizationByQrIntent](create-authorization-by-qr-intent.md)(context: Context, properties: [PassportAuthByQrProperties](../-passport-auth-by-qr-properties/index.md)): Intent<br>Возвращает <tt>Intent</tt> для запуска <tt>Activity</tt> с авторизацией по QR коду на Android TV<br></br> |
| [createAuthorizeByTrackIdIntent](create-authorize-by-track-id-intent.md) | [passport]<br>abstract fun [createAuthorizeByTrackIdIntent](create-authorize-by-track-id-intent.md)(context: Context, loginProperties: [PassportLoginProperties](../-passport-login-properties/index.md), trackId: [PassportTrackId](../-passport-track-id/index.md)): Intent<br>Экран запускает авторизацию по trackId. Показывает экран подтверждения входа |
| [createAutoLoginIntent](create-auto-login-intent.md) | [passport]<br>abstract fun [createAutoLoginIntent](create-auto-login-intent.md)(context: Context, uid: [PassportUid](../-passport-uid/index.md), autoLoginProperties: [PassportAutoLoginProperties](../-passport-auto-login-properties/index.md)): Intent<br>Создает Intent для отображения информации об автологине |
| [createBindPhoneIntent](create-bind-phone-intent.md) | [passport]<br>abstract fun [createBindPhoneIntent](create-bind-phone-intent.md)(context: Context, properties: [PassportBindPhoneProperties](../-passport-bind-phone-properties/index.md)): Intent?<br>Создаёт интент с экраном привязки номера телефона. |
| [createLoginIntent](create-login-intent.md) | [passport]<br>abstract fun [createLoginIntent](create-login-intent.md)(context: Context, loginProperties: [PassportLoginProperties](../-passport-login-properties/index.md)): Intent<br>Создание Intent-а, использование которого в startActivityForResult() откроет окно выбора аккаунта или же регистрации нового аккаунта. |
| [createSendAuthToTrackIntent](create-send-auth-to-track-intent.md) | [passport]<br>abstract fun [createSendAuthToTrackIntent](create-send-auth-to-track-intent.md)(context: Context, uri: String, passportUid: [PassportUid](../-passport-uid/index.md)?, useSecureDialogStyle: Boolean): Intent<br>Экран добавляет авторизацию в трэк который передан в uri Текущий сценарий использования предполагает получение <tt>trackId</tt> с помощью сканера QR кодов на странице [https://passport.yandex.ru/auth?mode=qr](https://passport.yandex.ru/auth?mode=qr) и передачу авторизации пользователя из приложения на эту страницу.<br></br> |
| [createSocialApplicationBindIntent](create-social-application-bind-intent.md) | [passport]<br>abstract fun [createSocialApplicationBindIntent](create-social-application-bind-intent.md)(context: Context, properties: [PassportSocialApplicationBindProperties](../-passport-social-application-bind-properties/index.md)): Intent |
| [createSocialBindIntent](create-social-bind-intent.md) | [passport]<br>abstract fun [createSocialBindIntent](create-social-bind-intent.md)(context: Context, properties: [PassportSocialBindProperties](../-passport-social-bind-properties/index.md)): Intent<br>Создать интент для связки аккаунта с [PassportUid](../-passport-uid/index.md) uid с социальной сетью из списка [PassportSocialConfiguration](../-passport-social-configuration/index.md) для [PassportSocialConfiguration.isFullSocial](../-passport-social-configuration/is-full-social.md)<tt>== true</tt>. |
| [createTurboAppAuthIntent](create-turbo-app-auth-intent.md) | [passport]<br>abstract fun [createTurboAppAuthIntent](create-turbo-app-auth-intent.md)(context: Context, properties: [PassportTurboAppAuthProperties](../-passport-turbo-app-auth-properties/index.md)): Intent<br>Возвращает <tt>Intent</tt> для запуска <tt>Activity</tt> для подтверждения скоупов для турбоаппа. <br></br> Результат приходит в onActivityResult. Для обработки результата используйте [Passport.processTurboAppAuth](../../../passport/com.yandex.passport.api/-passport/process-turbo-app-auth.md) |
