//[passport](../../../index.md)/[com.yandex.passport.api](../index.md)/[PassportApi](index.md)

# PassportApi

[passport]\
interface [PassportApi](index.md)

## Types

| Name | Summary |
|---|---|
| [Factory](-factory/index.md) | [passport]<br>open class [Factory](-factory/index.md)<br>См. |

## Functions

| Name | Summary |
|---|---|
| [acceptAuthInTrack](accept-auth-in-track.md) | [passport]<br>@WorkerThread<br>abstract fun [acceptAuthInTrack](accept-auth-in-track.md)(@NonNulluid: [PassportUid](../-passport-uid/index.md), @NonNullurl: Uri): Boolean<br>Подтвердить или отклонить авторизацию в треке |
| [acceptDeviceAuthorization](accept-device-authorization.md) | [passport]<br>@WorkerThread<br>abstract fun [acceptDeviceAuthorization](accept-device-authorization.md)(@NonNulluid: [PassportUid](../-passport-uid/index.md), @NonNulluserCode: String)<br>Подтверждает авторизацию на устройстве После получения userCode из метода getDeviceCode необходимо его передать в этот метод. |
| [addAccount](add-account.md) | [passport]<br>@WorkerThread<br>abstract fun [addAccount](add-account.md)(@NonNullpassportEnvironment: [PassportEnvironment](../-passport-environment/index.md), @NonNullmasterToken: String): [PassportAccount](../-passport-account/index.md)<br>Добавить почтовый аккаунт внешних почт (&quot;mailish&quot;) Этим методом можно добавить только такой тип аккаунтов |
| [authorizeByCode](authorize-by-code.md) | [passport]<br>@WorkerThread<br>@CheckResult<br>@NonNull<br>abstract fun [authorizeByCode](authorize-by-code.md)(@NonNullcode: [PassportCode](../-passport-code/index.md)): [PassportAccount](../-passport-account/index.md)<br>Возвращает аккаунт [PassportAccount](../-passport-account/index.md) по коду [PassportCode](../-passport-code/index.md). |
| [authorizeByCookie](authorize-by-cookie.md) | [passport]<br>@WorkerThread<br>@CheckResult<br>@NonNull<br>abstract fun [authorizeByCookie](authorize-by-cookie.md)(@NonNullcookie: [PassportCookie](../-passport-cookie/index.md)): [PassportAccount](../-passport-account/index.md)<br>Возвращает аккаунт [PassportAccount](../-passport-account/index.md) по cookie [PassportCookie](../-passport-cookie/index.md), полученной из результата работы WebView или из каких-либо внешних источников. |
| [authorizeByDeviceCode](authorize-by-device-code.md) | [passport]<br>@NonNull<br>@WorkerThread<br>@CheckResult<br>abstract fun [authorizeByDeviceCode](authorize-by-device-code.md)(@NonNullenvironment: [PassportEnvironment](../-passport-environment/index.md), @NonNulldeviceCode: String): [PassportAccount](../-passport-account/index.md)<br>Заканчивает авторизацию на устройстве. |
| [createAccountNotAuthorizedIntent](create-account-not-authorized-intent.md) | [passport]<br>@CheckResult<br>@AnyThread<br>abstract fun [createAccountNotAuthorizedIntent](create-account-not-authorized-intent.md)(@NonNullcontext: Context, @NonNullproperties: [PassportAccountNotAuthorizedProperties](../-passport-account-not-authorized-properties/index.md)): Intent<br>Создает Intent для показа плашки с информацией о необходимости повторного ввода пароля для аккаунта |
| [createAuthByQrConfirmIntent](create-auth-by-qr-confirm-intent.md) | [passport]<br>@AnyThread<br>@CheckResult<br>@NonNull<br>abstract fun [createAuthByQrConfirmIntent](create-auth-by-qr-confirm-intent.md)(@NonNulluri: Uri): Intent |
| [createAuthorizationByQrIntent](create-authorization-by-qr-intent.md) | [passport]<br>@AnyThread<br>@CheckResult<br>@NonNull<br>abstract fun [createAuthorizationByQrIntent](create-authorization-by-qr-intent.md)(@NonNullcontext: Context, @NonNullproperties: [PassportAuthByQrProperties](../-passport-auth-by-qr-properties/index.md)): Intent<br>Возвращает Intent для запуска Activity с авторизацией по QR коду на Android TV В onActivityResult возвращается [PassportLoginResult](../-passport-login-result/index.md) если пользователь авторизовался.<br>[passport]<br>@AnyThread<br>@CheckResult<br>@NonNull<br>@Deprecated<br>~~abstract~~ ~~fun~~ [~~createAuthorizationByQrIntent~~](create-authorization-by-qr-intent.md)~~(~~@NonNullcontext: Context, @NonNullenvironment: [PassportEnvironment](../-passport-environment/index.md), @NonNulltheme: [PassportTheme](../-passport-theme/index.md)~~)~~~~:~~ Intent |
| [createAuthorizeByTrackIdIntent](create-authorize-by-track-id-intent.md) | [passport]<br>@AnyThread<br>@CheckResult<br>@NonNull<br>abstract fun [createAuthorizeByTrackIdIntent](create-authorize-by-track-id-intent.md)(@NonNullcontext: Context, @NonNullloginProperties: [PassportLoginProperties](../-passport-login-properties/index.md), @NonNulltrackId: [PassportTrackId](../-passport-track-id/index.md)): Intent<br>Экран запускает авторизацию по trackId. |
| [createAutoLoginIntent](create-auto-login-intent.md) | [passport]<br>@CheckResult<br>@NonNull<br>@AnyThread<br>abstract fun [createAutoLoginIntent](create-auto-login-intent.md)(@NonNullcontext: Context, @NonNulluid: [PassportUid](../-passport-uid/index.md), @NonNullautoLoginProperties: [PassportAutoLoginProperties](../-passport-auto-login-properties/index.md)): Intent<br> Создает Intent для отображения информации об автологине  Пользователь может отменить автологин, нажав соответствующую кнопку  Intent нужно запускать через startActivityForResult. |
| [createBindPhoneIntent](create-bind-phone-intent.md) | [passport]<br>@CheckResult<br>@AnyThread<br>abstract fun [createBindPhoneIntent](create-bind-phone-intent.md)(@NonNullcontext: Context, @NonNullproperties: [PassportBindPhoneProperties](../-passport-bind-phone-properties/index.md)): Intent<br>Создаёт интент с экраном привязки номера телефона. |
| [createLoginIntent](create-login-intent.md) | [passport]<br>@AnyThread<br>@NonNull<br>abstract fun [createLoginIntent](create-login-intent.md)(@NonNullcontext: Context, @NonNullloginProperties: [PassportLoginProperties](../-passport-login-properties/index.md)): Intent<br>Создание Intent-а, использование которого в startActivityForResult() откроет окно выбора аккаунта или же регистрации нового аккаунта. |
| [createSendAuthToTrackIntent](create-send-auth-to-track-intent.md) | [passport]<br>@AnyThread<br>@CheckResult<br>@NonNull<br>abstract fun [createSendAuthToTrackIntent](create-send-auth-to-track-intent.md)(@NonNullcontext: Context, @NonNulluri: String, @NullablepassportUid: [PassportUid](../-passport-uid/index.md), useSecureDialogStyle: Boolean): Intent<br>Экран добавляет авторизацию в трэк который передан в uri Текущий сценарий использования предполагает получение trackId с помощью сканера QR кодов на странице [https://passport.yandex.ru/auth?mode=qr](https://passport.yandex.ru/auth?mode=qr) и передачу авторизации пользователя из приложения на эту страницу. |
| [createSocialApplicationBindIntent](create-social-application-bind-intent.md) | [passport]<br>@CheckResult<br>@NonNull<br>@AnyThread<br>abstract fun [createSocialApplicationBindIntent](create-social-application-bind-intent.md)(@NonNullcontext: Context, @NonNullproperties: [PassportSocialApplicationBindProperties](../-passport-social-application-bind-properties/index.md)): Intent |
| [createSocialBindIntent](create-social-bind-intent.md) | [passport]<br>@CheckResult<br>@NonNull<br>@AnyThread<br>abstract fun [createSocialBindIntent](create-social-bind-intent.md)(@NonNullcontext: Context, @NonNullproperties: [PassportSocialBindProperties](../-passport-social-bind-properties/index.md)): Intent<br> Создать интент для связки аккаунта с [PassportUid](../-passport-uid/index.md) uid с социальной сетью из списка [PassportSocialConfiguration](../-passport-social-configuration/index.md) для [isFullSocial](../-passport-social-configuration/is-full-social.md)== true. |
| [createTurboAppAuthIntent](create-turbo-app-auth-intent.md) | [passport]<br>@AnyThread<br>@CheckResult<br>@NonNull<br>abstract fun [createTurboAppAuthIntent](create-turbo-app-auth-intent.md)(@NonNullcontext: Context, @NonNullproperties: [PassportTurboAppAuthProperties](../-passport-turbo-app-auth-properties/index.md)): Intent<br>Возвращает Intent для запуска Activity для подтверждения скоупов для турбоаппа. |
| [dropToken](drop-token.md) | [passport]<br>@WorkerThread<br>abstract fun [dropToken](drop-token.md)(@NonNulltoken: String)<br>Удалить токен по его значению. |
| [getAccount](get-account.md) | [passport]<br>@WorkerThread<br>@CheckResult<br>@NonNull<br>abstract fun [getAccount](get-account.md)(@NonNulluid: [PassportUid](../-passport-uid/index.md)): [PassportAccount](../-passport-account/index.md)<br>Возвращает аккаунт [PassportAccount](../-passport-account/index.md) по уникальному идентификатору [PassportUid](../-passport-uid/index.md)Будет найден аккаунт с нужным uid.<br>[passport]<br>@Deprecated<br>@WorkerThread<br>@CheckResult<br>@NonNull<br>~~abstract~~ ~~fun~~ [~~getAccount~~](get-account.md)~~(~~@NonNullaccountName: String~~)~~~~:~~ [PassportAccount](../-passport-account/index.md)<br>Возвращает аккаунт [PassportAccount](../-passport-account/index.md) по идентификатору name. |
| [getAccountManagementUrl](get-account-management-url.md) | [passport]<br>@WorkerThread<br>@CheckResult<br>@NonNull<br>abstract fun [getAccountManagementUrl](get-account-management-url.md)(@NonNulluid: [PassportUid](../-passport-uid/index.md)): Uri<br>Возвращает url страницы на которой пользователь может просмотреть или изменить свои данные в аккаунте. |
| [getAccounts](get-accounts.md) | [passport]<br>@WorkerThread<br>@CheckResult<br>@NonNull<br>abstract fun [getAccounts](get-accounts.md)(@NonNullfilter: [PassportFilter](../-passport-filter/index.md)): List&lt;[PassportAccount](../-passport-account/index.md)&gt;<br>Возвращает список аккаунтов, соответствующих фильтру [PassportFilter](../-passport-filter/index.md). |
| [getAccountUpgrader](get-account-upgrader.md) | [passport]<br>@NonNull<br>abstract fun [getAccountUpgrader](get-account-upgrader.md)(): [PassportAccountUpgrader](../-passport-account-upgrader/index.md) |
| [getAuthorizationUrl](get-authorization-url.md) | [passport]<br>@WorkerThread<br>@CheckResult<br>@NonNull<br>abstract fun [getAuthorizationUrl](get-authorization-url.md)(@NonNullproperties: [PassportAuthorizationUrlProperties](../-passport-authorization-url-properties/index.md)): String<br>Возвращает URL для авторизации внутри WebView, то есть меняет авторизацию в приложении на авторизацию по куке.<br>[passport]<br>@Deprecated<br>@WorkerThread<br>@CheckResult<br>@NonNull<br>~~abstract~~ ~~fun~~ [~~getAuthorizationUrl~~](get-authorization-url.md)~~(~~@NonNulluid: [PassportUid](../-passport-uid/index.md), @NonNullreturnUrl: String, @NonNulltld: String, @NullableyandexuidCookieValue: String~~)~~~~:~~ String |
| [getCode](get-code.md) | [passport]<br>@WorkerThread<br>@CheckResult<br>@NonNull<br>@Deprecated<br>~~abstract~~ ~~fun~~ [~~getCode~~](get-code.md)~~(~~@NonNulluid: [PassportUid](../-passport-uid/index.md)~~)~~~~:~~ [PassportCode](../-passport-code/index.md)<br>@WorkerThread<br>@CheckResult<br>@NonNull<br>@Deprecated<br>~~abstract~~ ~~fun~~ [~~getCode~~](get-code.md)~~(~~@NonNulluid: [PassportUid](../-passport-uid/index.md), @NonNullcredentials: [PassportCredentials](../-passport-credentials/index.md)~~)~~~~:~~ [PassportCode](../-passport-code/index.md)<br>Возвращает код (&quot;код подтверждения&quot;) по уникальному идентификатору [PassportUid](../-passport-uid/index.md).<br>[passport]<br>@WorkerThread<br>@CheckResult<br>@NonNull<br>abstract fun [getCode](get-code.md)(@NonNulluid: [PassportUid](../-passport-uid/index.md), @NonNullcredentialProvider: [PassportCredentialProvider](../-passport-credential-provider/index.md)): [PassportCode](../-passport-code/index.md)<br>Returns the code (&quot;confirmation code&quot;) by a unique identifier [PassportUid](../-passport-uid/index.md). |
| [getCurrentAccount](get-current-account.md) | [passport]<br>@WorkerThread<br>@Nullable<br>abstract fun [getCurrentAccount](get-current-account.md)(): [PassportAccount](../-passport-account/index.md)<br>Возвращает системный аккаунт, который был ранее сохранен через вызов [setCurrentAccount](set-current-account.md). |
| [getDeviceCode](get-device-code.md) | [passport]<br>@Deprecated<br>@WorkerThread<br>@NonNull<br>~~abstract~~ ~~fun~~ [~~getDeviceCode~~](get-device-code.md)~~(~~@NonNullenvironment: [PassportEnvironment](../-passport-environment/index.md), @NullabledeviceName: String~~)~~~~:~~ [PassportDeviceCode](../-passport-device-code/index.md)<br>Начинает процесс авторизации устройства  На стороне устройства без авторизации необходимо вызвать данный метод и каким-либо образом (например, qr код) передать userCode на устройство с авторизацией  Deprecated: используйте метод [getDeviceCode](get-device-code.md) с параметром clientBound равным true<br>[passport]<br>@CheckResult<br>@WorkerThread<br>@NonNull<br>abstract fun [getDeviceCode](get-device-code.md)(@NonNullenvironment: [PassportEnvironment](../-passport-environment/index.md), @NullabledeviceName: String, clientBound: Boolean): [PassportDeviceCode](../-passport-device-code/index.md)<br>Начинает процесс авторизации другого устройства  На стороне устройства без авторизации необходимо вызвать данный метод и каким-либо образом (например, qr код) передать userCode на устройство с авторизацией  Метод [getDeviceCode](get-device-code.md) вызывает метод [getDeviceCode](get-device-code.md) с параметром clientBound равным true |
| [getLinkageCandidate](get-linkage-candidate.md) | [passport]<br>@CheckResult<br>@WorkerThread<br>@Nullable<br>abstract fun [getLinkageCandidate](get-linkage-candidate.md)(@NonNulluid: [PassportUid](../-passport-uid/index.md)): [PassportAccount](../-passport-account/index.md)<br> Возвращает аккаунт, подходящий для связывания с указанным аккаунтом. |
| [getPersonProfile](get-person-profile.md) | [passport]<br>@CheckResult<br>@WorkerThread<br>@NonNull<br>abstract fun [getPersonProfile](get-person-profile.md)(@NonNulluid: [PassportUid](../-passport-uid/index.md), needDisplayNameVariants: Boolean): [PassportPersonProfile](../-passport-person-profile/index.md)<br>Получение пользовательских данных для дальнейшего их редактирования |
| [getToken](get-token.md) | [passport]<br>@WorkerThread<br>@CheckResult<br>@NonNull<br>abstract fun [getToken](get-token.md)(@NonNulluid: [PassportUid](../-passport-uid/index.md)): [PassportToken](../-passport-token/index.md)<br>@WorkerThread<br>@CheckResult<br>@NonNull<br>abstract fun [getToken](get-token.md)(@NonNulluid: [PassportUid](../-passport-uid/index.md), @NonNullcredentials: [PassportCredentials](../-passport-credentials/index.md)): [PassportToken](../-passport-token/index.md)<br>@WorkerThread<br>@CheckResult<br>@NonNull<br>abstract fun [getToken](get-token.md)(@NonNulluid: [PassportUid](../-passport-uid/index.md), @NonNullarguments: [PassportPaymentAuthArguments](../-passport-payment-auth-arguments/index.md)): [PassportToken](../-passport-token/index.md)<br>Возвращает авторизационный токен по уникальному идентификатору [PassportUid](../-passport-uid/index.md). |
| [getTurboAppAnonymizedUserInfo](get-turbo-app-anonymized-user-info.md) | [passport]<br>@WorkerThread<br>@NonNull<br>abstract fun [getTurboAppAnonymizedUserInfo](get-turbo-app-anonymized-user-info.md)(@NonNullproperties: [PassportTurboAppAuthProperties](../-passport-turbo-app-auth-properties/index.md)): [PassportTurboAppJwtToken](../-passport-turbo-app-jwt-token/index.md)<br>Отдаёт обезличенную информацию о пользователе, включая publisher-specific user id (PSUID). |
| [getTurboAppUserInfo](get-turbo-app-user-info.md) | [passport]<br>@WorkerThread<br>@NonNull<br>abstract fun [getTurboAppUserInfo](get-turbo-app-user-info.md)(@NonNullenvironment: [PassportEnvironment](../-passport-environment/index.md), @NonNulloauthToken: String): [PassportTurboAppJwtToken](../-passport-turbo-app-jwt-token/index.md)<br>Отдаёт информацию о пользователе, включая publisher-specific user id (PSUID). |
| [logout](logout.md) | [passport]<br>@WorkerThread<br>abstract fun [logout](logout.md)(@NonNulluid: [PassportUid](../-passport-uid/index.md))<br> Метод требуется вызывать в случае, если пользователь нажал &quot;Выйти&quot; в приложении  Выполняет следующие действия: Удаляет закэшированный клиентский токенОтключает автологин для данного аккаунта. |
| [onInstanceIdTokenRefresh](on-instance-id-token-refresh.md) | [passport]<br>@WorkerThread<br>abstract fun [onInstanceIdTokenRefresh](on-instance-id-token-refresh.md)()<br>Метод требуется вызывать при срабатывании слушателя InstanceIDListenerService. |
| [onPushMessageReceived](on-push-message-received.md) | [passport]<br>@CheckResult<br>@WorkerThread<br>abstract fun [onPushMessageReceived](on-push-message-received.md)(@NonNullfrom: String, @NonNulldata: Bundle): Boolean<br>Метод требуется вызывать при получении любого push сообщения. |
| [performLinkageForce](perform-linkage-force.md) | [passport]<br>@WorkerThread<br>abstract fun [performLinkageForce](perform-linkage-force.md)(@NonNullfirstUid: [PassportUid](../-passport-uid/index.md), @NonNullsecondUid: [PassportUid](../-passport-uid/index.md))<br>Выполняет связку аккаунтов без выполнения проверок на стороне АМ. |
| [performSync](perform-sync.md) | [passport]<br>@WorkerThread<br>abstract fun [performSync](perform-sync.md)(@NonNulluid: [PassportUid](../-passport-uid/index.md))<br>Принудительно обновляет данные об аккаунте. |
| [removeAccount](remove-account.md) | [passport]<br>@WorkerThread<br>abstract fun [removeAccount](remove-account.md)(@NonNulluid: [PassportUid](../-passport-uid/index.md))<br> &quot;Настоящее&quot; удаление аккаунта и связанных с ним данных из системной базы. |
| [sendAuthToTrack](send-auth-to-track.md) | [passport]<br>@WorkerThread<br>abstract fun [sendAuthToTrack](send-auth-to-track.md)(@NonNulluid: [PassportUid](../-passport-uid/index.md), @NonNulltrackId: String)<br>Авторизовать пользователя по коду trackId в аккаунт [PassportUid](../-passport-uid/index.md). |
| [setCurrentAccount](set-current-account.md) | [passport]<br>@WorkerThread<br>abstract fun [setCurrentAccount](set-current-account.md)(@NonNulluid: [PassportUid](../-passport-uid/index.md))<br>Сохраняет UID и имя аккаунта с переданным [PassportUid](../-passport-uid/index.md) в SharedPreferences вызывающего приложения. |
| [stashValue](stash-value.md) | [passport]<br>@WorkerThread<br>abstract fun [stashValue](stash-value.md)(@NonNulluid: [PassportUid](../-passport-uid/index.md), @NonNullcell: String, @Nullablevalue: String)<br>Добавляет или обновляет сохранённое значение value по ключу [cell](../-passport-stash-cell/index.md) для аккаунта [uid](../-passport-uid/index.md).<br>[passport]<br>@WorkerThread<br>abstract fun [stashValue](stash-value.md)(@NonNulluids: List&lt;[PassportUid](../-passport-uid/index.md)&gt;, @NonNullcell: String, @Nullablevalue: String)<br>Функция аналогична [stashValue](stash-value.md), но позволяет выполнить операцию сразу для нескольких аккаунтов |
| [tryAutoLogin](try-auto-login.md) | [passport]<br>@WorkerThread<br>@CheckResult<br>@NonNull<br>@Deprecated<br>~~abstract~~ ~~fun~~ [~~tryAutoLogin~~](try-auto-login.md)~~(~~@NonNullautoLoginProperties: [PassportAutoLoginProperties](../-passport-auto-login-properties/index.md)~~)~~~~:~~ [PassportAccount](../-passport-account/index.md)<br>@WorkerThread<br>@CheckResult<br>@NonNull<br>abstract fun [tryAutoLogin](try-auto-login.md)(@NonNullcontext: Context, @NonNullproperties: [PassportAutoLoginProperties](../-passport-auto-login-properties/index.md)): [PassportAutoLoginResult](../-passport-auto-login-result/index.md)<br> Производит поиск подходящего для приложения аккаунта в системном хранилище. |
| [updateAvatar](update-avatar.md) | [passport]<br>@WorkerThread<br>abstract fun [updateAvatar](update-avatar.md)(@NonNulluid: [PassportUid](../-passport-uid/index.md), @NonNulluri: Uri)<br>Обновление аватара для аккаунта. |
| [updatePersonProfile](update-person-profile.md) | [passport]<br>@WorkerThread<br>abstract fun [updatePersonProfile](update-person-profile.md)(@NonNulluid: [PassportUid](../-passport-uid/index.md), @NonNullpersonProfile: [PassportPersonProfile](../-passport-person-profile/index.md))<br>Обновление пользовательских данных  Если какое-то из полей в PersonProfile null, то это поле не будет обновляться. |
