//[passport](../../index.md)/[com.yandex.passport.api](index.md)

# Package com.yandex.passport.api

## Types

| Name | Summary |
|---|---|
| [ExperimentalKotlinApi](-experimental-kotlin-api/index.md) | [passport]<br>annotation class [ExperimentalKotlinApi](-experimental-kotlin-api/index.md)<br>Marks new experimental Passport Api, designed for better Kotlin compatibility. |
| [KPassport](-k-passport/index.md) | [passport]<br>object [KPassport](-k-passport/index.md)<br>Experimental replacement for [Passport](-passport/index.md) as central entry point of android passport library. It is designed to be Kotlin-compatible. |
| [KPassportApi](-k-passport-api/index.md) | [passport]<br>interface [KPassportApi](-k-passport-api/index.md)<br>Experimental replacement for [PassportApi](-passport-api/index.md) as api accessor of android passport library. It is designed to be Kotlin-compatible. All blocking WorkerThread methods are replaced by suspend ones. |
| [KPassportEnvironment](-k-passport-environment/index.md) | [passport]<br>enum [KPassportEnvironment](-k-passport-environment/index.md) : Enum&lt;[KPassportEnvironment](-k-passport-environment/index.md)&gt; , [PassportEnvironment](-passport-environment/index.md)<br>Describes the passport environment in enum-way. |
| [KPassportIntentFactory](-k-passport-intent-factory/index.md) | [passport]<br>interface [KPassportIntentFactory](-k-passport-intent-factory/index.md)<br>Experimental interface, responsible for passport-based intent creation. |
| [KPassportStashCell](-k-passport-stash-cell/index.md) | [passport]<br>enum [KPassportStashCell](-k-passport-stash-cell/index.md) : Enum&lt;[KPassportStashCell](-k-passport-stash-cell/index.md)&gt; |
| [Passport](-passport/index.md) | [passport]<br>open class [Passport](-passport/index.md) |
| [PassportAccount](-passport-account/index.md) | [passport]<br>interface [PassportAccount](-passport-account/index.md)<br>Содержит описание аккаунта в Паспорте, а также некоторых локальных для устройства параметров (пин-код). |
| [PassportAccountNotAuthorizedProperties](-passport-account-not-authorized-properties/index.md) | [passport]<br>interface [PassportAccountNotAuthorizedProperties](-passport-account-not-authorized-properties/index.md) : ThemedProperties |
| [PassportAccountUpgrader](-passport-account-upgrader/index.md) | [passport]<br>interface [PassportAccountUpgrader](-passport-account-upgrader/index.md)<br>A facade interface for mechanism of account upgrade. |
| [PassportAccountUpgradeStatus](-passport-account-upgrade-status/index.md) | [passport]<br>enum [PassportAccountUpgradeStatus](-passport-account-upgrade-status/index.md) : Enum&lt;[PassportAccountUpgradeStatus](-passport-account-upgrade-status/index.md)&gt; <br>Represents current upgrade status of give account. |
| [PassportActions](-passport-actions/index.md) | [passport]<br>interface [PassportActions](-passport-actions/index.md) |
| [PassportAnimationTheme](-passport-animation-theme/index.md) | [passport]<br>interface [PassportAnimationTheme](-passport-animation-theme/index.md) |
| [PassportApi](-passport-api/index.md) | [passport]<br>interface [PassportApi](-passport-api/index.md) |
| [PassportAssertionDelegate](-passport-assertion-delegate/index.md) | [passport]<br>interface [PassportAssertionDelegate](-passport-assertion-delegate/index.md) : AssertionDelegate |
| [PassportAuthByQrProperties](-passport-auth-by-qr-properties/index.md) | [passport]<br>interface [PassportAuthByQrProperties](-passport-auth-by-qr-properties/index.md) : ThemedProperties |
| [PassportAuthorizationUrlProperties](-passport-authorization-url-properties/index.md) | [passport]<br>interface [PassportAuthorizationUrlProperties](-passport-authorization-url-properties/index.md) |
| [PassportAutoLoginMode](-passport-auto-login-mode/index.md) | [passport]<br>enum [PassportAutoLoginMode](-passport-auto-login-mode/index.md) : Enum&lt;[PassportAutoLoginMode](-passport-auto-login-mode/index.md)&gt; |
| [PassportAutoLoginProperties](-passport-auto-login-properties/index.md) | [passport]<br>interface [PassportAutoLoginProperties](-passport-auto-login-properties/index.md)<br>Параметры, использующиеся при попытке автологина |
| [PassportAutoLoginResult](-passport-auto-login-result/index.md) | [passport]<br>interface [PassportAutoLoginResult](-passport-auto-login-result/index.md) |
| [PassportBindPhoneProperties](-passport-bind-phone-properties/index.md) | [passport]<br>interface [PassportBindPhoneProperties](-passport-bind-phone-properties/index.md) |
| [PassportCode](-passport-code/index.md) | [passport]<br>interface [PassportCode](-passport-code/index.md)<br>Содержит код (&quot;код подтверждения&quot;), полученный от метода [PassportApi.getCode](../../../passport/passport/com.yandex.passport.api/-passport-api/get-code.md) или [Factory.from](-passport-code/-factory/from.md).<br></br><br></br> Подробнее см. описание метода [PassportApi.getCode](../../../passport/passport/com.yandex.passport.api/-passport-api/get-code.md).<br></br><br></br> Пример значения: <tt>3ujb65647gy6pklk</tt><br></br> |
| [PassportCookie](-passport-cookie/index.md) | [passport]<br>interface [PassportCookie](-passport-cookie/index.md) |
| [PassportCredentialProvider](-passport-credential-provider/index.md) | [passport]<br>interface [PassportCredentialProvider](-passport-credential-provider/index.md)<br>Used to provide passport credentials for some methods where credentials are optional. |
| [PassportCredentials](-passport-credentials/index.md) | [passport]<br>interface [PassportCredentials](-passport-credentials/index.md)<br>Содержит зашифрованную пару client id / client secret.<br></br><br></br> Подробнее смотрите в документации [по регистрации oauth приложения.](https://wiki.yandex-team.ru/yandexmobile/accountmanager/#passportparameters)<br></br> |
| [PassportDeviceCode](-passport-device-code/index.md) | [passport]<br>interface [PassportDeviceCode](-passport-device-code/index.md)<br>Используется для передачи авторизации с одного устройства на другое |
| [PassportEnvironment](-passport-environment/index.md) | [passport]<br>interface [PassportEnvironment](-passport-environment/index.md)<br>Описывает паспортное окружение. |
| [PassportErrorCode](-passport-error-code/index.md) | [passport]<br>~~object~~ [~~PassportErrorCode~~](-passport-error-code/index.md) |
| [PassportFilter](-passport-filter/index.md) | [passport]<br>interface [PassportFilter](-passport-filter/index.md)<br>Contains a filter of accounts by their type. |
| [PassportIdentifierHintVariant](-passport-identifier-hint-variant/index.md) | [passport]<br>enum [PassportIdentifierHintVariant](-passport-identifier-hint-variant/index.md) : Enum&lt;[PassportIdentifierHintVariant](-passport-identifier-hint-variant/index.md)&gt; |
| [PassportLogger](-passport-logger/index.md) | [passport]<br>interface [PassportLogger](-passport-logger/index.md) : LoggingDelegate |
| [PassportLoginAction](-passport-login-action/index.md) | [passport]<br>enum [PassportLoginAction](-passport-login-action/index.md) : Enum&lt;[PassportLoginAction](-passport-login-action/index.md)&gt; <br>Определяет что произошло с аккаунтом перед тем как его вернули приложению. |
| [PassportLoginError](-passport-login-error/index.md) | [passport]<br>interface [PassportLoginError](-passport-login-error/index.md)<br>Содержит ошибку неуспешной авторизации. |
| [PassportLoginProperties](-passport-login-properties/index.md) | [passport]<br>interface [PassportLoginProperties](-passport-login-properties/index.md)<br>Contains a filter for showing the authorization form to the user. |
| [PassportLoginResult](-passport-login-result/index.md) | [passport]<br>interface [PassportLoginResult](-passport-login-result/index.md)<br>Содержит результат успешной авторизации. |
| [PassportLogLevel](index.md#-33048098%2FClasslikes%2F339143592) | [passport]<br>typealias [PassportLogLevel](index.md#-33048098%2FClasslikes%2F339143592) = LogLevel |
| [PassportPaymentAuthArguments](-passport-payment-auth-arguments/index.md) | [passport]<br>interface [PassportPaymentAuthArguments](-passport-payment-auth-arguments/index.md) : Parcelable<br>Аргументы для прохождения платежной авторизации. |
| [PassportPersonProfile](-passport-person-profile/index.md) | [passport]<br>interface [PassportPersonProfile](-passport-person-profile/index.md) |
| [PassportProperties](-passport-properties/index.md) | [passport]<br>interface [PassportProperties](-passport-properties/index.md)<br>Содержит параметры начальной инициализации библиотеки. |
| [PassportPushTokenProvider](-passport-push-token-provider/index.md) | [passport]<br>interface [PassportPushTokenProvider](-passport-push-token-provider/index.md) |
| [PassportSocial](-passport-social/index.md) | [passport]<br>open class [PassportSocial](-passport-social/index.md) |
| [PassportSocialApplicationBindProperties](-passport-social-application-bind-properties/index.md) | [passport]<br>interface [PassportSocialApplicationBindProperties](-passport-social-application-bind-properties/index.md) |
| [PassportSocialBindProperties](-passport-social-bind-properties/index.md) | [passport]<br>interface [PassportSocialBindProperties](-passport-social-bind-properties/index.md) |
| [PassportSocialConfiguration](-passport-social-configuration/index.md) | [passport]<br>enum [PassportSocialConfiguration](-passport-social-configuration/index.md) : Enum&lt;[PassportSocialConfiguration](-passport-social-configuration/index.md)&gt; |
| [PassportSocialRegistrationProperties](-passport-social-registration-properties/index.md) | [passport]<br>interface [PassportSocialRegistrationProperties](-passport-social-registration-properties/index.md) |
| [PassportStash](-passport-stash/index.md) | [passport]<br>interface [PassportStash](-passport-stash/index.md)<br>Интерфейс для метода [getStash](-passport-account/get-stash.md), позволяющий получить значение по ключу [PassportStashCell](-passport-stash-cell/index.md). |
| [PassportStashCell](-passport-stash-cell/index.md) | [passport]<br>@Retention(value = RetentionPolicy.SOURCE)<br>annotation class [PassportStashCell](-passport-stash-cell/index.md) |
| [PassportTaskId](-passport-task-id/index.md) | [passport]<br>interface [PassportTaskId](-passport-task-id/index.md)<br>Контейнер, который содержит taskId социальной авторизации. |
| [PassportTheme](-passport-theme/index.md) | [passport]<br>enum [PassportTheme](-passport-theme/index.md) : Enum&lt;[PassportTheme](-passport-theme/index.md)&gt; <br>Theme setting to display passport Ui. |
| [PassportToken](-passport-token/index.md) | [passport]<br>interface [PassportToken](-passport-token/index.md)<br>Содержит значение OAuth токена. |
| [PassportTrackId](-passport-track-id/index.md) | [passport]<br>interface [PassportTrackId](-passport-track-id/index.md) |
| [PassportTurboAppAuthProperties](-passport-turbo-app-auth-properties/index.md) | [passport]<br>interface [PassportTurboAppAuthProperties](-passport-turbo-app-auth-properties/index.md) : ThemedProperties |
| [PassportTurboAppJwtToken](-passport-turbo-app-jwt-token/index.md) | [passport]<br>interface [PassportTurboAppJwtToken](-passport-turbo-app-jwt-token/index.md) |
| [PassportTurboAppResult](-passport-turbo-app-result/index.md) | [passport]<br>class [PassportTurboAppResult](-passport-turbo-app-result/index.md)(val token: [PassportToken](-passport-token/index.md), val jwtToken: [PassportTurboAppJwtToken](-passport-turbo-app-jwt-token/index.md), val flowErrorCodes: List&lt;String&gt;, val grantedScopes: List&lt;String&gt;) |
| [PassportTurboAuthParams](-passport-turbo-auth-params/index.md) | [passport]<br>interface [PassportTurboAuthParams](-passport-turbo-auth-params/index.md) |
| [PassportUid](-passport-uid/index.md) | [passport]<br>interface [PassportUid](-passport-uid/index.md)<br> Описывает паспортный uid - *уникальный* идентификатор, однозначно указывающий на определённый аккаунт в заданном паспортном окружении. |
| [PassportUidValue](-passport-uid-value/index.md) | [passport]<br>@IntRange(from = 1)<br>@Retention(value = RetentionPolicy.SOURCE)<br>annotation class [PassportUidValue](-passport-uid-value/index.md) |
| [PassportUserCredentials](-passport-user-credentials/index.md) | [passport]<br>interface [PassportUserCredentials](-passport-user-credentials/index.md) |
| [PassportVisualProperties](-passport-visual-properties/index.md) | [passport]<br>interface [PassportVisualProperties](-passport-visual-properties/index.md) |
| [PassportWebAmProperties](-passport-web-am-properties/index.md) | [passport]<br>interface [PassportWebAmProperties](-passport-web-am-properties/index.md) |
| [UpgradeProperties](-upgrade-properties/index.md) | [passport]<br>data class [UpgradeProperties](-upgrade-properties/index.md)(val uid: [PassportUid](-passport-uid/index.md), val theme: [PassportTheme](-passport-theme/index.md) = PassportTheme.LIGHT)<br>Data required for update process to start. |
| [UserCredentials](-user-credentials/index.md) | [passport]<br>data class [UserCredentials](-user-credentials/index.md)(environment: Environment, login: String, password: String, avatarUrl: String? = null) : Parcelable, [PassportUserCredentials](-passport-user-credentials/index.md) |

## Functions

| Name | Summary |
|---|---|
| [PassportAnimationTheme](-passport-animation-theme.md) | [passport]<br>inline fun [PassportAnimationTheme](-passport-animation-theme.md)(init: [PassportAnimationTheme.Builder](-passport-animation-theme/-builder/index.md).() -&gt; Unit): [PassportAnimationTheme](-passport-animation-theme/index.md) |
| [PassportAuthorizationUrlProperties](-passport-authorization-url-properties.md) | [passport]<br>inline fun [PassportAuthorizationUrlProperties](-passport-authorization-url-properties.md)(init: [PassportAuthorizationUrlProperties.Builder](-passport-authorization-url-properties/-builder/index.md).() -&gt; Unit): [PassportAuthorizationUrlProperties](-passport-authorization-url-properties/index.md)<br>Create new instance of [PassportAuthorizationUrlProperties](-passport-authorization-url-properties/index.md) by using kotlin type-safe-builder (DSL) mechanism. |
| [PassportAutoLoginProperties](-passport-auto-login-properties.md) | [passport]<br>inline fun [PassportAutoLoginProperties](-passport-auto-login-properties.md)(init: [PassportAutoLoginProperties.Builder](-passport-auto-login-properties/-builder/index.md).() -&gt; Unit): [PassportAutoLoginProperties](-passport-auto-login-properties/index.md)<br>Create new instance of [PassportAutoLoginProperties](-passport-auto-login-properties/index.md) by using kotlin type-safe-builder (DSL) mechanism.<br>[passport]<br>fun [PassportAutoLoginProperties](-passport-auto-login-properties.md)(filter: [PassportFilter](-passport-filter/index.md), theme: [PassportTheme](-passport-theme/index.md) = PassportTheme.LIGHT, mode: [PassportAutoLoginMode](-passport-auto-login-mode/index.md) = PassportAutoLoginMode.ONE_OR_MORE_ACCOUNT, message: String? = null): [PassportAutoLoginProperties](-passport-auto-login-properties/index.md) |
| [PassportBindPhoneProperties](-passport-bind-phone-properties.md) | [passport]<br>inline fun [PassportBindPhoneProperties](-passport-bind-phone-properties.md)(init: [PassportBindPhoneProperties.Builder](-passport-bind-phone-properties/-builder/index.md).() -&gt; Unit): [PassportBindPhoneProperties](-passport-bind-phone-properties/index.md)<br>Create new instance of [PassportBindPhoneProperties](-passport-bind-phone-properties/index.md) by using kotlin type-safe-builder (DSL) mechanism. |
| [PassportCode](-passport-code.md) | [passport]<br>fun [PassportCode](-passport-code.md)(environment: [PassportEnvironment](-passport-environment/index.md), value: String): [PassportCode](-passport-code/index.md) |
| [PassportCredentials](-passport-credentials.md) | [passport]<br>fun [PassportCredentials](-passport-credentials.md)(encryptedId: String, encryptedSecret: String): [PassportCredentials](-passport-credentials/index.md)<br>Creates a container for encrypted pair client id / client secret. |
| [PassportFilter](-passport-filter.md) | [passport]<br>inline fun [PassportFilter](-passport-filter.md)(init: [PassportFilter.Builder](-passport-filter/-builder/index.md).() -&gt; Unit): [PassportFilter](-passport-filter/index.md) |
| [PassportLoginProperties](-passport-login-properties.md) | [passport]<br>inline fun [PassportLoginProperties](-passport-login-properties.md)(init: [PassportLoginProperties.Builder](-passport-login-properties/-builder/index.md).() -&gt; Unit): [PassportLoginProperties](-passport-login-properties/index.md) |
| [PassportLoginPropertiesInternal](-passport-login-properties-internal.md) | [passport]<br>inline fun [PassportLoginPropertiesInternal](-passport-login-properties-internal.md)(init: PassportLoginPropertiesInternal.Builder.() -&gt; Unit): PassportLoginPropertiesInternal |
| [PassportPersonProfile](-passport-person-profile.md) | [passport]<br>inline fun [PassportPersonProfile](-passport-person-profile.md)(init: [PassportPersonProfile.Builder](-passport-person-profile/-builder/index.md).() -&gt; Unit): [PassportPersonProfile](-passport-person-profile/index.md)<br>Create new instance of [PassportPersonProfile](-passport-person-profile/index.md) by using kotlin type-safe-builder (DSL) mechanism. |
| [PassportProperties](-passport-properties.md) | [passport]<br>inline fun [PassportProperties](-passport-properties.md)(init: [PassportProperties.Builder](-passport-properties/-builder/index.md).() -&gt; Unit): [PassportProperties](-passport-properties/index.md)<br>Create new instance of [PassportProperties](-passport-properties/index.md) by using kotlin type-safe-builder (DSL) mechanism. |
| [PassportSocialBindProperties](-passport-social-bind-properties.md) | [passport]<br>fun [PassportSocialBindProperties](-passport-social-bind-properties.md)(init: [PassportSocialBindProperties.Builder](-passport-social-bind-properties/-builder/index.md).() -&gt; Unit): [PassportSocialBindProperties](-passport-social-bind-properties/index.md)<br>Create new instance of [PassportLoginProperties](-passport-login-properties/index.md) by using kotlin type-safe-builder (DSL) mechanism. |
| [PassportSocialRegistrationProperties](-passport-social-registration-properties.md) | [passport]<br>inline fun [PassportSocialRegistrationProperties](-passport-social-registration-properties.md)(init: [PassportSocialRegistrationProperties.Builder](-passport-social-registration-properties/-builder/index.md).() -&gt; Unit): [PassportSocialRegistrationProperties](-passport-social-registration-properties/index.md)<br>fun [PassportSocialRegistrationProperties](-passport-social-registration-properties.md)(uid: Uid? = null, message: String? = null): [PassportSocialRegistrationProperties](-passport-social-registration-properties/index.md) |
| [PassportTurboAuthParams](-passport-turbo-auth-params.md) | [passport]<br>fun [PassportTurboAuthParams](-passport-turbo-auth-params.md)(phoneNumber: String?, email: String?, firstName: String?, lastName: String?): [PassportTurboAuthParams](-passport-turbo-auth-params/index.md) |
| [PassportVisualProperties](-passport-visual-properties.md) | [passport]<br>inline fun [PassportVisualProperties](-passport-visual-properties.md)(init: [PassportVisualProperties.Builder](-passport-visual-properties/-builder/index.md).() -&gt; Unit): [PassportVisualProperties](-passport-visual-properties/index.md) |

## Properties

| Name | Summary |
|---|---|
| [canAccountBeUpgraded](can-account-be-upgraded.md) | [passport]<br>val [PassportAccountUpgradeStatus](-passport-account-upgrade-status/index.md).[canAccountBeUpgraded](can-account-be-upgraded.md): Boolean |
| [shouldAccountBeUpgraded](should-account-be-upgraded.md) | [passport]<br>val [PassportAccountUpgradeStatus](-passport-account-upgrade-status/index.md).[shouldAccountBeUpgraded](should-account-be-upgraded.md): Boolean |
