# Жизнь с Python в Аркадии

Python проекты разделяем на аналитические расчёты и регулярные/продакшн проекты.

**Регулярный или продакшн проект** - это любой проект на Python'е, который деплоится в продакшн среду или регулярно выполняется в продакшн среде или представляет из себя компонент, от которого зависят другие продакшн проекты. Например:

- бэкенд для веб-сервиса
- расчёт факторов ранжирования, запускаемый по крону
- биндинг к YT

**Аналитические расчёты** - это, например:
- код в jupyter notebook
- одноразовый расчёт, автоматизированный на Python'е

## Продакшн проекты на Python

- vcs - Аркадия
- зависимость по исходникам
- [trunk based development](https://trunkbaseddevelopment.com/)
- [статическая линковка](https://stackoverflow.com/questions/1993390/static-linking-vs-dynamic-linking)
- описание сборки через ya.make, сборка в монобинарь (1) [документация по сборке](https://docs.yandex-team.ru/ya-make/manual/python/) и [tutorial](https://docs.yandex-team.ru/ya-make/tutorials/python)
- внешние библиотеки кладутся в contrib/python, каждая библиотека только одной версии (2)

Исключения:
(1) - [проприетарные] закрытые бибилотеки могут быть причиной для исключения из-под Аркадийной сборки (подробнее TODO).
(2) - django, sqlachemy, а так же библиотеки, новые версии которых не поддерживают Python 2 - в Аркадии допускаются нескольких версий одновременно.

Для внесения в contrib нужно:
- получить одобрение в очереди CONTRIB (подробнее [тут](https://a.yandex-team.ru/arc/trunk/arcadia/contrib/))
- положить код самостоятельно или попросить об этом devtools (перевесить CONTRIB тикет на devtools@)

Для апгрейда версии библиотеки нужно внести изменения и поправить все проекты, в которых ломаются тесты, либо озадачить devtools@.

## Python 2 vs Python 3

Python 2 [объявлен deprecated](https://clubs.at.yandex-team.ru/arcadia/23044), в связи с этим весь новый код в Аркадии в идеале должен быть
PY3 или PY23. Подробнее читаем в [документации про написание py3/py23 кода](https://docs.yandex-team.ru/arcadia-python/python3)

## Arcadia и внешний мир
Если у вас возникает потребность в распространении пакетов из Аркадии куда-либо наружу, то рекомендуем использовать следующие префиксы для имен библиотек и пакетов. Это позволит избежать возможных коллизий имен (с чем у нас уже сталкивались):
* префикс namespace для библиотек – `yandex.`
* префикс `yandex-` – для загрузки в PyPI.
