# Настройка

Настройка SpeechKit Box сводится к передаче параметров распознавания и синтеза. Настройку следует выполнять с помощью скрипта ``yandex-speechkitbox-cloud``, который позволяет устанавливать значения параметров, а также останавливать и запускать сервисы.

Если [установка SpeechKit Box ](installation.md) была выполнена успешно, скрип должен находиться в каталоге ``/usr/bin/``.

Перечень ключей и допустимые значения можно узнать следующим образом:

```
$ sudo yandex-speechkitbox-cloud --help
```

## Ключи {#options}

```
$ sudo yandex-speechkitbox-cloud \
        --key <{{ API-key }}> \
        --asr-lang <ru-RU|en-US|tr-TR> \
        --asr-topic <freeform|general|mapsyari|dates|names|numbers|music|buying> \
        --tts-lang <ru-RU|en-US|uk-UK|tr-TR> \
        --tts-voice <jane|oksana|alyss|omazh|zahar|ermil> \
        --restart
```

#### --key

API-ключ, подключенный к сервису SpeechKit Mobile SDK. Получить ключ можно в [Кабинете разработчика](https://developer.tech.yandex.ru/keys/).

#### --asr-lang
Язык, для которого будет выполнено распознавание. Допустимые значения можно вывести с помощью ключа [--help](#help).


#### --asr-topic
Языковая модель, которая будет использоваться при распознавании. Для английского и турецкого языков доступны не все модели (см. [Распознавание речи](https://tech.yandex.ru/zout_speechkit/box/doc/guide_637d664254a1ebbd4c1a070bb28a9533/concepts/asr-overview-technology-docpage/)). Допустимые значения можно вывести с помощью ключа [--help](#help).

#### --tts-lang
Язык, для которого будет выполнен синтез. Допустимые значения можно вывести с помощью ключа [--help](#help).

#### --tts-voice

Голос синтезированной речи. Доступны мужские и женские голоса. Допустимые значения можно вывести с помощью ключа [--help](#help). По умолчанию используется `oksana`.

#### --start
Запустить все сервисы SpeechKit Box.
#### --stop
Остановить все сервисы SpeechKit Box.
#### --restart

Перезапустить сервисы SpeechKit Box.

Используйте ключ `restart`, когда меняете языковую модель, голос или язык.

#### --help {#help} 
Выводит перечень ключей с допустимыми значениями.

{% note info %}

Остановку и запуск сервисов выполняет менеджер процессов. Поэтому, чтобы ключи `--start`, `--stop` и `--restart` срабатывали, он должен быть запущен. Запустить менеджер можно командой:

```
$ sudo service supervisor start
```

Можно не использовать ключи типа `--restart` , а давать команды менеджеру процессов напрямую. Например, перезапуск, который выполняется по `--restart`, можно сделать с помощью команды:

```
$ sudo supervisorctl start yandex-services-monitor
```

{% endnote %}


## Особенности {#section_u2s_ny3_yz}

- Значения ключей `--asr-lang, --asr-topic, --tts-lang` и `--tts-voice` укажите в одной команде. Значения нельзя передавать последовательно несколькими командами.
    
- Укажите значения всех трех ключей: `--asr-lang, --asr-topic, --tts-lang`, даже если вы меняете только что-то одно.
    
- Ключ `--tts-voice` можно не указывать, если вы не хотите менять голос, который используется в синтезе по умолчанию.
    
- Укажите валидный API-ключ. Ключ нужно указывать каждый раз, когда передаете значения параметров.
    

{% note info %}

После того как вы внесли изменения в настройки, сервисы необходимо перезапустить. SpeechKit Box выполнит остановку и запуск автоматически, если в команде указан ключ `--restart`.

{% endnote %}


## Пример {#example}

Для распознавания речи будет использоваться модель `freeform` (Тексты) для английского языка. Синтез речи будет выполняться для турецкого языка (голосом `zahar`).

```
$ sudo yandex-speechkitbox-cloud
        --key {{ API-key }} \
        --asr-lang en-US \
        --asr-topic freeform \
        --tts-lang tr-TR \
        --tts-voice zahar \
        --restart
```

Обратите внимание, ключи: `--asr-lang, --asr-topic, --tts-lang` передаются в одной команде. Их нельзя передавать последовательно.

