# Методы блока custom-morda

**Список методов блока custom-morda**:
- [set_state_by_tune](block-custom-morda-methods.md#set_state_by_tune);
- [save_tune](block-custom-morda-methods.md#save_tune).

#### `set_state_by_tune` (`setStateByTune`) {#set_state_by_tune} 

Сохраняет в контейнере [State](../concepts/state-ov.md) параметры из указанного блока настроек пользователя.

**Входные параметры**: 
- имена переменных в контейнере State (через запятую), в которые будут сохранены значения настроек пользователя. Первая переменная из списка будет содержать первое значение из блока настроек, вторая переменная - второе значение и т.д. Если имен меньше чем значений, то для недостающих переменных берется последнее имя из списка и к нему добавляется порядковый номер (name0, name1, name2). Если значений меньше, чем имен, переменные, которым "не досталось" значений, будут опущены;
- номер блока настроек пользователя в куке _my_.

**Пример использования**:

Допустим, в блоке настроек под номером 27 содержится массив из 5 числовых значений: [13, 4, 7, 9, 10]. Тогда после обработки блока

```
<custom-morda>
   <method>set_state_by_tune</method>
   <param type="String">block,city_id,count</param>
   <param type="Long">27</param>
</custom-morda>
```

в State будут записаны следующие
 переменные:
- `block` со значением 13;
- `city_id` со значением 4;
- `count` со значением 7;
- `count0` со значением 9;
- `count1` со значением 10.

#### `save_tune` (`saveTune`) {#save_tune}

Формирует блок настроек пользователя, сохраняет его в объекте [CustomMorda](../concepts/custom-morda-ov.md) и выставляет куку my.

**Входные параметры**:
- имена переменных в контейнере State, перечисленные через запятую. Последнее из перечисленных имен считается префиксом (в приведенном ниже примере - `count`), по которому происходит получение значений переменных (`count`, `count0`, `count1` и т.д.), если таковые присутствуют в контейнере State;
- номер блока настроек пользователя.

**Пример использования**

Допустим, в контейнере State есть следующие переменные:
- `block` со значением 13;
- `city_id` со значением 4;
- `count` со значением 7;
- `count0` со значением 9;
- `count1` со значением 10.

Тогда после обработки следующего блока

```
<custom-morda>
   <method>save_tune</method>
   <param type="String">block,city_id,count</param>
   <param type="Long">27</param>
</custom-morda>
```

в 27-ой блок настроек пользователя в куке my будет записан следующий массив значений: [13, 4, 7, 9, 10].

