# Все типы параметров методов, вызываемых в XScript-блоках

#|
|| Наименование типа параметров | Описание | Тип по классификации | Соответствующий тип данных (класс) в IDL ||
|| Auth | Передаёт объект [Auth](../concepts/auth-ov.md), который содержит информацию об авторизации пользователя с точки зрения Яндекс.Паспорта. | сложный (объект) | Yandex::Auth ||
|| AuthInfo | Облегчённый вид Auth, структура из трёх полей. | сложный (структура) | Yandex::AuthInfo ||
|| AuthKarma | Адаптер объекта [Auth](../concepts/auth-ov.md). Передает информацию о карме пользователя (целое число). Для неавторизованных пользователей значение кармы равно нулю. | специализированный приводимый | long ||
|| AuthKarmaStatus | Адаптер объекта [Auth](../concepts/auth-ov.md). Передает информацию о статусе кармы пользователя (целое число). Для неавторизованных пользователей значение статуса кармы равно нулю. | специализированный приводимый | long ||
|| BanTime | Адаптер объекта [Auth](../concepts/auth-ov.md). Передает время в Unix-формате (в виде целого числа типа Long), после которого учетная запись пользователя официально считается "спамовой". Значение BanTime получается из Blackbox. Для "неспамовых" учетных записей и неавторизованных пользователей это значение равно нулю. | специализированный приводимый | long ||
|| Bool, Boolean | Булев тип данных. | простой | boolean ||
|| CheckSecretKey | Содержит флаг, выставляющийся по результатам сравнения [секретного ключа](../concepts/secret-key.md) со значением указанного параметра. Если они совпадают, возвращается булевское значение "1", если нет - "0". | специализированный приводимый | boolean ||
|| Cookie | Адаптер объекта [Request](../concepts/request-ov.md). Передаёт одну из строк cookies. Обычно приводится к String. | специализированный приводимый | string ||
|| CustomMorda | Передаёт объект [CustomMorda](../concepts/custom-morda-ov.md), который содержит проектные настройки пользователя. | сложный (объект) | Yandex::CustomMorda ||
|| Double | Тип числовых данных с плавающей запятой двойной точности (64 бита). | простой | double ||
|| Float | Тип числовых данных с плавающей запятой. | простой | float ||
|| Hostname | Содержит имя машины, на которой работает XScript. | специальный | string ||
|| HTTPHeader | Адаптер объекта [Request](../concepts/request-ov.md). Передаёт один из заголовков HTTP-запроса. То же самое можно сделать при помощи [Mist-блока](../concepts/block-mist-ov.md). Изменить заголовки запроса нельзя. | специализированный приводимый | string ||
|| HTTPUser | Аутентифицированное имя пользователя. | специальный | string ||
|| IsLight | Возвращает значение "true" для [Lite-пользователей](https://docs.yandex-team.ru/authdevguide/concepts/LiteAuth_About). Для полностью авторизованных и незарегистрированных пользователей возвращает значение "false". | специализированный приводимый | boolean ||
|| LiteAuth | Передаёт объект [LiteAuth](../concepts/auth-ov.md), который содержит информацию об авторизации любого зарегистрированного пользователя с точки зрения Яндекс.Паспорта. | сложный (объект) | Yandex::Auth ||
|| LiteAuthInfo | Облегченный вид LiteAuth, структура из трех полей. | сложный (структура) | Yandex::AuthInfo ||
|| LiteLogin | Адаптер объекта [LiteAuth](../concepts/auth-ov.md). Передает логин для любого зарегистрированного пользователя. | специализированный приводимый | string ||
|| LiteRegName | Содержит логин, который пользователь ввел при регистрации. RegName может отличаться от Login из-за наличия в Паспорте правил, запрещающих использовать в логине определенные символы, которые тем не менее могут быть указаны пользователем при регистрации. Может использоваться для любого зарегистрированного пользователя (полностью авторизованного или [Lite-пользователя](https://docs.yandex-team.ru/authdevguide/concepts/LiteAuth_About)). | специализированный приводимый | string ||
|| LiteUID | Адаптер объекта [LiteAuth](../concepts/auth-ov.md). Передает UID для любого зарегистрированного пользователя. | специализированный приводимый | long long ||
|| LocalArg | Предоставляет доступ к контейнеру LocalArgs, в который записываются параметры [Local-блока](../concepts/block-local-ov.md). | специализированный приводимый | string ||
|| Login | Адаптер объекта [Auth](../concepts/auth-ov.md). Передает логин авторизованного пользователя. | специализированный приводимый | string ||
|| Long | Целочисленный тип данных со знаком (32 бита). | простой | long ||
|| LongLong, Long Long | Целочисленный тип данных расширенного диапазона со знаком (64 бита). | простой | long long ||
|| QueryArg | Aдаптер объекта [Request](../concepts/request-ov.md). Позволяет передать методу один из пользовательских параметров, полученных в URL. | универсальный приводимый | Тип, указанный в атрибуте [as](../concepts/parameters-matching-ov.md#as). По умолчанию - string. ||
|| ProtocolArg | Позволяет использовать переменные окружения протокола FastCGI и содержимое ряда HTTP-заголовков в качестве параметров XScript. | универсальный приводимый | Тип, указанный в атрибуте [as](../concepts/parameters-matching-ov.md#as). По умолчанию - string. ||
|| RegName | Содержит логин, который пользователь ввел при регистрации. RegName может отличаться от Login из-за наличия в Паспорте правил, запрещающих использовать в логине определенные символы, которые тем не менее могут быть указаны пользователем при регистрации. Может использоваться только для полностью авторизованного пользователя. | специализированный приводимый | string ||
|| Request | Передаёт объект [Request](../concepts/request-ov.md), который содержит всю информацию о запросе пользователя. | сложный (объект) | Yandex::Request ||
|| RequestData | Структура, которая является упрощением объекта Request. | сложный (структура) | Yandex::Request:: RequestData ||
|| SecretKey | Содержит секретный ключ, с помощью которого можно подписывать запросы. Ключ генерируется на основании на uid пользователя, а при его отсутствии - на основании yandexuid. При генерации используется шифрование MD5. Ключ действителен с момента генерации в течение текущих и следующих суток. | специализированный приводимый | string ||
|| SecureAuth | Передаёт объект [SecureAuth](../concepts/auth-ov.md), который содержит информацию об авторизации пользователя, запрашивающего страницу, с точки зрения `sauth.yandex.ru`. | сложный (объект) | Yandex::Auth ||
|| SecureUID | Адаптер объекта [SecureAuth](../concepts/auth-ov.md). Передает идентификатор пользователя UID, если пользователь прошел платежную авторизацию. В противном случае возвращает 0. | специализированный приводимый | unsigned long long ||
|| State | Передаёт объект [State](../concepts/state-ov.md), то есть контейнер данных, в котором можно добавлять, хранить и извлекать произвольные данные. | сложный (объект) | Yandex::State ||
|| StateArg | Адаптер объекта [State](../concepts/state-ov.md). Позволяет передать методу одну из ячеек данных, ранее сохранённых в контейнере запроса. | универсальный приводимый | Тип, указанный в атрибуте [as](../concepts/parameters-matching-ov.md#as). По умолчанию - string. ||
|| String | Строковый тип данных. | простой | string ||
|| Tag | Передаёт структуру [Tag](../concepts/tag-ov.md). Управляет параметрами кэширования данного XScript-блока. | сложный (структура) | Yandex::Tag ||
|| UID | Адаптер объекта [Auth](../concepts/auth-ov.md). Передаёт идентификатор пользователя. | специализированный приводимый | unsigned long long ||
|| ULong, Unsigned Long | Целочисленный беззнаковый тип данных (32 бита). | простой | unsigned long ||
|| ULongLong, Unsigned Long Long | Целочисленный беззнаковый тип данных расширенного диапазона (64 бита). | простой | unsigned long long ||
|| VHostArg | Позволяет передать номера портов _noxslt-port_ (при запросе на данный порт не накладываются ни основное, ни перблочные XSL-преобразования) и _alternate-port_ (при запросе на данный порт не накладывается основное XSL-преобразования), а также переменные окружения веб-сервера с префиксом "XSCRIPT_".

Представление переменных окружения в XScript отличается от того вида, в котором они прописаны в конфигурационном файле Lighttpd: строчные (маленькие) буквы заменяются на заглавные (большие), а символ "-" - на подчеркивание ("\_"). Например, переменная окружения `XSCRIPT_super-var` в XScript будет доступна в виде `XSCRIPT_SUPER_VAR`.

При отсутствии запрашиваемой переменной возвращается пустая строка, а при запросе переменной с именем без префикса "XSCRIPT_" - сообщение об ошибке.

Кроме того, с помощью параметра VHostArg можно получить значение параметра [конфигурационного файла](../appendices/config.md). Для этого в качестве значения параметра типа VHostArg необходимо указать путь к интересующей настройке (см. [пример](../concepts/parameters-matching-ov.md#vhostex)). | универсальный приводимый | Тип, указанный в атрибуте [as](../concepts/parameters-matching-ov.md#as). По умолчанию - string.||
|#


### Узнайте больше {#learn-more}
* [Типы параметров](../concepts/parameters-ov.md)
* [Простые типы параметров](../concepts/parameters-simple-ov.md)
* [Объектные и структурные типы параметров](../concepts/parameters-complex-ov.md)
* [Приводимые типы параметров](../concepts/parameters-matching-ov.md)